package com.tydic.dyc.oc.service.saleorder;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.sub.UocProblemSaleItem;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.bo.UocAllocationItemRspBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocCheckMarkItemReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocCheckMarkItemRspBO;
import com.tydic.dyc.oc.utils.IdUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

/**
 * @description 标记问题商品接口
 * @author Luokan
 * @date 2024/12/03
 **/
@HTServiceImpl
public class UocCheckMarkItemServiceImpl implements UocCheckMarkItemService{

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocCheckMarkItemRspBO dealCheckMarkItem(UocCheckMarkItemReqBO reqBO) {
        UocCheckMarkItemRspBO rsp = new UocCheckMarkItemRspBO();
        //入库问题商品记录表
        UocProblemSaleItem uocProblemSaleItem = new UocProblemSaleItem();
        uocProblemSaleItem.setProblemSaleItemId(IdUtil.nextId());
        uocProblemSaleItem.setSaleOrderItemId(reqBO.getSaleOrderItemId());
        uocProblemSaleItem.setSaleOrderId(reqBO.getSaleOrderId());
        uocProblemSaleItem.setOrderId(reqBO.getOrderId());
        uocProblemSaleItem.setFeedbackId(reqBO.getFeedbackId());
        uocProblemSaleItem.setProblemSaleItemType(reqBO.getProblemSaleItemType());
        uocProblemSaleItem.setCheckUserId(reqBO.getCheckUserId());
        uocProblemSaleItem.setCheckName(reqBO.getCheckName());
        uocProblemSaleItem.setCheckMoblePhone(reqBO.getCheckMoblePhone());
        uocProblemSaleItem.setPriceAbnormalFlag(UocConstant.PriceAbnormalFlag.SUBMIT_FEED);
        uocProblemSaleItem.setGoodCheckPrice(reqBO.getGoodCheckPrice());
        uocProblemSaleItem.setReferPriceUrl(reqBO.getReferPriceUrl());
        uocProblemSaleItem.setProblemDesc(reqBO.getProblemDesc());
        if (!CollectionUtils.isEmpty(reqBO.getAccessoryList())) {
            uocProblemSaleItem.setEvidenceAccessory(JSON.toJSONString(reqBO.getAccessoryList()));
        }
        uocProblemSaleItem.setCreateUserId(reqBO.getCheckName());
        uocProblemSaleItem.setCreateUserName(reqBO.getCheckUserId());
        uocProblemSaleItem.setCreateTime(new Date());
        this.iUocSaleOrderModel.insertProblemSaleItem(uocProblemSaleItem);
        //更新明细表
        //先查明细
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderItemId(reqBO.getSaleOrderItemId());
        uocSaleOrderItemQryBo.setOrderId(reqBO.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBO.getSaleOrderId());
        UocSaleOrderDo result = this.iUocSaleOrderModel.getListSaleOrderItem(uocSaleOrderItemQryBo);
        if (CollectionUtils.isEmpty(result.getSaleOrderItems()) || result.getSaleOrderItems().size() != 1) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询销售单明细信息失败");
        }
        UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
        uocSaleOrderItem.setSaleOrderItemId(reqBO.getSaleOrderItemId());
        uocSaleOrderItem.setOrderId(reqBO.getOrderId());
        uocSaleOrderItem.setSaleOrderId(reqBO.getSaleOrderId());
        uocSaleOrderItem.setProblemSaleItemId(uocProblemSaleItem.getProblemSaleItemId());
        uocSaleOrderItem.setFeedbackId(reqBO.getFeedbackId());
        if (null != reqBO.getCheckFlag()) {
            uocSaleOrderItem.setCheckFlag(reqBO.getCheckFlag());
        }else {
            uocSaleOrderItem.setCheckFlag(UocConstant.CheckFlag.PROBLEM_GOODS);
        }
        if("2".equals(reqBO.getFeedbackStateCode())){
            //反馈单编码为2，表示商品无问题直接完成
            uocSaleOrderItem.setPriceAbnormalFlag(UocConstant.PriceAbnormalFlag.NO_ERROR_GOODS);
        }else {
            uocSaleOrderItem.setPriceAbnormalFlag(UocConstant.PriceAbnormalFlag.SUBMIT_FEED);
        }
        if (null != reqBO.getGoodCheckPrice()) {
            uocSaleOrderItem.setGoodCheckPrice(reqBO.getGoodCheckPrice());
            uocSaleOrderItem.setPenaltyCoefficient(reqBO.getPenaltyCoefficient());
            //追加罚款= （(商品单价-商品核查价）* 数量） *罚款系数
            //（商品核查价 即商品核查员反馈价格异常商品填写的 “商品核查价”）
            UocSaleOrderItem saleItem = result.getSaleOrderItems().get(0);
            BigDecimal penaltyFee = (((saleItem.getSalePrice()).multiply(saleItem.getPurchaseCount())).multiply(reqBO.getPenaltyCoefficient())).setScale(2, RoundingMode.HALF_UP);
            uocSaleOrderItem.setPenaltyFee(penaltyFee);
        }
        uocSaleOrderItem.setFeedbackNo(reqBO.getFeedbackNo());
        uocSaleOrderItem.setFeedbackStateCode(reqBO.getFeedbackStateCode());
        uocSaleOrderItem.setFeedbackStateName(reqBO.getFeedbackStateName());
        this.iUocSaleOrderModel.updateSaleOrderItem(uocSaleOrderItem);
        return rsp;
    }
}
