package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleSkuByPlanItemIds;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderMaterialServiceBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderMaterialServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderMaterialServiceRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description:获取物料信息
 * @Copyright: Copyright (c) 2019
 * @author: Ren Wei
 * @date 2024/6/28 17:12
 */
@Slf4j
@HTServiceImpl
public class UocGetSaleOrderMaterialServiceImpl implements UocGetSaleOrderMaterialService {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;


    @Override
    public UocGetSaleOrderMaterialServiceRspBo getSaleOrderItems(UocGetSaleOrderMaterialServiceReqBo reqBo) {
        UocGetSaleOrderMaterialServiceRspBo rspBo = new UocGetSaleOrderMaterialServiceRspBo();
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        if(null != reqBo.getSkuId()){
            uocSaleOrderQryBo.setSkuId(reqBo.getSkuId());
            List<String> Materials =  iUocSaleOrderModel.getMaterialBySkuId(uocSaleOrderQryBo);
            rspBo.setMaterialList(Materials);
            rspBo.setSkuId(reqBo.getSkuId());
        }
        if(!CollectionUtils.isEmpty(reqBo.getPlanItemIds())){
            uocSaleOrderQryBo.setPlanItemIds(reqBo.getPlanItemIds());
            List<UocSaleSkuByPlanItemIds> saleSkuByPlanItemIds = iUocSaleOrderModel.getSaleSkuByPlanItemIds(uocSaleOrderQryBo);
            List<UocGetSaleOrderMaterialServiceBo> saleSkuList = new ArrayList<>();
            if(!CollectionUtils.isEmpty(saleSkuByPlanItemIds)){
                for (UocSaleSkuByPlanItemIds saleSkuByPlanItemId : saleSkuByPlanItemIds) {
                    UocGetSaleOrderMaterialServiceBo bo = new UocGetSaleOrderMaterialServiceBo();
                    bo.setPlanItemId(saleSkuByPlanItemId.getPlanItemId());
                    bo.setSupplierName(saleSkuByPlanItemId.getManagementOrgName());
                    bo.setSkuCode(saleSkuByPlanItemId.getSkuCode());
                    saleSkuList.add(bo);
                }
                rspBo.setSaleSkuList(saleSkuList);
            }
        }
        return  rspBo;
    }
}