package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.bo.UocSyncFeedbackStateReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocSyncFeedbackStateRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;


/**
 * @description 同步反馈单状态接口
 * @author Luokan
 * @date 2025/01/11
 **/
@HTServiceImpl
public class UocSyncFeedbackStateServiceImpl implements UocSyncFeedbackStateService{

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocSyncFeedbackStateRspBO dealSyncFeedbackState(UocSyncFeedbackStateReqBO reqBO) {
        if (null == reqBO.getFeedbackId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "反馈单id不能位空！");
        }
        UocSyncFeedbackStateRspBO rsp = new UocSyncFeedbackStateRspBO();
        UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
        uocSaleOrderItem.setFeedbackId(reqBO.getFeedbackId());
        uocSaleOrderItem.setFeedbackNo(reqBO.getFeedbackNo());
        uocSaleOrderItem.setFeedbackStateCode(reqBO.getFeedbackStateCode());
        uocSaleOrderItem.setFeedbackStateName(reqBO.getFeedbackStateName());
        uocSaleOrderItem.setPriceAbnormalFlag(reqBO.getPriceAbnormalFlag());
        this.iUocSaleOrderModel.updateSaleOrderItem(uocSaleOrderItem);
        return rsp;
    }
}
