package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSyncOrderPayStateReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocSyncOrderPayStateRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @description 付款状态同步
 * @author Luokan
 * @date 2025/01/13
 **/
@HTServiceImpl
public class UocSyncOrderPayStateServiceImpl implements UocSyncOrderPayStateService{

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocSyncOrderPayStateRspBO dealSyncOrderPayState(UocSyncOrderPayStateReqBO reqBO) {
        UocSyncOrderPayStateRspBO rsp = new UocSyncOrderPayStateRspBO();
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBO.getSaleOrderId());
        //支付状态->付款失败
        uocSaleOrderDo.setPayState(reqBO.getPayState());
        iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
        return rsp;
    }
}
