package com.tydic.dyc.oc.transactionservice;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderSupplierConfirmReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderSupplierConfirmRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题：类名称:UocAfterOrderSupplierConfirmServiceImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/5/13 15:20
 * 作者 @author 尹栋梁
 */
@Slf4j
@Component
public class UocAfterOrderSupplierConfirmTransaction {
    @Autowired
    private IUocAfOrderModel afOrderModel;

    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public UocAfterOrderSupplierConfirmRspBo dealAfterOrderSupplierConfirm(UocAfterOrderSupplierConfirmReqBo reqBo) {
        log.info("供应商确认入参：{}", JSON.toJSONString(reqBo));
        UocAfterOrderSupplierConfirmRspBo rspBo = new UocAfterOrderSupplierConfirmRspBo();
        //参数校验
        validateArg(reqBo);
        boolean reConsume = afOrderModel.confirmAfOrderState(reqBo, reqBo.getConfirmflag(), rspBo);
        if (reConsume) {
            // 提交任务
            UocCommonDo uocCommonDo = new UocCommonDo();
            List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<>();
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            taskBo.setTaskId(reqBo.getTaskId());
            taskBos.add(taskBo);
            uocCommonDo.setCompleteTaskInfos(taskBos);
            uocCommonDo.setUserId(11111l);
            uocCommonDo.setOrderId(reqBo.getOrderId());
            iUocCommonModel.dealTask(uocCommonDo);
        } else {
            log.info("重复消费，不提交任务");
            rspBo.setReConsume(false);
        }
        return rspBo;
    }

    private void validateArg(UocAfterOrderSupplierConfirmReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocAfterOrderSupplierConfirmReqBo]不能为空");
        }
    }

}
