package com.tydic.dyc.oc.transactionservice;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSapOrderSendInfo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.saleorder.bo.UocBackSapOrderBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealBackSapOrderReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealBackSapOrderRspBO;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Slf4j
@Component
@Transactional(propagation = Propagation.REQUIRES_NEW)
public class UocDealBackSapOrderTransaction {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;

    public UocDealBackSapOrderRspBO dealBackSapOrder(UocDealBackSapOrderReqBO reqBO) {
        UocDealBackSapOrderRspBO rspBO = UocRu.success(UocDealBackSapOrderRspBO.class);
        rspBO.setErrorFlag(false);
        //推送类型：1 sap订单创建推送 2 sap订单取消推送 3 sap订单创建回调推送
        if (UocConstant.SapPushType.TYPE_1.equals(reqBO.getPushType())) {
            this.doTypeOne(reqBO, rspBO);
        }else if (UocConstant.SapPushType.TYPE_2.equals(reqBO.getPushType())) {
            this.doTypeTwo(reqBO, rspBO);
        }else if (UocConstant.SapPushType.TYPE_3.equals(reqBO.getPushType())) {
            this.doTypeSth(reqBO, rspBO);
        }
        return rspBO;
    }



    private void doTypeSth(UocDealBackSapOrderReqBO reqBO, UocDealBackSapOrderRspBO rspBO) {
        String failValue = null;
        Integer status = UocConstant.SapSendInfoStatus.STATUS_4;
        rspBO.setFlowFlag(true);
        String result = reqBO.getRESULT();
        if ("E".equals(result)) {
            failValue = reqBO.getDESC();
            status = UocConstant.SapSendInfoStatus.STATUS_3;
            rspBO.setFlowFlag(false);
            rspBO.setErrorFlag(true);
        }
        String sapOrderNo = "";
        //查询销售单，查询销售明细
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderNo(reqBO.getRows().get(0).getZddh());
        UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        rspBO.setOrderId(saleOrderMain.getOrderId());
        rspBO.setSaleOrderId(saleOrderMain.getSaleOrderId());
        rspBO.setIsAgrIgnoreArrive(saleOrderMain.getIsAgrIgnoreArrive());
        rspBO.setOrderSource(saleOrderMain.getOrderSource());
        //判断当前销售单状态是正确的
        if (!(UocStateConstants.SaleOrder.XS_QR_EDQR.equals(saleOrderMain.getSaleOrderState()) || UocStateConstants.SaleOrder.XS_XS_SAP.equals(saleOrderMain.getSaleOrderState()) || UocStateConstants.SaleOrder.XS_SP_SPZ.equals(saleOrderMain.getSaleOrderState()))) {
            //状态不对，不处理
            rspBO.setErrorFlag(true);
            rspBO.setFlowFlag(false);
            for (UocBackSapOrderBO row : reqBO.getRows()) {
                row.setSynstatus("E");
                row.setSynresult("重复推送");
            }
            rspBO.setRows(reqBO.getRows());
            //查询并更新推送记录表
            UocSapOrderSendInfo qryUocSapOrderSendInfo = new UocSapOrderSendInfo();
            qryUocSapOrderSendInfo.setOrderId(saleOrderMain.getOrderId());
            qryUocSapOrderSendInfo.setSaleOrderId(saleOrderMain.getSaleOrderId());
            qryUocSapOrderSendInfo.setStatus(UocConstant.SapSendInfoStatus.STATUS_1);
            qryUocSapOrderSendInfo.setPushType(UocConstant.SapPushType.TYPE_1);
            List<UocSapOrderSendInfo> sapSendInfoList = this.iUocSaleOrderModel.getSapSendInfoList(qryUocSapOrderSendInfo);
            UocSapOrderSendInfo updateUocSapOrderSendInfo = new UocSapOrderSendInfo();
            updateUocSapOrderSendInfo.setSendInfoId(sapSendInfoList.get(0).getSendInfoId());
            updateUocSapOrderSendInfo.setOrderId(sapSendInfoList.get(0).getOrderId());
            updateUocSapOrderSendInfo.setSaleOrderId(sapSendInfoList.get(0).getSaleOrderId());
            updateUocSapOrderSendInfo.setStatus(status);
            updateUocSapOrderSendInfo.setSapRspParam(JSON.toJSONString(reqBO.getRows()));
            updateUocSapOrderSendInfo.setReason(failValue);
            //updateUocSapOrderSendInfo.setUpdateTime(new Date());
            updateUocSapOrderSendInfo.setSapOrderNo(sapOrderNo);
            this.iUocSaleOrderModel.updateSapSendInfo(updateUocSapOrderSendInfo);
            return;
        }

        if (UocConstant.SapSendInfoStatus.STATUS_4.equals(status)) {
            //查询任务表，找到最新的一条 判断当前状态，是否为未办理
            UocOrderTaskInst qryInst = new UocOrderTaskInst();
            qryInst.setOrderId(saleOrderMain.getOrderId());
            qryInst.setObjId(saleOrderMain.getSaleOrderId());
            qryInst.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            qryInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocSaleOrderModel.qryTaskInstList(qryInst);
            rspBO.setTaskId(uocOrderTaskInsts.get(0).getTaskInstId());
            //处理已办
            UocCommonDo uocCommonDo = new UocCommonDo();
            List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<>();
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            taskBo.setTaskId(rspBO.getTaskId());
            taskBos.add(taskBo);
            uocCommonDo.setCompleteTaskInfos(taskBos);
            //uocCommonDo.setUserId(reqBo.getUserId());
            //uocCommonDo.setOrderId(reqBo.getOrderId());
            this.iUocCommonModel.dealTask(uocCommonDo);
            //同步sap订单编号和sap订单明细编号
            Map<String, UocBackSapOrderBO> saleOrderItemMap = reqBO.getRows().stream().collect(Collectors.toMap(UocBackSapOrderBO::getZddi, Function.identity()));
            log.info("同步sap订单编号和sap订单明细编号{}", JSON.toJSONString(saleOrderItemMap));
            UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setSaleOrderId(saleOrderMain.getSaleOrderId());
            uocSaleOrderItemQryBo.setOrderId(saleOrderMain.getOrderId());
            List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
            for (UocSaleOrderItem saleOrderItem : saleOrderItemList) {
                UocBackSapOrderBO sapItem = saleOrderItemMap.get(saleOrderItem.getSaleOrderItemIndex());
                log.info("销售单序号{}", JSON.toJSONString(saleOrderItem.getSaleOrderItemIndex()));
                log.info("sap 信息明细{}", JSON.toJSONString(sapItem));
                UocSaleOrderItem updateSaleOrderItem = new UocSaleOrderItem();
                updateSaleOrderItem.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
                updateSaleOrderItem.setOrderId(saleOrderItem.getOrderId());
                updateSaleOrderItem.setSaleOrderId(saleOrderItem.getSaleOrderId());
                updateSaleOrderItem.setSapOrderNo(sapItem.getEbeln());
                updateSaleOrderItem.setSapOrderItemNo(sapItem.getEbelp());
                this.iUocSaleOrderModel.modifyItemPlan(updateSaleOrderItem);
                String planItemNo = saleOrderItem.getPlanItemNo();
                sapItem.setBanfn(saleOrderItem.getPlanItemNo());
                //通过-分割
                String[] split = planItemNo.split("-");
                sapItem.setBnfpo(split[1]);
                sapItem.setSynresult("成功");
                sapItem.setSynstatus("S");
                sapOrderNo = updateSaleOrderItem.getSapOrderNo();
            }
            rspBO.setRows(reqBO.getRows());
        }
        //查询并更新推送记录表
        UocSapOrderSendInfo qryUocSapOrderSendInfo = new UocSapOrderSendInfo();
        qryUocSapOrderSendInfo.setOrderId(saleOrderMain.getOrderId());
        qryUocSapOrderSendInfo.setSaleOrderId(saleOrderMain.getSaleOrderId());
        qryUocSapOrderSendInfo.setStatus(UocConstant.SapSendInfoStatus.STATUS_1);
        qryUocSapOrderSendInfo.setPushType(UocConstant.SapPushType.TYPE_1);
        List<UocSapOrderSendInfo> sapSendInfoList = this.iUocSaleOrderModel.getSapSendInfoList(qryUocSapOrderSendInfo);
        if(CollectionUtils.isEmpty(sapSendInfoList)){
            qryUocSapOrderSendInfo.setOrderId(saleOrderMain.getOrderId());
            qryUocSapOrderSendInfo.setSaleOrderId(saleOrderMain.getSaleOrderId());
            qryUocSapOrderSendInfo.setStatus(UocConstant.SapSendInfoStatus.STATUS_3);
            qryUocSapOrderSendInfo.setPushType(UocConstant.SapPushType.TYPE_1);
            sapSendInfoList = this.iUocSaleOrderModel.getSapSendInfoList(qryUocSapOrderSendInfo);
        }
        UocSapOrderSendInfo updateUocSapOrderSendInfo = new UocSapOrderSendInfo();
        updateUocSapOrderSendInfo.setSendInfoId(sapSendInfoList.get(0).getSendInfoId());
        updateUocSapOrderSendInfo.setOrderId(sapSendInfoList.get(0).getOrderId());
        updateUocSapOrderSendInfo.setSaleOrderId(sapSendInfoList.get(0).getSaleOrderId());
        updateUocSapOrderSendInfo.setStatus(status);
        updateUocSapOrderSendInfo.setSapRspParam(JSON.toJSONString(reqBO.getRows()));
        updateUocSapOrderSendInfo.setReason(failValue);
        //updateUocSapOrderSendInfo.setUpdateTime(new Date());
        updateUocSapOrderSendInfo.setSapOrderNo(sapOrderNo);
        this.iUocSaleOrderModel.updateSapSendInfo(updateUocSapOrderSendInfo);

        //如果跳过发货和到货确认需要生成发货单
        if(UocConstant.SapSendInfoStatus.STATUS_4.equals(status)){
            if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrderMain.getOrderSource()) && 1 == saleOrderMain.getIsAgrIgnoreArrive() && UocDicConstant.PURCHASE_MODE.PLAN.equals(saleOrderMain.getPurchaseMode())) {
                this.createShipOrder(saleOrderMain, rspBO);
                //更新销售单状态为已到货
                UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
                updateSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_DH_DH);
                updateSaleOrderDo.setOrderId(saleOrderMain.getOrderId());
                updateSaleOrderDo.setSaleOrderId(saleOrderMain.getSaleOrderId());
                iUocSaleOrderModel.modifySaleOrderMain(updateSaleOrderDo);
            }
        }
    }
    private void createShipOrder(UocSaleOrderDo saleOrderDo, UocDealBackSapOrderRspBO rspBO) {
        //生成发货单id
        Long shipOrderId = IdUtil.nextId();
        UocShipOrderDo createShipOrderDo = new UocShipOrderDo();
        //设置发货单状态
        createShipOrderDo.setShipOrderState(UocStateConstants.ShipOrder.FH_FH_YSH);
        //设置发货人id
        createShipOrderDo.setShipOperId(saleOrderDo.getCreateOperId());
        //设置订单id
        createShipOrderDo.setOrderId(saleOrderDo.getOrderId());
        //设置销售单id
        createShipOrderDo.setSaleOrderId(saleOrderDo.getSaleOrderId());
        //设置发货单创建人
        createShipOrderDo.setCreateOperId(saleOrderDo.getCreateOperId());
        //设置发货单创建时间
        createShipOrderDo.setCreateTime(new Date());
        //设置发货单id
        createShipOrderDo.setShipOrderId(shipOrderId);
        //设置发货单编号
        createShipOrderDo.setShipOrderNo(this.getShipOrderNo());
        //到货时间
        createShipOrderDo.setArriveTime(new Date());
        createShipOrderDo.setReceiverTime(new Date());
        createShipOrderDo.setShipTime(new Date());
        createShipOrderDo.setEstimateArrivalTime(new Date());
        //查询销售明细用于生成发货单列表
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(saleOrderDo.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(saleOrderDo.getSaleOrderId());
        List<UocSaleOrderItem> saleOrderItems = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
        updateSaleOrderDo.setOrderId(saleOrderDo.getOrderId());
        updateSaleOrderDo.setSaleOrderId(saleOrderDo.getSaleOrderId());
        updateSaleOrderDo.setSaleOrderItems(saleOrderItems);
        //设置发货单明细
        List<UocShipOrderItem> shipOrderItemBoList = new ArrayList<>();
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
            //设置发货单id
            uocShipOrderItem.setShipOrderId(shipOrderId);
            //设置订单id
            uocShipOrderItem.setOrderId(saleOrderDo.getOrderId());
            //设置销售单id
            uocShipOrderItem.setSaleOrderId(saleOrderDo.getSaleOrderId());
            //设置销售单明细id
            uocShipOrderItem.setSaleOrderItemId(saleOrderItem.getSaleOrderItemId());
            //设置计量单位
            uocShipOrderItem.setUnitName(saleOrderItem.getUnitName());
            //设置创建人id
            uocShipOrderItem.setCreateOperId(saleOrderDo.getCreateOperId());
            //设置创建时间
            uocShipOrderItem.setCreateTime(new Date());
            //设置发货单明细id
            uocShipOrderItem.setShipOrderItemId(IdUtil.nextId());
            //发货数量
            uocShipOrderItem.setSendCount(saleOrderItem.getPurchaseCount());
            //到货数量
            uocShipOrderItem.setArriveCount(saleOrderItem.getPurchaseCount());
            shipOrderItemBoList.add(uocShipOrderItem);
            saleOrderItem.setSendCount(saleOrderItem.getPurchaseCount());
            saleOrderItem.setArriveCount(saleOrderItem.getPurchaseCount());
            //更新到货数量
            this.iUocSaleOrderModel.modifySaleOrderItemAfterServingCount(saleOrderItem);
        }
        //设置发货明细
        createShipOrderDo.setShipOrderItemBoList(shipOrderItemBoList);
        //设置供应商id
        createShipOrderDo.setSupNo(saleOrderItems.get(0).getSupplierId());
        //生产发货单
        this.iUocShipOrderModel.createShipOrder(createShipOrderDo);
        //更新销售明细发货数量
        this.iUocSaleOrderModel.modifyBatchItemSendCount(updateSaleOrderDo);
        rspBO.setShipOrderId(shipOrderId);
    }

    private String getShipOrderNo() {
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setOrderSource(UocDicConstant.ORDER_SOURCE.AGR_GENERATE);
        uocShipOrderDo = this.iUocShipOrderModel.getShipOrderNo(uocShipOrderDo);
        if (null != uocShipOrderDo) {
            return uocShipOrderDo.getShipOrderNo();
        } else {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "生成发货单编号失败");
        }
    }


    private void doTypeTwo(UocDealBackSapOrderReqBO reqBO, UocDealBackSapOrderRspBO rspBO) {
        //先更新之前的状态为废弃
        UocSapOrderSendInfo updateInfo = new UocSapOrderSendInfo();
        updateInfo.setOrderId(reqBO.getOrderId());
        updateInfo.setSaleOrderId(reqBO.getSaleOrderId());
        updateInfo.setStatus(UocConstant.SapSendInfoStatus.STATUS_5);
        this.iUocSaleOrderModel.updateSapSendInfo(updateInfo);
        //查询销售单
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBO.getOrderId());
        uocSaleOrderQryBo.setSaleOrderId(reqBO.getSaleOrderId());
        UocSaleOrderDo saleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        rspBO.setOrderId(saleOrderDo.getOrderId());
        rspBO.setSaleOrderId(saleOrderDo.getSaleOrderId());
        //查询销售明细
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(reqBO.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(reqBO.getOrderId());
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        //查询任务实例
        UocApprovalObjQryBo selectuocApprovalObjQryBo = new UocApprovalObjQryBo();
        Long upperOrderId = saleOrderDo.getUpperOrderId();
        if (null == upperOrderId) {
            selectuocApprovalObjQryBo.setObjId(reqBO.getSaleOrderId().toString());
        }else{
            selectuocApprovalObjQryBo.setObjId(upperOrderId.toString());
        }
        selectuocApprovalObjQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        selectuocApprovalObjQryBo.setOrderId(reqBO.getOrderId());
        List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(selectuocApprovalObjQryBo);
        UocOrderTaskInst qryInst = new UocOrderTaskInst();
        qryInst.setOrderId(reqBO.getOrderId());
        qryInst.setObjId(uocApprovalObjs.get(0).getAuditOrderId());
        qryInst.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        qryInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.FINISHED);
        List<UocOrderTaskInst> auditOrderTaskInsts = iUocSaleOrderModel.qryTaskInstList(qryInst);
        UocSapOrderSendInfo uocSapOrderSendInfo = new UocSapOrderSendInfo();
        uocSapOrderSendInfo.setSendInfoId(IdUtil.nextId());
        uocSapOrderSendInfo.setOrderId(reqBO.getOrderId());
        uocSapOrderSendInfo.setSaleOrderId(reqBO.getSaleOrderId());
        uocSapOrderSendInfo.setPlatformName(reqBO.getPlatformName());
        uocSapOrderSendInfo.setPlatformNo(reqBO.getPlatformNo());
        Integer status = UocConstant.SapSendInfoStatus.STATUS_1;
        if ("E".equals(reqBO.getRESULT())) {
            status = UocConstant.SapSendInfoStatus.STATUS_2;
        }
        uocSapOrderSendInfo.setStatus(status);
        uocSapOrderSendInfo.setPushType(UocConstant.SapPushType.TYPE_2);
        uocSapOrderSendInfo.setPushRspParam(reqBO.getDESC());
        uocSapOrderSendInfo.setReason(reqBO.getDESC());
        uocSapOrderSendInfo.setCreateTime(saleOrderDo.getCreateTime());
        uocSapOrderSendInfo.setUpdateTime(new Date());
        uocSapOrderSendInfo.setSaleOrderNo(saleOrderDo.getSaleOrderNo());
        uocSapOrderSendInfo.setSaleOrderName(saleOrderDo.getSaleOrderName());
        //同一审批人自动审批通过的时候，没有审批人字段
        if (!CollectionUtils.isEmpty(auditOrderTaskInsts)) {
            uocSapOrderSendInfo.setPurchaseUserId(Long.valueOf(auditOrderTaskInsts.get(0).getDealOperId()));
            uocSapOrderSendInfo.setPurchaseUserName(auditOrderTaskInsts.get(0).getDealOperName());
        }else {
            uocSapOrderSendInfo.setPurchaseUserId(Long.valueOf(saleOrderDo.getCreateOperId()));
            uocSapOrderSendInfo.setPurchaseUserName(saleOrderDo.getCreateOperName());
        }
        uocSapOrderSendInfo.setPurchaseOrgId(Long.valueOf(saleOrderDo.getStakeholder().getPurOrgId()));
        uocSapOrderSendInfo.setPurchaseOrgName(saleOrderDo.getStakeholder().getPurOrgName());
        uocSapOrderSendInfo.setPurUserName(saleOrderDo.getCreateOperName());
        uocSapOrderSendInfo.setPurUserId(Long.valueOf(saleOrderDo.getCreateOperId()));
        uocSapOrderSendInfo.setSupplierId(Long.valueOf(saleOrderDo.getStakeholder().getSupId()));
        uocSapOrderSendInfo.setSupplierName(saleOrderDo.getStakeholder().getSupName());
        uocSapOrderSendInfo.setPurCompanyId(saleOrderDo.getStakeholder().getPurCompanyId());
        uocSapOrderSendInfo.setPurCompanyName(saleOrderDo.getStakeholder().getPurCompanyName());
        uocSapOrderSendInfo.setCreateOrderName(saleOrderDo.getCreateOperName());
        uocSapOrderSendInfo.setOrderSource(saleOrderDo.getOrderSource());
        uocSapOrderSendInfo.setSapOrderNo(saleOrderItemList.get(0).getSapOrderNo());
        this.iUocSaleOrderModel.insertSapSendInfo(uocSapOrderSendInfo);
    }

    private void doTypeOne(UocDealBackSapOrderReqBO reqBO, UocDealBackSapOrderRspBO rspBO) {
        //先更新之前的状态为废弃
        UocSapOrderSendInfo updateInfo = new UocSapOrderSendInfo();
        updateInfo.setOrderId(reqBO.getOrderId());
        updateInfo.setSaleOrderId(reqBO.getSaleOrderId());
        updateInfo.setStatus(UocConstant.SapSendInfoStatus.STATUS_5);
        this.iUocSaleOrderModel.updateSapSendInfo(updateInfo);
        //查询销售单
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBO.getOrderId());
        uocSaleOrderQryBo.setSaleOrderId(reqBO.getSaleOrderId());
        UocSaleOrderDo saleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        rspBO.setOrderId(saleOrderDo.getOrderId());
        rspBO.setSaleOrderId(saleOrderDo.getSaleOrderId());
        //查询任务实例
        UocApprovalObjQryBo selectuocApprovalObjQryBo = new UocApprovalObjQryBo();
        selectuocApprovalObjQryBo.setObjId(reqBO.getSaleOrderId().toString());
        selectuocApprovalObjQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        selectuocApprovalObjQryBo.setOrderId(reqBO.getOrderId());
        List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(selectuocApprovalObjQryBo);
        UocOrderTaskInst qryInst = new UocOrderTaskInst();
        qryInst.setOrderId(reqBO.getOrderId());
        qryInst.setObjId(uocApprovalObjs.get(0).getAuditOrderId());
        qryInst.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        qryInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.FINISHED);
        List<UocOrderTaskInst> auditOrderTaskInsts = iUocSaleOrderModel.qryTaskInstList(qryInst);
        UocSapOrderSendInfo uocSapOrderSendInfo = new UocSapOrderSendInfo();
        uocSapOrderSendInfo.setSendInfoId(IdUtil.nextId());
        uocSapOrderSendInfo.setOrderId(reqBO.getOrderId());
        uocSapOrderSendInfo.setSaleOrderId(reqBO.getSaleOrderId());
        uocSapOrderSendInfo.setPlatformName(reqBO.getPlatformName());
        uocSapOrderSendInfo.setPlatformNo(reqBO.getPlatformNo());
        Integer status = UocConstant.SapSendInfoStatus.STATUS_1;
        if ("E".equals(reqBO.getRESULT())) {
            status = UocConstant.SapSendInfoStatus.STATUS_2;
            rspBO.setErrorFlag(true);
        }
        uocSapOrderSendInfo.setStatus(status);
        uocSapOrderSendInfo.setPushType(UocConstant.SapPushType.TYPE_1);
        uocSapOrderSendInfo.setPushRspParam(reqBO.getDESC());
        uocSapOrderSendInfo.setReason(reqBO.getDESC());
        uocSapOrderSendInfo.setCreateTime(saleOrderDo.getCreateTime());
        uocSapOrderSendInfo.setUpdateTime(new Date());
        uocSapOrderSendInfo.setSaleOrderNo(saleOrderDo.getSaleOrderNo());
        uocSapOrderSendInfo.setOrderSource(saleOrderDo.getOrderSource());
        uocSapOrderSendInfo.setSaleOrderName(saleOrderDo.getSaleOrderName());
        //同一审批人自动审批通过的时候，没有审批人字段
        if (!CollectionUtils.isEmpty(auditOrderTaskInsts)) {
            uocSapOrderSendInfo.setPurchaseUserId(Long.valueOf(auditOrderTaskInsts.get(0).getDealOperId()));
            uocSapOrderSendInfo.setPurchaseUserName(auditOrderTaskInsts.get(0).getDealOperName());
        }else {
            uocSapOrderSendInfo.setPurchaseUserId(Long.valueOf(saleOrderDo.getCreateOperId()));
            uocSapOrderSendInfo.setPurchaseUserName(saleOrderDo.getCreateOperName());
        }
        uocSapOrderSendInfo.setPurchaseOrgId(Long.valueOf(saleOrderDo.getStakeholder().getPurOrgId()));
        uocSapOrderSendInfo.setPurchaseOrgName(saleOrderDo.getStakeholder().getPurOrgName());
        uocSapOrderSendInfo.setPurUserName(saleOrderDo.getCreateOperName());
        uocSapOrderSendInfo.setPurUserId(Long.valueOf(saleOrderDo.getCreateOperId()));
        uocSapOrderSendInfo.setSupplierId(Long.valueOf(saleOrderDo.getStakeholder().getSupId()));
        uocSapOrderSendInfo.setSupplierName(saleOrderDo.getStakeholder().getSupName());
        uocSapOrderSendInfo.setPurCompanyId(saleOrderDo.getStakeholder().getPurCompanyId());
        uocSapOrderSendInfo.setPurCompanyName(saleOrderDo.getStakeholder().getPurCompanyName());
        uocSapOrderSendInfo.setCreateOrderName(saleOrderDo.getCreateOperName());
        uocSapOrderSendInfo.setOrderSource(saleOrderDo.getOrderSource());
        this.iUocSaleOrderModel.insertSapSendInfo(uocSapOrderSendInfo);
    }
}
