/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.domainservice.UocAfterOrderFinishConfirmService;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderFinishConfirmReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderFinishConfirmRspBo;
import com.tydic.dyc.oc.transactionservice.UocAfterOrderFinishConfirmTransaction;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocAfterOrderFinishConfirmService"})
public class UocAfterOrderFinishConfirmServiceImpl
implements UocAfterOrderFinishConfirmService {
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocAfterOrderFinishConfirmTransaction uocAfterOrderFinishConfirmTransaction;

    @PostMapping(value={"finishConfirmAfterOrder"})
    public UocAfterOrderFinishConfirmRspBo finishConfirmAfterOrder(@RequestBody UocAfterOrderFinishConfirmReqBo reqBo) {
        UocAfterOrderFinishConfirmRspBo rspBo = this.uocAfterOrderFinishConfirmTransaction.finishConfirmAfterOrder(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocAfterOrderFinishConfirmReqBo reqBo, UocAfterOrderFinishConfirmRspBo rspBo) {
        ArrayList<SyncEsRunnableBo> syncEsRunnableBoList = new ArrayList<SyncEsRunnableBo>();
        SyncEsRunnableBo syncSaleEsRunnableBo = new SyncEsRunnableBo();
        syncSaleEsRunnableBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        syncSaleEsRunnableBo.setOrderId(reqBo.getOrderId());
        syncSaleEsRunnableBo.setObjId(rspBo.getSaleOrderId());
        syncSaleEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        syncEsRunnableBoList.add(syncSaleEsRunnableBo);
        SyncEsRunnableBo syncShipEsRunnableBo = new SyncEsRunnableBo();
        syncShipEsRunnableBo.setIndexName(this.uocIndexConfig.getShipOrderIndex());
        syncShipEsRunnableBo.setOrderId(reqBo.getOrderId());
        syncShipEsRunnableBo.setObjId(rspBo.getShipOrderId());
        syncShipEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        syncEsRunnableBoList.add(syncShipEsRunnableBo);
        SyncEsRunnableBo syncAfEsRunnableBo = new SyncEsRunnableBo();
        syncAfEsRunnableBo.setIndexName(this.uocIndexConfig.getAfOrderIndex());
        syncAfEsRunnableBo.setOrderId(reqBo.getOrderId());
        syncAfEsRunnableBo.setObjId(reqBo.getAfOrderId());
        syncAfEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        syncEsRunnableBoList.add(syncAfEsRunnableBo);
        for (Long shipOrderId : rspBo.getShipOrderIdList()) {
            SyncEsRunnableBo syncBatchShipEsRunnableBo = new SyncEsRunnableBo();
            syncBatchShipEsRunnableBo.setIndexName(this.uocIndexConfig.getShipOrderIndex());
            syncBatchShipEsRunnableBo.setOrderId(reqBo.getOrderId());
            syncBatchShipEsRunnableBo.setObjId(shipOrderId);
            syncBatchShipEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            syncEsRunnableBoList.add(syncBatchShipEsRunnableBo);
        }
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(syncEsRunnableBoList));
    }
}

