/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderItemQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.cmporder.IUocCmpOrderModel;
import com.tydic.dyc.oc.model.cmporder.qrybo.UocCmpOrderQryBo;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSapInspResult;
import com.tydic.dyc.oc.model.saleorder.sub.UocSapInspTask;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.domainservice.UocArchivistDataQryService;
import com.tydic.dyc.oc.service.domainservice.bo.UocArchivistAfOrderBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArchivistAfOrderItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArchivistCmpOrderBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArchivistDataQryReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArchivistDataQryRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArchivistInspOrderBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArchivistInspOrderItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArchivistOrderAccessoryBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArchivistOrderTaskBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArchivistSaleOrderBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArchivistSaleOrderItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArchivistSaleStakeholderBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArchivistSapInspTaskBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocArchivistDataQryService"})
public class UocArchivistDataQryServiceImpl
implements UocArchivistDataQryService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;
    @Autowired
    private IUocCmpOrderModel iUocCmpOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    public static final Integer PURCHASE_MODE_SAP = 1;

    @PostMapping(value={"qryArchivistData"})
    public UocArchivistDataQryRspBo qryArchivistData(@RequestBody UocArchivistDataQryReqBo reqBo) {
        UocArchivistDataQryRspBo rspBo = new UocArchivistDataQryRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        if (null != uocSaleOrderDo) {
            rspBo.setUocArchivistSaleOrderBo((UocArchivistSaleOrderBo)JUtil.js((Object)((Object)uocSaleOrderDo), UocArchivistSaleOrderBo.class));
            rspBo.setUocArchivistSaleStakeholderBo((UocArchivistSaleStakeholderBo)JUtil.js((Object)uocSaleOrderDo.getStakeholder(), UocArchivistSaleStakeholderBo.class));
            ArrayList<String> pCodes = new ArrayList<String>();
            pCodes.add("ZONE_TYPE");
            Map<String, Map<String, String>> areaTypeMaps = this.iUocSysDictionaryModel.getDictionaryMap(pCodes);
            Map<String, String> areaTypeMap = areaTypeMaps.get("ZONE_TYPE");
            if (null != rspBo.getUocArchivistSaleOrderBo().getAreaType()) {
                rspBo.getUocArchivistSaleOrderBo().setAreaTypeStr(areaTypeMap.get(rspBo.getUocArchivistSaleOrderBo().getAreaType().toString()));
            }
            UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
            List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
            if (!CollectionUtils.isEmpty(saleOrderItemList)) {
                rspBo.getUocArchivistSaleOrderBo().setUocArchivistSaleOrderItemBoList(JUtil.jsl(saleOrderItemList, UocArchivistSaleOrderItemBo.class));
                if (PURCHASE_MODE_SAP.equals(rspBo.getUocArchivistSaleOrderBo().getPurchaseMode())) {
                    this.setSapInfo(rspBo, saleOrderItemList);
                }
                if (UocConstant.orderSource.ELC.equals(uocSaleOrderDo.getOrderSource())) {
                    this.setOaAttach(reqBo, rspBo);
                    this.setCmpOrder(rspBo, saleOrderItemList);
                }
            }
            this.setInspOrder(reqBo, rspBo);
            this.setAfOrder(reqBo, rspBo);
            this.setTask(rspBo, uocSaleOrderDo);
        }
        return rspBo;
    }

    private void setOaAttach(UocArchivistDataQryReqBo reqBo, UocArchivistDataQryRspBo rspBo) {
        UocOrderAccessoryQryBo uocOrderAccessoryQryBo = new UocOrderAccessoryQryBo();
        uocOrderAccessoryQryBo.setObjId(reqBo.getSaleOrderId());
        uocOrderAccessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocOrderAccessoryQryBo.setAttachmentType(UocAttachementTypeConstants.OA_APPROVAL_RESULT);
        List<UocOrderAccessory> orderAccessoryList = this.iUocOrderModel.getOrderAccessoryList(uocOrderAccessoryQryBo);
        if (!CollectionUtils.isEmpty(orderAccessoryList)) {
            rspBo.getUocArchivistSaleOrderBo().setUocArchivistOrderAccessoryBoList(JUtil.jsl(orderAccessoryList, UocArchivistOrderAccessoryBo.class));
        }
    }

    private void setSapInfo(UocArchivistDataQryRspBo rspBo, List<UocSaleOrderItem> saleOrderItemList) {
        List<UocSaleOrderItem> sapSaleOrderItemList = saleOrderItemList.stream().filter(o -> !StringUtils.isBlank((CharSequence)o.getSapOrderItemNo()) && !StringUtils.isBlank((CharSequence)o.getSapOrderNo())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(sapSaleOrderItemList)) {
            ArrayList<UocSapInspTask> uocSapInspTasks = new ArrayList<UocSapInspTask>();
            sapSaleOrderItemList.forEach(uocSaleOrderItem -> {
                UocSapInspTask uocSapInspTask = new UocSapInspTask();
                uocSapInspTask.setEbeln(uocSaleOrderItem.getSapOrderNo());
                uocSapInspTask.setEbelp(uocSaleOrderItem.getSapOrderItemNo());
                uocSapInspTasks.add(uocSapInspTask);
            });
            List<UocSapInspTask> uocSapInspTaskList = this.iUocSaleOrderModel.getSapTaskList(uocSapInspTasks);
            if (!CollectionUtils.isEmpty(uocSapInspTaskList)) {
                Map<Object, Object> ysbhMap = new HashMap();
                ArrayList<UocSapInspResult> uocSapInspResults = new ArrayList<UocSapInspResult>();
                for (UocSapInspTask uocSapInspTask : uocSapInspTaskList) {
                    UocSapInspResult uocSapInspResult = new UocSapInspResult();
                    uocSapInspResult.setZysbh(uocSapInspTask.getZysbh());
                    uocSapInspResult.setZysh(uocSapInspTask.getZysh());
                    uocSapInspResults.add(uocSapInspResult);
                }
                List<UocSapInspResult> sapResultList = this.iUocSaleOrderModel.getSapResultList(uocSapInspResults);
                if (!CollectionUtils.isEmpty(sapResultList)) {
                    ysbhMap = sapResultList.stream().collect(Collectors.groupingBy(UocSapInspResult::getYsCodeLine));
                }
                Map<String, UocSapInspTask> sapTaskMap = uocSapInspTaskList.stream().collect(Collectors.toMap(UocSapInspTask::getEbelnp, o -> o, (o1, o2) -> o1));
                for (UocArchivistSaleOrderItemBo uocArchivistSaleOrderItemBo : rspBo.getUocArchivistSaleOrderBo().getUocArchivistSaleOrderItemBoList()) {
                    String np = uocArchivistSaleOrderItemBo.getSapOrderNo() + uocArchivistSaleOrderItemBo.getSapOrderItemNo();
                    if (!sapTaskMap.containsKey(np)) continue;
                    uocArchivistSaleOrderItemBo.setUocArchivistSapInspTaskBo((UocArchivistSapInspTaskBo)JUtil.js((Object)sapTaskMap.get(np), UocArchivistSapInspTaskBo.class));
                    String ysCodeLine = uocArchivistSaleOrderItemBo.getUocArchivistSapInspTaskBo().getZysbh() + uocArchivistSaleOrderItemBo.getUocArchivistSapInspTaskBo().getZysh();
                    if (!ysbhMap.containsKey(ysCodeLine)) continue;
                    List sapInspResultList = (List)ysbhMap.get(ysCodeLine);
                    JSONObject sapInspResultJsonObj = new JSONObject();
                    for (UocSapInspResult uocSapInspResult : sapInspResultList) {
                        sapInspResultJsonObj.put("a" + uocSapInspResult.getZyszb().trim(), (Object)uocSapInspResult.getZysjgms());
                        sapInspResultJsonObj.put("at" + uocSapInspResult.getZyszb().trim(), (Object)uocSapInspResult.getZysjg());
                    }
                    uocArchivistSaleOrderItemBo.setUocArchivistSapInspResultBo(sapInspResultJsonObj);
                }
            }
        }
    }

    private void setTask(UocArchivistDataQryRspBo rspBo, UocSaleOrderDo uocSaleOrderDo) {
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setObjId(uocSaleOrderDo.getSaleOrderId().toString());
        uocApprovalObjQryBo.setObjType(2);
        List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        if (!CollectionUtils.isEmpty(uocApprovalObjs)) {
            UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
            uocOrderTaskInst.setObjId(uocApprovalObjs.get(0).getAuditOrderId());
            uocOrderTaskInst.setObjType(9);
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocCommonModel.qryTaskInst(uocOrderTaskInst);
            if (!CollectionUtils.isEmpty(uocOrderTaskInsts)) {
                Optional<UocOrderTaskInst> max = uocOrderTaskInsts.stream().filter(o -> null != o.getFinishTime()).max(Comparator.comparing(UocOrderTaskInst::getFinishTime));
                max.ifPresent(taskInst -> rspBo.getUocArchivistSaleOrderBo().setUocArchivistOrderTaskBo((UocArchivistOrderTaskBo)JUtil.js((Object)taskInst, UocArchivistOrderTaskBo.class)));
            }
        }
    }

    private void setCmpOrder(UocArchivistDataQryRspBo rspBo, List<UocSaleOrderItem> saleOrderItemList) {
        List cmpOrderNoList = saleOrderItemList.stream().map(UocSaleOrderItem::getCmpOrderNo).filter(cmpOrderNo -> !StringUtils.isBlank((CharSequence)cmpOrderNo)).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(cmpOrderNoList)) {
            UocCmpOrderQryBo uocCmpOrderQryBo = new UocCmpOrderQryBo();
            uocCmpOrderQryBo.setCmpOrderNoList(saleOrderItemList.stream().map(UocSaleOrderItem::getCmpOrderNo).distinct().collect(Collectors.toList()));
            List<UocCmpOrderQryBo> uocCmpOrderQryBos = this.iUocCmpOrderModel.qryCmpOrderList(uocCmpOrderQryBo);
            if (!CollectionUtils.isEmpty(uocCmpOrderQryBos)) {
                rspBo.setUocArchivistCmpOrderBoList(JUtil.jsl(uocCmpOrderQryBos, UocArchivistCmpOrderBo.class));
            }
        }
    }

    private void setInspOrder(UocArchivistDataQryReqBo reqBo, UocArchivistDataQryRspBo rspBo) {
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocInspOrderDo> inspOrderDoList = this.iUocInspOrderModel.getListInspOrder(uocInspOrderQryBo);
        if (!CollectionUtils.isEmpty(inspOrderDoList)) {
            rspBo.setUocArchivistInspOrderBoList(JUtil.jsl(inspOrderDoList, UocArchivistInspOrderBo.class));
            UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
            uocInspOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
            UocInspOrderDo uocInspOrderDo = this.iUocInspOrderModel.getInspOrderItemList(uocInspOrderItemQryBo);
            if (!CollectionUtils.isEmpty(uocInspOrderDo.getUocInspOrderItemList())) {
                ConcurrentMap<Long, List<UocInspOrderItem>> inspOrderMap = uocInspOrderDo.getUocInspOrderItemList().stream().collect(Collectors.groupingByConcurrent(UocInspOrderItem::getInspOrderId));
                for (UocArchivistInspOrderBo uocArchivistInspOrderBo : rspBo.getUocArchivistInspOrderBoList()) {
                    if (!inspOrderMap.containsKey(uocArchivistInspOrderBo.getInspOrderId())) continue;
                    List uocInspOrderItems = (List)inspOrderMap.get(uocArchivistInspOrderBo.getInspOrderId());
                    uocArchivistInspOrderBo.setUocArchivistInspOrderItemBoList(JUtil.jsl((List)uocInspOrderItems, UocArchivistInspOrderItemBo.class));
                }
            }
        }
    }

    private void setAfOrder(UocArchivistDataQryReqBo reqBo, UocArchivistDataQryRspBo rspBo) {
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        uocAfOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocAfOrderQryBo.setServState(UocDicConstant.SERVICE_STATE.COMPLATE);
        List<UocAfOrder> afOrderList = this.iUocAfOrderModel.getAfOrderList(uocAfOrderQryBo);
        if (!CollectionUtils.isEmpty(afOrderList)) {
            rspBo.setUocArchivistAfOrderBoList(JUtil.jsl(afOrderList, UocArchivistAfOrderBo.class));
            UocAfOrderItemQryBo uocAfOrderItemQryBo = new UocAfOrderItemQryBo();
            uocAfOrderItemQryBo.setAfOrderIds(afOrderList.stream().map(UocAfOrder::getAfOrderId).collect(Collectors.toList()));
            uocAfOrderItemQryBo.setOrderBy("create_time");
            List<UocAfOrderItem> afOrderItemList = this.iUocAfOrderModel.getAfOrderItemList(uocAfOrderItemQryBo);
            if (!CollectionUtils.isEmpty(afOrderItemList)) {
                ConcurrentMap<Long, List<UocAfOrderItem>> afOrderMap = afOrderItemList.stream().collect(Collectors.groupingByConcurrent(UocAfOrderItem::getAfOrderId));
                for (UocArchivistAfOrderBo uocArchivistAfOrderBo : rspBo.getUocArchivistAfOrderBoList()) {
                    if (!afOrderMap.containsKey(uocArchivistAfOrderBo.getAfOrderId())) continue;
                    List uocAfOrderItems = (List)afOrderMap.get(uocArchivistAfOrderBo.getAfOrderId());
                    uocArchivistAfOrderBo.setUocArchivistAfOrderItemBoList(JUtil.jsl((List)uocAfOrderItems, UocArchivistAfOrderItemBo.class));
                }
                if (!CollectionUtils.isEmpty((Collection)rspBo.getUocArchivistSaleOrderBo().getUocArchivistSaleOrderItemBoList())) {
                    List afOrderIds = afOrderList.stream().filter(o -> o.getServType().equals(20)).map(UocAfOrder::getAfOrderId).collect(Collectors.toList());
                    ConcurrentMap<Long, BigDecimal> skuReturnCountMap = afOrderItemList.stream().filter(o -> afOrderIds.contains(o.getAfOrderId())).collect(Collectors.groupingByConcurrent(UocAfOrderItem::getSkuId, Collectors.reducing(BigDecimal.ZERO, UocAfOrderItem::getReturnCount, BigDecimal::add)));
                    for (UocArchivistSaleOrderItemBo uocArchivistSaleOrderItemBo : rspBo.getUocArchivistSaleOrderBo().getUocArchivistSaleOrderItemBoList()) {
                        uocArchivistSaleOrderItemBo.setReplaceCount((BigDecimal)skuReturnCountMap.get(Convert.toLong((Object)uocArchivistSaleOrderItemBo.getSkuId())));
                    }
                }
            }
            ArrayList<String> pCodes = new ArrayList<String>();
            pCodes.add("UOC_ORD_SERVICE_TYPE");
            Map<String, Map<String, String>> dictionaryMap = this.iUocSysDictionaryModel.getDictionaryMap(pCodes);
            Map<String, String> stringStringMap = dictionaryMap.get("UOC_ORD_SERVICE_TYPE");
            for (UocArchivistAfOrderBo uocArchivistAfOrderBo : rspBo.getUocArchivistAfOrderBoList()) {
                uocArchivistAfOrderBo.setServTypeDesc(stringStringMap.get(uocArchivistAfOrderBo.getServType().toString()));
            }
        }
    }
}

