/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.UocElasticsearchUtil;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocAuditOrder;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.service.domainservice.UocEsSyncNewService;
import com.tydic.dyc.oc.service.domainservice.bo.UocEsSyncReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocEsSyncRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocEsSyncNewService"})
public class UocEsSyncNewServiceImpl
implements UocEsSyncNewService {
    private static final Logger log = LoggerFactory.getLogger(UocEsSyncNewServiceImpl.class);
    @Autowired
    private UocEsSyncManager uocEsSyncManager;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    @Autowired
    private UocElasticsearchUtil uocElasticsearchUtil;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @PostMapping(value={"sync"})
    public UocEsSyncRspBo sync(@RequestBody UocEsSyncReqBo reqBo) {
        this.val(reqBo);
        if (null != reqBo.getOrgId()) {
            log.info("\u6839\u636e\u91c7\u8d2d\u5355\u4f4d\u540c\u6b65es");
            if (this.uocIndexConfig.getSaleOrderIndex().equals(reqBo.getIndexName())) {
                log.info("\u540c\u6b65es\u6570\u636e1");
                this.syncSale(reqBo.getOrgId());
                return UocRu.success(UocEsSyncRspBo.class);
            }
            if (this.uocIndexConfig.getShipOrderIndex().equals(reqBo.getIndexName())) {
                this.syncShip(reqBo.getOrgId());
                return UocRu.success(UocEsSyncRspBo.class);
            }
            if (this.uocIndexConfig.getInspOrderIndex().equals(reqBo.getIndexName())) {
                this.syncInsp(reqBo);
                return UocRu.success(UocEsSyncRspBo.class);
            }
            return UocRu.success(UocEsSyncRspBo.class);
        }
        if (!reqBo.getAll().booleanValue()) {
            UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = UocRu.js(reqBo, UocEsSyncManagerSaveDataReqBo.class);
            this.uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
            return UocRu.success(UocEsSyncRspBo.class);
        }
        if (this.uocIndexConfig.getOrderIndex().equals(reqBo.getIndexName())) {
            this.delIdx(this.uocIndexConfig.getOrderIndex());
            this.syncOrder();
        }
        if (this.uocIndexConfig.getChngOrderIndex().equals(reqBo.getIndexName())) {
            this.delIdx(this.uocIndexConfig.getChngOrderIndex());
            this.syncChng();
        }
        if (this.uocIndexConfig.getTodoIndex().equals(reqBo.getIndexName())) {
            this.delIdx(this.uocIndexConfig.getTodoIndex());
            this.syncTodo();
        }
        if (this.uocIndexConfig.getAfOrderIndex().equals(reqBo.getIndexName())) {
            this.delIdx(this.uocIndexConfig.getAfOrderIndex());
            this.syncAfOrder();
        }
        if (this.uocIndexConfig.getApprovalOrderIndex().equals(reqBo.getIndexName())) {
            this.delIdx(this.uocIndexConfig.getApprovalOrderIndex());
            this.syncApprovalOrder();
        }
        if (this.uocIndexConfig.getApprovalOrderPlusIndex().equals(reqBo.getIndexName())) {
            this.delIdx(this.uocIndexConfig.getApprovalOrderPlusIndex());
            this.syncApprovalPlusOrder();
        }
        return UocRu.success(UocEsSyncRspBo.class);
    }

    private void syncOrder() {
        List<UocOrderDo> listOrder = this.getListOrder();
        if (!CollectionUtils.isEmpty(listOrder)) {
            listOrder.forEach(uocOrderDo -> {
                UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = UocRu.js(uocOrderDo, UocEsSyncManagerSaveDataReqBo.class);
                uocEsSyncManagerSaveDataReqBo.setObjId(uocOrderDo.getOrderId());
                uocEsSyncManagerSaveDataReqBo.setIndexName(this.uocIndexConfig.getOrderIndex());
                try {
                    this.uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
                }
                catch (Exception e) {
                    log.error("syncOrder->fail->{}", (Object)JSON.toJSONString((Object)uocOrderDo));
                }
            });
        }
    }

    private List<UocOrderDo> getListOrder() {
        UocOrderDo uocOrderDo = new UocOrderDo();
        return this.iUocOrderModel.qryOrderList(uocOrderDo);
    }

    private void syncApprovalOrder() {
        List<UocAuditOrder> listOrder = this.getListAuditOrder();
        if (!CollectionUtils.isEmpty(listOrder)) {
            listOrder.forEach(uocAuditOrder -> {
                UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = UocRu.js(uocAuditOrder, UocEsSyncManagerSaveDataReqBo.class);
                uocEsSyncManagerSaveDataReqBo.setObjId(uocAuditOrder.getAuditOrderId());
                uocEsSyncManagerSaveDataReqBo.setIndexName(this.uocIndexConfig.getApprovalOrderIndex());
                this.uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
            });
        }
    }

    private void syncApprovalPlusOrder() {
        List<UocAuditOrder> listOrder = this.getListAuditOrder();
        if (!CollectionUtils.isEmpty(listOrder)) {
            listOrder.forEach(uocAuditOrder -> {
                UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = UocRu.js(uocAuditOrder, UocEsSyncManagerSaveDataReqBo.class);
                uocEsSyncManagerSaveDataReqBo.setObjId(uocAuditOrder.getAuditOrderId());
                uocEsSyncManagerSaveDataReqBo.setIndexName(this.uocIndexConfig.getApprovalOrderPlusIndex());
                this.uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
            });
        }
    }

    private List<UocAuditOrder> getListAuditOrder() {
        return this.iUocAuditOrderModel.qryAuditOrderList(new UocAuditOrderQryBo());
    }

    private void delIdx(String idx) {
        block2: {
            try {
                this.uocElasticsearchUtil.deleteIndex(idx);
            }
            catch (Exception e) {
                String eCause = JSON.toJSONString((Object)e.getCause());
                log.error(eCause);
                if (!eCause.contains("index_not_found_exception")) break block2;
                log.info("\u7d22\u5f15\u4e0d\u5b58\u5728");
            }
        }
    }

    private void val(UocEsSyncReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (!reqBo.getAll().booleanValue()) {
            if (null == reqBo.getObjId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61ID\u4e3a\u7a7a");
            }
            if (null == reqBo.getOrderId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBo.getIndexName())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u7d22\u5f15\u540d\u4e3a\u7a7a");
            }
        }
    }

    private void syncSale(Long orgId) {
        List<UocSaleOrderDo> listOrder = this.getListSaleOrder(orgId);
        log.info("\u540c\u6b65es\u6570\u636e2" + JSONObject.toJSONString(listOrder));
        if (!CollectionUtils.isEmpty(listOrder)) {
            listOrder.forEach(uocSaleOrderDo -> {
                UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = UocRu.js(uocSaleOrderDo, UocEsSyncManagerSaveDataReqBo.class);
                uocEsSyncManagerSaveDataReqBo.setObjId(uocSaleOrderDo.getSaleOrderId());
                uocEsSyncManagerSaveDataReqBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
                log.info("\u540c\u6b65es\u6570\u636e3");
                this.uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
            });
        }
    }

    private void syncShip(Long orgId) {
        List<UocSaleOrderDo> listSaleOrder = this.getListSaleOrder(orgId);
        for (UocSaleOrderDo saleOrderDo : listSaleOrder) {
            List<UocShipOrderDo> listOrder = this.getListShipOrder(saleOrderDo);
            if (CollectionUtils.isEmpty(listOrder)) continue;
            listOrder.forEach(uocShipOrderDo -> {
                UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = UocRu.js(uocShipOrderDo, UocEsSyncManagerSaveDataReqBo.class);
                uocEsSyncManagerSaveDataReqBo.setIndexName(this.uocIndexConfig.getShipOrderIndex());
                uocEsSyncManagerSaveDataReqBo.setObjId(uocShipOrderDo.getShipOrderId());
                this.uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
            });
        }
    }

    private void syncInsp(UocEsSyncReqBo reqBo) {
        log.info("\u90e8\u5206\u9a8c\u6536\u6570\u636e\u540c\u6b65\uff1a{}", (Object)reqBo.getNotAll());
        if (ObjectUtil.isNotEmpty((Object)reqBo.getNotAll()) && reqBo.getNotAll() == 8) {
            ExcelReader reader = ExcelUtil.getReader((File)new File("/home/admin/bootpro/dyc-uoc-pro-test/\u9a8c\u6536\u5355\u6570\u636e.xlsx"));
            List readAll = reader.readAll();
            for (Map item : readAll) {
                UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
                uocEsSyncManagerSaveDataReqBo.setIndexName(this.uocIndexConfig.getInspOrderIndex());
                uocEsSyncManagerSaveDataReqBo.setOrderId(Long.valueOf((String)item.get("\u8ba2\u5355id")));
                uocEsSyncManagerSaveDataReqBo.setObjId(Long.valueOf((String)item.get("\u9a8c\u6536\u5355id")));
                this.uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
            }
        } else {
            List<UocSaleOrderDo> listSaleOrder = this.getListSaleOrder(reqBo.getOrgId());
            for (UocSaleOrderDo saleOrderDo : listSaleOrder) {
                List<UocInspOrderDo> listOrder = this.getListInspOrder(saleOrderDo);
                if (CollectionUtils.isEmpty(listOrder)) continue;
                listOrder.forEach(uocInspOrderDo -> {
                    UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = UocRu.js(uocInspOrderDo, UocEsSyncManagerSaveDataReqBo.class);
                    uocEsSyncManagerSaveDataReqBo.setIndexName(this.uocIndexConfig.getInspOrderIndex());
                    uocEsSyncManagerSaveDataReqBo.setObjId(uocInspOrderDo.getInspOrderId());
                    this.uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
                });
            }
        }
    }

    private void syncChng() {
        List<UocChngOrderDo> listOrder = this.getListChngOrder();
        if (!CollectionUtils.isEmpty(listOrder)) {
            listOrder.forEach(uocChngOrderDo -> {
                UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = UocRu.js(uocChngOrderDo, UocEsSyncManagerSaveDataReqBo.class);
                uocEsSyncManagerSaveDataReqBo.setIndexName(this.uocIndexConfig.getChngOrderIndex());
                uocEsSyncManagerSaveDataReqBo.setObjId(uocChngOrderDo.getChngOrderId());
                this.uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
            });
        }
    }

    private void syncTodo() {
        List<UocOrderTaskInst> listOrder = this.getListTaskInst();
        if (!CollectionUtils.isEmpty(listOrder)) {
            listOrder.forEach(uocOrderTaskInst -> {
                UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
                uocEsSyncManagerSaveDataReqBo.setIndexName(this.uocIndexConfig.getTodoIndex());
                uocEsSyncManagerSaveDataReqBo.setObjId(uocOrderTaskInst.getId());
                uocEsSyncManagerSaveDataReqBo.setOrderId(uocOrderTaskInst.getOrderId());
                this.uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
            });
        }
    }

    private void syncAfOrder() {
        List<UocAfOrder> listAfOrder = this.getListAfOrder();
        if (ObjectUtil.isNotEmpty(listAfOrder)) {
            listAfOrder.forEach(each -> {
                UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
                uocEsSyncManagerSaveDataReqBo.setIndexName(this.uocIndexConfig.getAfOrderIndex());
                uocEsSyncManagerSaveDataReqBo.setObjId(each.getAfOrderId());
                uocEsSyncManagerSaveDataReqBo.setOrderId(each.getOrderId());
                this.uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
            });
        }
    }

    private List<UocSaleOrderDo> getListSaleOrder(Long orgId) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setCreateCompanyId(orgId.toString());
        return this.iUocSaleOrderModel.qrySaleOrderListByOrg(uocSaleOrderDo);
    }

    private List<UocAfOrder> getListAfOrder() {
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        return this.iUocAfOrderModel.getAfOrderList(uocAfOrderQryBo);
    }

    private List<UocShipOrderDo> getListShipOrder(UocSaleOrderDo saleOrderDo) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setSaleOrderId(saleOrderDo.getSaleOrderId());
        uocShipOrderQryBo.setOrderId(saleOrderDo.getOrderId());
        return this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
    }

    private List<UocInspOrderDo> getListInspOrder(UocSaleOrderDo saleOrderDo) {
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setSaleOrderId(saleOrderDo.getSaleOrderId());
        uocInspOrderQryBo.setOrderId(saleOrderDo.getOrderId());
        return this.iUocInspOrderModel.getListInspOrder(uocInspOrderQryBo);
    }

    private List<UocChngOrderDo> getListChngOrder() {
        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        return this.iUocChngOrderModel.getListChngOrder(uocChngOrderQryBo);
    }

    private List<UocOrderTaskInst> getListTaskInst() {
        UocOrderTaskInstQryBo uocOrderTaskInstQryBo = new UocOrderTaskInstQryBo();
        uocOrderTaskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        return this.iUocOrderModel.qryOrderTaskInstList(uocOrderTaskInstQryBo);
    }
}

