/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.transactionservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAuditOrderCancelServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAuditOrderCancelServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class UocAuditOrderCancelServiceTransaction {
    private static final Logger log = LoggerFactory.getLogger(UocAuditOrderCancelServiceTransaction.class);
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public UocAuditOrderCancelServiceRspBo cancelAuditOrder(UocAuditOrderCancelServiceReqBo reqBo) {
        UocAuditOrderCancelServiceRspBo rspBo = UocRu.success(UocAuditOrderCancelServiceRspBo.class);
        this.validateArg(reqBo);
        UocApprovalObjQryBo qryAuditObjcBo = new UocApprovalObjQryBo();
        qryAuditObjcBo.setOrderId(reqBo.getOrderId());
        qryAuditObjcBo.setObjId(reqBo.getSaleOrderId().toString());
        log.info("\u53d6\u6d88\u5ba1\u6279\u5355\uff0c\u67e5\u8be2\u5ba1\u6279\u5bf9\u8c61\u5217\u8868\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)qryAuditObjcBo)));
        List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(qryAuditObjcBo);
        log.info("\u53d6\u6d88\u5ba1\u6279\u5355\uff0c\u67e5\u8be2\u5ba1\u6279\u5bf9\u8c61\u5217\u8868\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString(uocApprovalObjs));
        if (ObjectUtil.isNotEmpty(uocApprovalObjs)) {
            Long auditOrderId = uocApprovalObjs.get(0).getAuditOrderId();
            UocAuditOrderQryBo qryAuditBo = new UocAuditOrderQryBo();
            qryAuditBo.setOrderId(reqBo.getOrderId());
            qryAuditBo.setAuditOrderId(auditOrderId);
            UocAuditOrderDo uocAuditOrderDo = this.iUocAuditOrderModel.qryAuditOrder(qryAuditBo);
            if ("3".equals(uocAuditOrderDo.getAuditOrderStatus())) {
                log.info("\u53d6\u6d88\u5ba1\u6279\u5355\uff0c\u5df2\u53d6\u6d88\uff0c\u8fd4\u56de\u53d6\u6d88\u6210\u529f");
                rspBo.setOrderId(reqBo.getOrderId());
                rspBo.setAuditOrderId(auditOrderId);
                rspBo.setAuditOrderNo(uocAuditOrderDo.getAuditOrderCode());
                rspBo.setCancelSuccess(Boolean.valueOf(true));
                return rspBo;
            }
            if ("1".equals(uocAuditOrderDo.getAuditOrderStatus())) {
                log.info("\u53d6\u6d88\u5ba1\u6279\u5355\uff0c\u5df2\u5ba1\u6279\uff0c\u8fd4\u56de\u53d6\u6d88\u5931\u8d25");
                rspBo.setOrderId(reqBo.getOrderId());
                rspBo.setAuditOrderId(auditOrderId);
                rspBo.setAuditOrderNo(uocAuditOrderDo.getAuditOrderCode());
                rspBo.setCancelSuccess(Boolean.valueOf(false));
                return rspBo;
            }
            List<Long> saleOrderIdList = uocApprovalObjs.stream().map(item -> Long.parseLong(item.getObjId())).distinct().collect(Collectors.toList());
            UocSaleOrderDo qrySaleOrderListBo = new UocSaleOrderDo();
            qrySaleOrderListBo.setOrderId(reqBo.getOrderId());
            qrySaleOrderListBo.setSaleOrderIdList(saleOrderIdList);
            log.info("\u53d6\u6d88\u5ba1\u6279\u5355\uff0c\u67e5\u8be2\u9500\u552e\u5355\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)qrySaleOrderListBo)));
            List<UocSaleOrderDo> uocSaleOrderDos = this.iUocSaleOrderModel.qrySaleOrderList(qrySaleOrderListBo);
            log.info("\u53d6\u6d88\u5ba1\u6279\u5355\uff0c\u67e5\u8be2\u9500\u552e\u5355\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString(uocSaleOrderDos));
            if (ObjectUtil.isNotEmpty(uocSaleOrderDos)) {
                boolean canCancel = true;
                for (UocSaleOrderDo uocSaleOrderDo : uocSaleOrderDos) {
                    if (!"XS_SP_SPZ".equals(uocSaleOrderDo.getSaleOrderState())) continue;
                    canCancel = false;
                    break;
                }
                if (canCancel) {
                    UocAuditOrderDo updateBo = new UocAuditOrderDo();
                    updateBo.setOrderId(reqBo.getOrderId());
                    updateBo.setAuditOrderId(auditOrderId);
                    updateBo.setAuditOrderStatus("3");
                    log.info("\u53d6\u6d88\u5ba1\u6279\u5355\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)updateBo));
                    this.iUocAuditOrderModel.updateApprove(updateBo);
                    rspBo.setOrderId(reqBo.getOrderId());
                    rspBo.setAuditOrderId(auditOrderId);
                    rspBo.setAuditOrderNo(uocAuditOrderDo.getAuditOrderCode());
                    rspBo.setCancelSuccess(Boolean.valueOf(true));
                } else {
                    log.info("\u53d6\u6d88\u5ba1\u6279\u5355\uff0c\u6709\u9500\u552e\u5355\u5904\u4e8e\u5ba1\u6279\u4e2d\uff0c\u4e0d\u80fd\u53d6\u6d88\u5ba1\u6279\u5355");
                    rspBo.setOrderId(reqBo.getOrderId());
                    rspBo.setAuditOrderId(auditOrderId);
                    rspBo.setAuditOrderNo(uocAuditOrderDo.getAuditOrderCode());
                    rspBo.setCancelSuccess(Boolean.valueOf(false));
                }
            }
        } else {
            throw new BaseBusinessException("100001", "\u5ba1\u6279\u5bf9\u8c61\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return rspBo;
    }

    private void validateArg(UocAuditOrderCancelServiceReqBo reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo)) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5c5e\u6027orderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027saleOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

