/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.transactionservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocAlertInfo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateInspOrderReqShipBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocEcArrvalAcceptanceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocEcArrvalAcceptanceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class UocEcArrvalAcceptanceTransaction {
    private static final Logger log = LoggerFactory.getLogger(UocEcArrvalAcceptanceTransaction.class);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;
    private static final String OP_FLAG_YES = "1";

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public UocEcArrvalAcceptanceRspBo dealEcArrvalAcceptance(UocEcArrvalAcceptanceReqBo reqBo) {
        log.info("\u6574\u5355\u9a8c\u6536\u5165\u53c2\uff1a{}", (Object)reqBo);
        this.validateArg(reqBo);
        List<UocAfOrder> uocAfOrders = this.validateAfOrderUnfinished(reqBo.getSaleOrderId());
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.getCollectCountImplOrderItem(uocSaleOrderItemQryBo);
        UocSaleOrderItem uocSaleOrderItem = uocSaleOrderDo.getSaleOrderItems().get(0);
        if (uocSaleOrderItem.getArriveCount().compareTo(new BigDecimal("0")) == 0) {
            throw new BaseBusinessException("101004", "\u5230\u8d27\u6570\u91cf\u4e3a0,\u4e0d\u80fd\u9a8c\u6536\u7684\u6570\u636e");
        }
        if (uocSaleOrderItem.getPurchaseCount().compareTo(uocSaleOrderItem.getArriveCount().add(uocSaleOrderItem.getRefuseCount()).add(uocSaleOrderItem.getReturnCount())) != 0) {
            throw new BaseBusinessException("101004", "\u5b58\u5728\u4e0d\u80fd\u9a8c\u6536\u7684\u6570\u636e");
        }
        Date nowDate = new Date();
        ArrayList<UocCreateInspOrderReqShipBo> shipOrderList = new ArrayList<UocCreateInspOrderReqShipBo>();
        UocInspOrderDo uocInspOrderDo = this.convertInspOrderDo(reqBo, nowDate, shipOrderList, uocAfOrders);
        this.iUocInspOrderModel.createInspOrder(uocInspOrderDo);
        log.info("\u9a8c\u6536\u5355\u521b\u5efa\u6210\u529f\uff1a{}", (Object)uocInspOrderDo);
        this.updateShipOrderInspInfo(reqBo, nowDate);
        this.updateShipOrderItemInspInfo(reqBo, nowDate);
        this.updateSaleOrderItemInspInfo(reqBo, nowDate);
        this.modifySaleOrderState(reqBo);
        this.createOrderSettleRelInfo(reqBo, uocInspOrderDo.getInspOrderId());
        UocEcArrvalAcceptanceRspBo uocEcArrvalAcceptanceRspBo = UocRu.success(UocEcArrvalAcceptanceRspBo.class);
        uocEcArrvalAcceptanceRspBo.setInspOrderId(uocInspOrderDo.getInspOrderId());
        uocEcArrvalAcceptanceRspBo.setShipOrderList(shipOrderList);
        UocCommonDo uocCommonDo = new UocCommonDo();
        ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        taskBo.setTaskId(reqBo.getTaskId());
        taskBos.add(taskBo);
        uocCommonDo.setCompleteTaskInfos(taskBos);
        uocCommonDo.setUserId(11111L);
        uocCommonDo.setOrderId(reqBo.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
        return uocEcArrvalAcceptanceRspBo;
    }

    private void modifySaleOrderState(UocEcArrvalAcceptanceReqBo reqBo) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocShipOrderDo> shipOrderDos = this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setUpdateOperId(reqBo.getUserId() + "");
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setSaleOrderState("XS_YS_YS");
        this.iUocSaleOrderModel.updateSaleStatusAndProCode(uocSaleOrderDo);
        Integer noYh = null;
        if (uocSaleOrderDo.getOrderSource().equals(UocDicConstant.ORDER_SOURCE.AGR_GENERATE)) {
            noYh = UocConstant.UocAlertType.NO_YS_A;
        } else if (uocSaleOrderDo.getOrderSource().equals(UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT)) {
            noYh = UocConstant.UocAlertType.NO_YS_E;
        }
        if (null != noYh) {
            UocAlertInfo updateUocAlertInfo = new UocAlertInfo();
            updateUocAlertInfo.setObjId(reqBo.getSaleOrderId().toString());
            updateUocAlertInfo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            updateUocAlertInfo.setAlertType(noYh);
            updateUocAlertInfo.setAlertState(UocConstant.UocAlertState.DEALED);
            this.iUocSaleOrderModel.updateUocAlertInfo(updateUocAlertInfo);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createOrderSettleRelInfo(UocEcArrvalAcceptanceReqBo reqBo, Long inspOrderId) {
        UocSaleOrderDo querySaleOrderDo = new UocSaleOrderDo();
        querySaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        querySaleOrderDo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.getSaleOrderMain(querySaleOrderDo);
        if (null == saleOrderMain) throw new BaseBusinessException("101004", "\u751f\u4ea7\u8ba2\u5355\u7ed3\u7b97\u5173\u8054\u6570\u636e\u5931\u8d25\uff1a\u67e5\u8be2\u9500\u552e\u5355\u5355\u4e3a\u7a7a");
        this.createRelInfo(reqBo, inspOrderId, UocDicConstant.REL_TYPE.SERVICE_CHARGE);
        if (UocConstant.ModelSettle.MY.equals(saleOrderMain.getModelSettle())) {
            this.createRelInfo(reqBo, inspOrderId, UocDicConstant.REL_TYPE.COMMON_INVOICE);
            this.createRelInfo(reqBo, inspOrderId, UocDicConstant.REL_TYPE.UP_INVOICE);
            return;
        } else {
            if (!UocConstant.ModelSettle.CH.equals(saleOrderMain.getModelSettle())) throw new BaseBusinessException("101004", "\u751f\u4ea7\u8ba2\u5355\u7ed3\u7b97\u5173\u8054\u6570\u636e\u5931\u8d25\uff1a\u9519\u8bef\u7684\u7ed3\u7b97\u6a21\u5f0f");
            this.createRelInfo(reqBo, inspOrderId, UocDicConstant.REL_TYPE.CH_INVOICE);
        }
    }

    private void createRelInfo(UocEcArrvalAcceptanceReqBo reqBo, Long inspOrderId, Integer relType) {
        UocOrderRel createOrderRel = new UocOrderRel();
        createOrderRel.setId(IdUtil.nextId());
        createOrderRel.setRelStatus(UocDicConstant.REL_STATUS.UN_SUBMITTED);
        createOrderRel.setRelType(relType);
        createOrderRel.setOrderId(reqBo.getOrderId());
        createOrderRel.setObjId(inspOrderId);
        createOrderRel.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
        this.iUocOrderModel.createRelInfo(createOrderRel);
    }

    private void updateSaleOrderItemInspInfo(UocEcArrvalAcceptanceReqBo reqBo, Date nowDate) {
        UocSaleOrderDo uocSaleOrderDo1 = new UocSaleOrderDo();
        uocSaleOrderDo1.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo1.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo1.setUpdateTime(nowDate);
        uocSaleOrderDo1.setUpdateOperId(reqBo.getUserId().toString());
        this.iUocSaleOrderModel.modifySaleOrderItemInspCountEqualArrivalCount(uocSaleOrderDo1);
    }

    private void updateShipOrderItemInspInfo(UocEcArrvalAcceptanceReqBo reqBo, Date nowDate) {
        UocShipOrderDo uocShipOrderDo1 = new UocShipOrderDo();
        uocShipOrderDo1.setOrderId(reqBo.getOrderId());
        uocShipOrderDo1.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderDo1.setUpdateOperId(reqBo.getUserId().toString());
        uocShipOrderDo1.setUpdateTime(nowDate);
        this.iUocShipOrderModel.modifyShipOrderItemInspCountEqualArrivalCount(uocShipOrderDo1);
    }

    private void updateShipOrderInspInfo(UocEcArrvalAcceptanceReqBo reqBo, Date nowDate) {
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setOrderId(reqBo.getOrderId());
        uocShipOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        uocShipOrderDo.setUpdateTime(nowDate);
        uocShipOrderDo.setInspOperId(reqBo.getUserId().toString());
        uocShipOrderDo.setInspOperName(reqBo.getName());
        uocShipOrderDo.setInspTime(nowDate);
        uocShipOrderDo.setInspOperPhone(reqBo.getCellphone());
        this.iUocShipOrderModel.modifyShipOrderMain(uocShipOrderDo);
        UocShipOrderDo uocShipOrderDo1 = new UocShipOrderDo();
        uocShipOrderDo1.setOrderId(reqBo.getOrderId());
        uocShipOrderDo1.setSaleOrderId(reqBo.getSaleOrderId());
        this.iUocShipOrderModel.modifyShipOrderStatus(uocShipOrderDo1);
    }

    private UocInspOrderDo convertInspOrderDo(UocEcArrvalAcceptanceReqBo reqBo, Date nowDate, List<UocCreateInspOrderReqShipBo> shipOrderList, List<UocAfOrder> uocAfOrders) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("101002", "\u67e5\u8be2\u9a8c\u6536\u5355\u4e3a\u7a7a");
        }
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocShipOrderDo> uocShipOrderDoList = this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocShipOrderDo uocShipOrderDo = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setOrderId(reqBo.getOrderId());
        uocInspOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocInspOrderDo.setInspOrderId(IdUtil.nextId());
        uocInspOrderDo.setInspOrderNo(this.getInspOrderNo(uocSaleOrderDo));
        uocInspOrderDo.setInspOrderState("YS_YS_YS");
        uocInspOrderDo.setInspOper(reqBo.getName());
        uocInspOrderDo.setCreateOperId(reqBo.getUserId().toString());
        if (null != reqBo.getInspTime()) {
            uocInspOrderDo.setCreateTime(reqBo.getInspTime());
        } else {
            uocInspOrderDo.setCreateTime(nowDate);
        }
        uocInspOrderDo.setInvoiceTag(UocConstant.INVOICE_TAG.NO);
        uocInspOrderDo.setInspOperPhone(reqBo.getCellphone());
        uocInspOrderDo.setTenantId(reqBo.getTenantId());
        if (!CollectionUtils.isEmpty(uocAfOrders)) {
            BigDecimal afterPurTotalFee = uocAfOrders.stream().map(UocAfOrder::getRetTotalPurchaseFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal afterSaleTotalFee = uocAfOrders.stream().map(UocAfOrder::getRetTotalSaleFee).reduce(BigDecimal.ZERO, BigDecimal::add);
            uocInspOrderDo.setTotalPurchaseFee(uocSaleOrderDo.getTotalPurchaseFee().subtract(afterPurTotalFee));
            uocInspOrderDo.setTotalSaleFee(uocSaleOrderDo.getTotalSaleFee().subtract(afterSaleTotalFee));
        } else {
            uocInspOrderDo.setTotalPurchaseFee(uocSaleOrderDo.getTotalPurchaseFee());
            uocInspOrderDo.setTotalSaleFee(uocSaleOrderDo.getTotalSaleFee());
        }
        ArrayList<UocShipInspRel> uocShipInspRelList = new ArrayList<UocShipInspRel>();
        uocShipOrderDoList.forEach(uocShipOrderDo1 -> {
            UocCreateInspOrderReqShipBo bo = new UocCreateInspOrderReqShipBo();
            bo.setShipOrderId(uocShipOrderDo1.getShipOrderId());
            shipOrderList.add(bo);
            UocShipInspRel uocShipInspRel = UocRu.js(uocInspOrderDo, UocShipInspRel.class);
            uocShipInspRel.setId(IdUtil.nextId());
            uocShipInspRel.setShipOrderId(uocShipOrderDo1.getShipOrderId());
            uocShipInspRel.setRemark(null);
            uocShipInspRelList.add(uocShipInspRel);
        });
        ArrayList<UocInspOrderItem> uocInspOrderItemList = new ArrayList<UocInspOrderItem>();
        uocShipOrderDo.getShipOrderItemBoList().forEach(uocShipOrderItem -> {
            UocInspOrderItem uocInspOrderItem = UocRu.js(uocInspOrderDo, UocInspOrderItem.class);
            uocInspOrderItem.setInspOrderItemId(IdUtil.nextId());
            BigDecimal inspCount = uocShipOrderItem.getSendCount();
            if (null != uocShipOrderItem.getRefuseCount()) {
                inspCount = inspCount.subtract(uocShipOrderItem.getRefuseCount());
            }
            if (null != uocShipOrderItem.getReturnCount()) {
                inspCount = inspCount.subtract(uocShipOrderItem.getReturnCount());
            }
            log.info("\u9a8c\u6536\u6570\u91cf\uff1a{}", (Object)inspCount);
            uocInspOrderItem.setInspCount(inspCount);
            uocInspOrderItem.setRemainInspCount(inspCount);
            uocInspOrderItem.setInitInspCount(inspCount);
            uocInspOrderItem.setShipOrderItemId(uocShipOrderItem.getShipOrderItemId());
            uocInspOrderItem.setSaleOrderItemId(uocShipOrderItem.getSaleOrderItemId());
            uocInspOrderItem.setUnitName(uocShipOrderItem.getUnitName());
            uocInspOrderItem.setRemark(null);
            uocInspOrderItemList.add(uocInspOrderItem);
        });
        uocInspOrderDo.setUocShipInspRelList(uocShipInspRelList);
        uocInspOrderDo.setUocInspOrderItemList(uocInspOrderItemList);
        ArrayList<UocOrderAccessory> uocOrderAccessoryList = new ArrayList<UocOrderAccessory>();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrderAccessoryBoList())) {
            reqBo.getOrderAccessoryBoList().forEach(obj -> {
                UocOrderAccessory uocOrderAccessory = new UocOrderAccessory();
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setCreateTime(new Date());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
                uocOrderAccessory.setObjId(uocInspOrderDo.getInspOrderId());
                uocOrderAccessory.setAttachmentType(UocAttachementTypeConstants.ACCEPTANCE_PICTURE);
                uocOrderAccessory.setAccessoryUrl(obj.getAccessoryUrl());
                uocOrderAccessory.setAccessoryName(obj.getAccessoryName());
                uocOrderAccessoryList.add(uocOrderAccessory);
            });
        }
        uocInspOrderDo.setUocOrderAccessoryList(uocOrderAccessoryList);
        return uocInspOrderDo;
    }

    private String getInspOrderNo(UocSaleOrderDo uocSaleOrderDo) {
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setOrderSource(uocSaleOrderDo.getOrderSource());
        return this.iUocInspOrderModel.getInspOrderNo(uocInspOrderDo).getInspOrderNo();
    }

    private void validateArg(UocEcArrvalAcceptanceReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e3a\u7a7a");
        }
    }

    private List<UocAfOrder> validateAfOrderUnfinished(Long saleOrderId) {
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        uocAfOrderQryBo.setSaleOrderId(saleOrderId);
        List<UocAfOrder> afOrderList = this.iUocAfOrderModel.getAfOrderList(uocAfOrderQryBo);
        if (!CollectionUtils.isEmpty(afOrderList)) {
            afOrderList.forEach(afOrder -> {
                if (!(Objects.equals(afOrder.getServState(), UocDicConstant.SERVICE_STATE.COMPLATE) || Objects.equals(afOrder.getServState(), UocDicConstant.SERVICE_STATE.CANCEL) || Objects.equals(afOrder.getServState(), UocDicConstant.SERVICE_STATE.APPROVAL_NOT_PASS))) {
                    throw new BaseBusinessException("100001", "\u5b58\u5728\u672a\u5b8c\u7ed3\u7684\u552e\u540e\u5355\uff0c\u4e0d\u80fd\u8fdb\u884c\u9a8c\u6536");
                }
            });
        }
        List<UocAfOrder> completAfOrderList = afOrderList.stream().filter(bo -> UocDicConstant.SERVICE_STATE.COMPLATE.equals(bo.getServState()) && UocDicConstant.SERVICE_TYPE.RETURN_GOODS.equals(bo.getServType())).collect(Collectors.toList());
        return completAfOrderList;
    }
}

