package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocSnapSaleOrderItemSamePO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：快照销售订单明细同款表
 **/
@Mapper
@Repository
public interface UocSnapSaleOrderItemSameMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocSnapSaleOrderItemSamePo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocSnapSaleOrderItemSamePO uocSnapSaleOrderItemSamePo);

	/**
	 * 根据条件删除数据
	 *
	 * @param uocSnapSaleOrderItemSamePo 参数对象
	 * @return int 影响数量
	 */
	int deleteBy(UocSnapSaleOrderItemSamePO uocSnapSaleOrderItemSamePo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocSnapSaleOrderItemSamePo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用(如要使用请自行检查并修正sql语句)
	 */
	@Deprecated
	int updateById(UocSnapSaleOrderItemSamePO uocSnapSaleOrderItemSamePo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocSnapSaleOrderItemSamePO set, @Param("where") UocSnapSaleOrderItemSamePO where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocSnapSaleOrderItemSamePo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocSnapSaleOrderItemSamePO uocSnapSaleOrderItemSamePo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocSnapSaleOrderItemSamePo 参数对象
	 * @return UocSnapSaleOrderItemSamePO 结果对象
	 */
	UocSnapSaleOrderItemSamePO getModelBy(UocSnapSaleOrderItemSamePO uocSnapSaleOrderItemSamePo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocSnapSaleOrderItemSamePo 参数对象
	 * @return List<UocSnapSaleOrderItemSamePO> 结果对象
	 */
	List<UocSnapSaleOrderItemSamePO> getList(UocSnapSaleOrderItemSamePO uocSnapSaleOrderItemSamePo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocSnapSaleOrderItemSamePo 参数对象
	 * @param page 分页参数
	 * @return List<UocSnapSaleOrderItemSamePO> 结果对象
	 */
	List<UocSnapSaleOrderItemSamePO> getListPage(UocSnapSaleOrderItemSamePO uocSnapSaleOrderItemSamePo, Page<UocSnapSaleOrderItemSamePO> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocSnapSaleOrderItemSamePO> list);

}
