package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocSnapSaleOrderPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：快照销售订单表
 **/
@Mapper
@Repository
public interface UocSnapSaleOrderMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocSnapSaleOrderPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocSnapSaleOrderPO uocSnapSaleOrderPo);

	/**
	 * 根据条件删除数据
	 *
	 * @param uocSnapSaleOrderPo 参数对象
	 * @return int 影响数量
	 */
	int deleteBy(UocSnapSaleOrderPO uocSnapSaleOrderPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocSnapSaleOrderPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用(如要使用请自行检查并修正sql语句)
	 */
	@Deprecated
	int updateById(UocSnapSaleOrderPO uocSnapSaleOrderPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocSnapSaleOrderPO set, @Param("where") UocSnapSaleOrderPO where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocSnapSaleOrderPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocSnapSaleOrderPO uocSnapSaleOrderPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocSnapSaleOrderPo 参数对象
	 * @return UocSnapSaleOrderPO 结果对象
	 */
	UocSnapSaleOrderPO getModelBy(UocSnapSaleOrderPO uocSnapSaleOrderPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocSnapSaleOrderPo 参数对象
	 * @return List<UocSnapSaleOrderPO> 结果对象
	 */
	List<UocSnapSaleOrderPO> getList(UocSnapSaleOrderPO uocSnapSaleOrderPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocSnapSaleOrderPo 参数对象
	 * @param page 分页参数
	 * @return List<UocSnapSaleOrderPO> 结果对象
	 */
	List<UocSnapSaleOrderPO> getListPage(UocSnapSaleOrderPO uocSnapSaleOrderPo, Page<UocSnapSaleOrderPO> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocSnapSaleOrderPO> list);

}
