package com.tydic.dyc.oc.repository.po;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocChngOrderItemObjPo
 * 说明:变更单明细对
 * 时间:2022-04-12 19:42
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocChngOrderItemObjPo implements Serializable {
	private static final long serialVersionUID = -3532759234953626837L;

	//id")
	private Long id;

	//变更单id")
	private Long chngOrderId;

	//变更单对象id")
	private Long chngOrderObjId;

	//订单id")
	private Long orderId;

	//验收明细id")
	private Long inspOrderItemId;

	//发货明细id")
	private Long shipOrderItemId;

	//销售明细id")
	private Long saleOrderItemId;

	//订单明细id")
	private Long orderItemId;

	//变更类型1:数量变更 2订单调价3订单取消 4状态变更")
	private Integer chngType;

	//变更前数量")
	private BigDecimal chngNumPre;

	//变更数量")
	private BigDecimal chngNum;

	//变更金额")
	private BigDecimal chngFee;

	//采购变更金额")
	private BigDecimal chngPurchaseFee;

	//变更状态")
	private String chngState;

	//其他变更")
	private String otherChngValue;

	//创建时间")
	private Date createTime;

	//创建时间 开始")
	private Date createTimeStart;

	//创建时间 结束")
	private Date createTimeEnd;

	//创建工号")
	private String createOperId;

	//更新时间")
	private Date updateTime;

	//更新时间 开始")
	private Date updateTimeStart;

	//更新时间 结束")
	private Date updateTimeEnd;

	//更新工号")
	private String updateOperId;

	//备注")
	private String remark;

	//删除标志1已删除")
	private Integer delTag;

	//排序")
	private String orderBy;

	//变更单idList")
	private List<Long> chngOrderIdList;

	//订单idList")
	private List<Long> orderIdList;

	//增减类型，1：增加验收数量；2：减少验收数量")
	private Integer addOrSubtractType;
	//剩余验收数量")
	private BigDecimal remainInspCount;

	 //@DocField(value = "归档表后缀")
	private String dataAchiveTabSuffix;
    
    //销售订单明细idList")
    private List<Long> saleOrderItemIdList;
}
