/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.utils.DycEsbParamUtil;
import com.tydic.dyc.atom.base.utils.SSLClient;
import com.tydic.dyc.atom.common.api.DycGetActConfFunction;
import com.tydic.dyc.atom.common.bo.DycGetActConfFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGetActConfFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycOpenRpcActResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycGetActConfFunctionImpl
implements DycGetActConfFunction {
    private static final Logger log = LoggerFactory.getLogger(DycGetActConfFunctionImpl.class);
    @Value(value="${ESB_GET_ACT_CONF_URL}")
    private String ESB_GET_ACT_CONF_URL;
    public static final String BUSINESS_COMMODITY = "BUSINESS_COMMODITY";

    @Override
    public DycGetActConfFuncRspBO getActConf(DycGetActConfFuncReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u67e5\u8be2\u6d3b\u52a8\u914d\u7f6e\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getActivityCode())) {
            throw new ZTBusinessException("\u67e5\u8be2\u6d3b\u52a8\u914d\u7f6e\u5165\u53c2\u6d3b\u52a8\u7f16\u7801[activityCode]\u4e3a\u7a7a");
        }
        DycGetActConfFuncRspBO rspBO = new DycGetActConfFuncRspBO();
        String reqStr = this.initReqStr(reqBO);
        String reqEsbStr = DycEsbParamUtil.getEsbReqStr((String)reqStr, (String)reqBO.getSupplierCode(), (String)BUSINESS_COMMODITY);
        log.info("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u83b7\u53d6\u6d3b\u52a8\u5bf9\u63a5\u914d\u7f6e\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)reqEsbStr);
        String rspStr = SSLClient.doPost((String)this.ESB_GET_ACT_CONF_URL, (String)reqEsbStr);
        log.info("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u83b7\u53d6\u6d3b\u52a8\u5bf9\u63a5\u914d\u7f6e\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)rspStr);
        DycOpenRpcActResult abilityRspBO = this.setRsp(rspStr);
        if (!abilityRspBO.getSuccess().booleanValue()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(abilityRspBO.getResultMessage());
            return rspBO;
        }
        JSONObject rspOBJ = JSON.parseObject((String)abilityRspBO.getResult());
        rspBO.setRsaSignPrivateKey(rspOBJ.getString("rsaSignPrivateKey"));
        rspBO.setRsaEncryptPublicKey(rspOBJ.getString("rsaEncryptPublicKey"));
        rspBO.setAccessKey(rspOBJ.getString("accessKey"));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String initReqStr(DycGetActConfFuncReqBO reqBO) {
        JSONObject reqDTO = new JSONObject();
        reqDTO.put("activityCode", (Object)reqBO.getActivityCode());
        JSONObject reqJSON = new JSONObject();
        reqJSON.put("reqDTO", (Object)reqDTO);
        return reqJSON.toString();
    }

    private DycOpenRpcActResult setRsp(String rspJson) {
        DycOpenRpcActResult rspBO = new DycOpenRpcActResult();
        try {
            rspBO = (DycOpenRpcActResult)JSON.parseObject((String)rspJson, DycOpenRpcActResult.class);
            if (!rspBO.getSuccess().booleanValue()) {
                rspBO.setResultMessage(rspJson);
            }
        }
        catch (Exception e) {
            rspBO.setSuccess(false);
            rspBO.setResultMessage(rspJson);
        }
        return rspBO;
    }
}

