/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.utils.RsaCoder;
import com.tydic.dyc.atom.base.utils.RsaUtil;
import com.tydic.dyc.atom.base.utils.SSLClient;
import com.tydic.dyc.atom.base.utils.ShaUtil;
import com.tydic.dyc.atom.base.utils.SortUtil;
import com.tydic.dyc.atom.common.api.DycGetActConfFunction;
import com.tydic.dyc.atom.common.api.DycGetOrderTrackFunction;
import com.tydic.dyc.atom.common.bo.DycGetActConfFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGetActConfFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycGetOrderTrackFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGetOrderTrackFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycOpenRpcActResult;
import com.tydic.dyc.atom.common.bo.DycOrderTrackFuncBO;
import com.tydic.dyc.base.utils.JUtil;
import java.util.List;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycGetOrderTrackFunctionImpl
implements DycGetOrderTrackFunction {
    private static final Logger log = LoggerFactory.getLogger(DycGetOrderTrackFunctionImpl.class);
    @Autowired
    private DycGetActConfFunction dycGetActConfFunction;
    @Value(value="${ESB_GET_ORDER_TRACK_URL}")
    private String ESB_GET_ORDER_TRACK_URL;

    @Override
    public DycGetOrderTrackFuncRspBO getOrderTrack(DycGetOrderTrackFuncReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u67e5\u8be2\u4eac\u4e1c\u8ba2\u5355\u7269\u6d41\u4fe1\u606f\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getJdOrderId())) {
            throw new ZTBusinessException("\u67e5\u8be2\u4eac\u4e1c\u8ba2\u5355\u7269\u6d41\u4fe1\u606f\u5165\u53c2\u4eac\u4e1c\u7684\u8ba2\u5355\u53f7[jdOrderId]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getActivityCode())) {
            throw new ZTBusinessException("\u67e5\u8be2\u4eac\u4e1c\u8ba2\u5355\u7269\u6d41\u4fe1\u606f\u5165\u53c2\u6d3b\u52a8\u7f16\u7801[activityCode]\u4e3a\u7a7a");
        }
        DycGetOrderTrackFuncRspBO rspBO = new DycGetOrderTrackFuncRspBO();
        DycGetActConfFuncReqBO getActConfFuncReqBO = new DycGetActConfFuncReqBO();
        getActConfFuncReqBO.setActivityCode(reqBO.getActivityCode());
        DycGetActConfFuncRspBO getActConfFuncRspBO = this.dycGetActConfFunction.getActConf(getActConfFuncReqBO);
        if (!"0000".equals(getActConfFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u67e5\u8be2\u6d3b\u52a8\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff1a" + getActConfFuncRspBO.getRespDesc());
        }
        try {
            TreeMap<String, String> params = new TreeMap<String, String>();
            params.put("jdOrderId", reqBO.getJdOrderId());
            params.put("accessKey", getActConfFuncRspBO.getAccessKey());
            params.put("timestamp", System.currentTimeMillis() + "");
            String s1 = SortUtil.sortParams(params);
            String s2 = ShaUtil.encrypt((String)s1, (String)"SHA-256");
            byte[] s2Rsa = RsaCoder.encryptByPrivateKey((byte[])s2.getBytes("UTF-8"), (String)getActConfFuncRspBO.getRsaSignPrivateKey());
            String sign = RsaUtil.encryptBASE64((byte[])s2Rsa);
            params.put("sign", sign);
            log.info("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u4eac\u4e1c\u8ba2\u5355\u7269\u6d41\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(params));
            String rspStr = SSLClient.doPost((String)this.ESB_GET_ORDER_TRACK_URL, (String)JSON.toJSONString(params));
            log.info("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u4eac\u4e1c\u8ba2\u5355\u7269\u6d41\u4fe1\u606f\u606f\u51fa\u53c2\uff1a{}", (Object)rspStr);
            DycOpenRpcActResult abilityRspBO = this.setRsp(rspStr);
            if (!abilityRspBO.getSuccess().booleanValue()) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(abilityRspBO.getResultMessage());
                return rspBO;
            }
            String result = abilityRspBO.getResult();
            JSONObject resultOBJ = JSON.parseObject((String)result);
            List orderTrack = JUtil.jsl((Object)resultOBJ.get((Object)"orderTrack"), DycOrderTrackFuncBO.class);
            rspBO.setOrderTrack(orderTrack);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private DycOpenRpcActResult setRsp(String rspJson) {
        DycOpenRpcActResult rspBO = new DycOpenRpcActResult();
        try {
            rspBO = (DycOpenRpcActResult)JSON.parseObject((String)rspJson, DycOpenRpcActResult.class);
            if (!rspBO.getSuccess().booleanValue()) {
                rspBO.setResultMessage(rspJson);
            }
        }
        catch (Exception e) {
            rspBO.setSuccess(false);
            rspBO.setResultMessage(rspJson);
        }
        return rspBO;
    }
}

