/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.bo.AutoLoginParam;
import com.tydic.dyc.atom.base.utils.AutologinParamUtil;
import com.tydic.dyc.atom.base.utils.SignatureUtil;
import com.tydic.dyc.atom.common.api.DycGetActConfFunction;
import com.tydic.dyc.atom.common.api.DycJdPasswordFreeLoginFunction;
import com.tydic.dyc.atom.common.bo.DycGetActConfFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGetActConfFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycJdPasswordFreeLoginFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycJdPasswordFreeLoginFuncRspBO;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycJdPasswordFreeLoginFunctionImpl
implements DycJdPasswordFreeLoginFunction {
    private static final Logger log = LoggerFactory.getLogger(DycJdPasswordFreeLoginFunctionImpl.class);
    @Value(value="${jdPasswordFreeLogin.rsaEncryptPublicKey}")
    private String rsaEncryptPublicKey1;
    @Value(value="${jdPasswordFreeLogin.rsaSignPrivateKey}")
    private String rsaSignPrivateKey1;
    @Value(value="${jdPasswordFreeLogin.accessKey}")
    private String accessKey1;
    @Value(value="${jdPasswordFreeLogin.version}")
    private String version;
    @Value(value="${jdPasswordFreeLogin.autoLoginUrl}")
    private String autoLoginUrl;
    @Value(value="${jdPasswordFreeWebLogin.autoLoginUrl}")
    private String autoWebLoginUrl;
    @Value(value="${jdPasswordFreeLogin.freeSwitch:false}")
    private boolean freeSwitch;
    @Autowired
    private DycGetActConfFunction dycGetActConfFunction;

    @Override
    public DycJdPasswordFreeLoginFuncRspBO jdPasswordFreeLogin(DycJdPasswordFreeLoginFuncReqBO reqBO) {
        DycJdPasswordFreeLoginFuncRspBO rspBO = new DycJdPasswordFreeLoginFuncRspBO();
        String rsaSignPrivateKey = this.rsaSignPrivateKey1;
        String rsaEncryptPublicKey = this.rsaEncryptPublicKey1;
        String accessKey = this.accessKey1;
        if (this.freeSwitch) {
            DycGetActConfFuncReqBO getActConfFuncReqBO = new DycGetActConfFuncReqBO();
            getActConfFuncReqBO.setActivityCode(reqBO.getActivityCode());
            DycGetActConfFuncRspBO getActConfFuncRspBO = this.dycGetActConfFunction.getActConf(getActConfFuncReqBO);
            if (!"0000".equals(getActConfFuncRspBO.getRespCode())) {
                throw new ZTBusinessException("\u67e5\u8be2\u6d3b\u52a8\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff1a" + getActConfFuncRspBO.getRespDesc());
            }
            rsaSignPrivateKey = getActConfFuncRspBO.getRsaSignPrivateKey().replaceAll("\\n", "");
            rsaEncryptPublicKey = getActConfFuncRspBO.getRsaEncryptPublicKey().replaceAll("\\n", "");
            accessKey = getActConfFuncRspBO.getAccessKey();
        }
        String autoLoginUrlAddKey = null;
        autoLoginUrlAddKey = reqBO.isWebLogin() ? this.autoWebLoginUrl + accessKey : this.autoLoginUrl + accessKey;
        try {
            System.out.println("start-------------------------------------------------");
            AutoLoginParam autoLoginParam = AutologinParamUtil.getAutoLoginParam((String)rsaSignPrivateKey, (String)rsaEncryptPublicKey, (String)accessKey, (String)reqBO.getReturnUrl(), (String)reqBO.getUid(), null, (String)this.version);
            String redirectUrl = DycJdPasswordFreeLoginFunctionImpl.print(autoLoginParam, autoLoginUrlAddKey);
            rspBO.setRedirectUrl(redirectUrl);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private static String print(Object o, String title) throws IllegalAccessException {
        if (o instanceof String) {
            return "";
        }
        TreeMap paramMap = SignatureUtil.objectToMap((Object)o);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry result1 : paramMap.entrySet()) {
            if (result1.getValue() == null || ((String)result1.getValue()).trim().length() <= 0) continue;
            sb.append(result1.getKey() + "=" + DycJdPasswordFreeLoginFunctionImpl.replaceBlank(((String)result1.getValue()).trim()) + "&");
        }
        String url = title + "&" + sb.toString();
        return url.replaceAll("\\+", "%2B");
    }

    public static String replaceBlank(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }
}

