/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.utils.DycEsbParamUtil;
import com.tydic.dyc.atom.base.utils.SSLClient;
import com.tydic.dyc.atom.common.api.DycQryEStoreSkuStockFunction;
import com.tydic.dyc.atom.common.bo.DycEStoreSkuBO;
import com.tydic.dyc.atom.common.bo.DycEStoreSkuStockBO;
import com.tydic.dyc.atom.common.bo.DycQryEStoreSkuStockFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycQryEStoreSkuStockFuncRspBO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DycQryEStoreSkuStockFunctionImpl
implements DycQryEStoreSkuStockFunction {
    private static final Logger log = LoggerFactory.getLogger(DycQryEStoreSkuStockFunctionImpl.class);
    public static final String BUSINESS_COMMODITY = "BUSINESS_COMMODITY";
    @Value(value="${ESB_QRY_SKU_STOCK_URL}")
    private String ESB_QRY_SKU_STOCK_URL;

    @Override
    public DycQryEStoreSkuStockFuncRspBO qryEStoreSkuStock(DycQryEStoreSkuStockFuncReqBO reqBO) {
        try {
            List<String> skus = reqBO.getSkuNum().stream().map(DycEStoreSkuBO::getSkuId).collect(Collectors.toList());
            String reqStr = this.initReqStr(reqBO);
            String hsn = reqBO.getSupplierCode();
            String reqEsbStr = DycEsbParamUtil.getEsbReqStr((String)reqStr, (String)hsn, (String)BUSINESS_COMMODITY);
            String rspStr = SSLClient.doPost((String)this.ESB_QRY_SKU_STOCK_URL, (String)reqEsbStr);
            if (StringUtils.isEmpty((Object)rspStr)) {
                log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                DycQryEStoreSkuStockFuncRspBO resolveRsp = new DycQryEStoreSkuStockFuncRspBO();
                resolveRsp.setResultCode("8888");
                resolveRsp.setResultMessage("\u67e5\u8be2\u7535\u5546\u5916\u90e8\u63a5\u53e3-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                return resolveRsp;
            }
            DycQryEStoreSkuStockFuncRspBO resolveRsp = this.resolveRsp(rspStr, skus);
            log.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u89e3\u6790\u54cd\u5e94\u6570\u636e\uff1a" + resolveRsp.toString());
            return resolveRsp;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ZTBusinessException("\u5931\u8d25");
        }
    }

    private String initReqStr(DycQryEStoreSkuStockFuncReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("skuNums", reqBO.getSkuNum());
        String area = "" + reqBO.getProvince() + "_" + reqBO.getCity() + "_" + reqBO.getCounty() + "";
        jsonObject.put("area", (Object)area);
        jsonObject.put("hsn", (Object)reqBO.getSupplierCode());
        return jsonObject.toString();
    }

    private DycQryEStoreSkuStockFuncRspBO resolveRsp(String returnString, List<String> skus) {
        DycQryEStoreSkuStockFuncRspBO rspBO = new DycQryEStoreSkuStockFuncRspBO();
        ArrayList<DycEStoreSkuStockBO> list = new ArrayList<DycEStoreSkuStockBO>();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            String success = rspJsonObject.getString("success");
            if ("true".equals(success)) {
                rspBO.setSuccess(true);
            } else {
                rspBO.setSuccess(false);
            }
            rspBO.setResultCode(rspJsonObject.get((Object)"resultCode").toString());
            rspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            String respCode = (String)rspJsonObject.get((Object)"resultCode");
            if (!"0000".equals(respCode)) {
                if ("2007".equals(respCode)) {
                    rspBO.setResultMessage("token\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u6216\u8005\u83b7\u53d6token");
                    rspBO.setResultCode("8888");
                    return rspBO;
                }
                return rspBO;
            }
            JSONArray object = rspJsonObject.getJSONArray("result");
            if (null != object) {
                for (int i = 0; i < object.size(); ++i) {
                    JSONObject obj = (JSONObject)object.get(i);
                    String jsonStr = JSONObject.toJSONString((Object)obj);
                    if (StringUtils.isEmpty((Object)jsonStr)) continue;
                    DycEStoreSkuStockBO jsonStringToJavaBean = (DycEStoreSkuStockBO)JSON.parseObject((String)jsonStr, DycEStoreSkuStockBO.class);
                    list.add(jsonStringToJavaBean);
                }
                rspBO.setCommdStockInfo(list);
            }
            List TrueRuslt = rspBO.getCommdStockInfo().stream().map(DycEStoreSkuStockBO::getSkuId).collect(Collectors.toList());
            skus.removeAll(TrueRuslt);
            if (!CollectionUtils.isEmpty(skus)) {
                DycQryEStoreSkuStockFuncRspBO bo = this.setDefualtMsg(skus);
                rspBO.getCommdStockInfo().addAll(bo.getCommdStockInfo());
            }
            return rspBO;
        }
        catch (Exception var10) {
            log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
            rspBO.setResultMessage("\u67e5\u8be2\u7535\u5546\u5916\u90e8\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519");
            rspBO.setResultCode("8888");
            return rspBO;
        }
    }

    public DycQryEStoreSkuStockFuncRspBO setDefualtMsg(List<String> skus) {
        DycQryEStoreSkuStockFuncRspBO rspBO = new DycQryEStoreSkuStockFuncRspBO();
        if (!CollectionUtils.isEmpty(skus)) {
            ArrayList<DycEStoreSkuStockBO> commdStockInfo = new ArrayList<DycEStoreSkuStockBO>();
            for (String each : skus) {
                DycEStoreSkuStockBO bo = new DycEStoreSkuStockBO();
                bo.setStockStateId(34);
                bo.setRemainNum(0);
                bo.setStockStateDesc("\u65e0\u8d27");
                bo.setSkuId(each);
                commdStockInfo.add(bo);
            }
            rspBO.setCommdStockInfo(commdStockInfo);
        }
        rspBO.setRespCode("0000");
        rspBO.setResultCode("0000");
        rspBO.setSuccess(true);
        rspBO.setRespDesc("\u5e93\u5b58\u9ed8\u8ba4\u503c");
        return rspBO;
    }
}

