/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.utils.DycEsbParamUtil;
import com.tydic.dyc.atom.base.utils.SSLClient;
import com.tydic.dyc.atom.common.api.DycQryJdAddressFunction;
import com.tydic.dyc.atom.common.bo.DycJdAddressBO;
import com.tydic.dyc.atom.common.bo.DycQryJdAddressFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycQryJdAddressFuncRspBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DycQryJdAddressFunctionImpl
implements DycQryJdAddressFunction {
    private static final Logger log = LoggerFactory.getLogger(DycQryJdAddressFunctionImpl.class);
    public static final String BUSINESS_COMMODITY = "BUSINESS_COMMODITY";
    @Value(value="${ESB_QRY_JD_ADDRESS_URL}")
    private String ESB_QRY_JD_ADDRESS_URL;

    @Override
    public DycQryJdAddressFuncRspBO qryJdAddress(DycQryJdAddressFuncReqBO reqBO) {
        try {
            String reqStr = this.initReqStr(reqBO);
            String hsn = reqBO.getSupplierCode();
            String reqEsbStr = DycEsbParamUtil.getEsbReqStr((String)reqStr, (String)hsn, (String)BUSINESS_COMMODITY);
            String rspStr = SSLClient.doPost((String)this.ESB_QRY_JD_ADDRESS_URL, (String)reqEsbStr);
            if (StringUtils.isEmpty((Object)rspStr)) {
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            DycQryJdAddressFuncRspBO resolveRsp = this.resolveRsp(rspStr);
            log.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u89e3\u6790\u54cd\u5e94\u6570\u636e\uff1a" + resolveRsp.toString());
            return resolveRsp;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ZTBusinessException("\u5931\u8d25");
        }
    }

    private String initReqStr(DycQryJdAddressFuncReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("address", (Object)(reqBO.getProvinceName() + reqBO.getCityName() + reqBO.getAreaName() + reqBO.getTownName()));
        jsonObject.put("hsn", (Object)reqBO.getSupplierCode());
        return jsonObject.toString();
    }

    private DycQryJdAddressFuncRspBO resolveRsp(String returnString) {
        DycQryJdAddressFuncRspBO rspBO = new DycQryJdAddressFuncRspBO();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            rspBO.setSuccess((Boolean)rspJsonObject.get((Object)"success"));
            rspBO.setResultCode((String)rspJsonObject.get((Object)"resultCode"));
            rspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            String respCode = (String)rspJsonObject.get((Object)"resultCode");
            if (!"0000".equals(respCode)) {
                if ("2007".equals(respCode)) {
                    rspBO.setResultMessage("token\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u6216\u8005\u83b7\u53d6token");
                } else {
                    rspBO.setResultMessage("\u8c03\u7528\u5916\u90e8\u5e73\u53f0 \u4eac\u4e1c\u5730\u5740\u7f16\u7801\u67e5\u8be2\u63a5\u53e3 \u9519\u8bef");
                }
                rspBO.setResultCode("8888");
                return rspBO;
            }
            JSONObject object = rspJsonObject.getJSONObject("result");
            log.info("\u5730\u533a\uff1a" + object);
            if (null != object) {
                DycJdAddressBO result = (DycJdAddressBO)JSON.parseObject((String)JSON.toJSONString((Object)object), DycJdAddressBO.class);
                rspBO.setResult(result);
            }
            return rspBO;
        }
        catch (Exception var10) {
            log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
            throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }
}

