/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.common.api.DycQryEStoreSkuStockFunction;
import com.tydic.dyc.atom.common.api.DycQryJdAddressFunction;
import com.tydic.dyc.atom.common.api.DycQrySkuStockFunction;
import com.tydic.dyc.atom.common.bo.DycEStoreSkuBO;
import com.tydic.dyc.atom.common.bo.DycEStoreSkuStockBO;
import com.tydic.dyc.atom.common.bo.DycQryEStoreSkuStockFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycQryEStoreSkuStockFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycQryJdAddressFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycQryJdAddressFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycQrySkuStockFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycQrySkuStockFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycSkuBO;
import com.tydic.dyc.atom.common.bo.DycSkuStockBO;
import com.tydic.dyc.umc.service.addrprovince.UmcQryAddressService;
import com.tydic.dyc.umc.service.addrprovince.bo.UmcQryAddressReqBo;
import com.tydic.dyc.umc.service.addrprovince.bo.UmcQryAddressRspBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycQrySkuStockFunctionImpl
implements DycQrySkuStockFunction {
    private static final Logger log = LoggerFactory.getLogger(DycQrySkuStockFunctionImpl.class);
    @Autowired
    private UmcQryAddressService umcQryAddressService;
    @Autowired
    private DycQryJdAddressFunction dycQryJdAddressFunction;
    @Autowired
    private DycQryEStoreSkuStockFunction dycQryEStoreSkuStockFunction;

    @Override
    public DycQrySkuStockFuncRspBO qryJdSkuStock(DycQrySkuStockFuncReqBO reqBO) {
        DycQrySkuStockFuncRspBO rspBO = new DycQrySkuStockFuncRspBO();
        try {
            if (CollectionUtils.isEmpty(reqBO.getSkuNum())) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u8bf7\u4f20\u5165\u5355\u54c1\u4fe1\u606f");
                return rspBO;
            }
            if ("jdvopjl".equals(reqBO.getSupplierCode()) || "jdvop".equals(reqBO.getSupplierCode())) {
                UmcQryAddressReqBo umcQryAddressReqBo = new UmcQryAddressReqBo();
                umcQryAddressReqBo.setProvinceCode(Convert.toStr((Object)reqBO.getProvince()));
                umcQryAddressReqBo.setCityCode(Convert.toStr((Object)reqBO.getCity()));
                umcQryAddressReqBo.setAreaCode(Convert.toStr((Object)reqBO.getCounty()));
                umcQryAddressReqBo.setTownsCode(Convert.toStr((Object)reqBO.getTown()));
                log.info("\u4f1a\u5458\u67e5\u8be2\u7701\u5e02\u53bf\u9547\u670d\u52a1\u5165\u53c2umcQryAddressReqBo\uff1a" + JSONObject.toJSONString((Object)umcQryAddressReqBo));
                UmcQryAddressRspBo umcQryAddressRspBo = this.umcQryAddressService.qryAddress(umcQryAddressReqBo);
                log.info("\u4f1a\u5458\u67e5\u8be2\u7701\u5e02\u53bf\u9547\u670d\u52a1\u51fa\u53c2umcQryAddressRspBo\uff1a" + JSONObject.toJSONString((Object)umcQryAddressRspBo));
                reqBO.setProvince(Convert.toLong((Object)umcQryAddressRspBo.getProvinceCode()));
                reqBO.setCity(Convert.toLong((Object)umcQryAddressRspBo.getCityCode()));
                reqBO.setCounty(Convert.toLong((Object)umcQryAddressRspBo.getAreaCode()));
                reqBO.setTown(Convert.toLong((Object)umcQryAddressRspBo.getTownsCode()));
                DycQryJdAddressFuncReqBO jdAddressFromAddressQryReqBO = new DycQryJdAddressFuncReqBO();
                jdAddressFromAddressQryReqBO.setProvinceName(umcQryAddressRspBo.getProvinceName());
                jdAddressFromAddressQryReqBO.setCityName(umcQryAddressRspBo.getCityName());
                jdAddressFromAddressQryReqBO.setAreaName(umcQryAddressRspBo.getAreaName());
                jdAddressFromAddressQryReqBO.setTownName(umcQryAddressRspBo.getTownName());
                jdAddressFromAddressQryReqBO.setSupplierCode(reqBO.getSupplierCode());
                DycQryJdAddressFuncRspBO jdAddressFromAddressQryRspBO = this.dycQryJdAddressFunction.qryJdAddress(jdAddressFromAddressQryReqBO);
                reqBO.setProvince(jdAddressFromAddressQryRspBO.getResult().getProvinceId() == null ? 0L : jdAddressFromAddressQryRspBO.getResult().getProvinceId().longValue());
                reqBO.setCity(jdAddressFromAddressQryRspBO.getResult().getCityId() == null ? 0L : jdAddressFromAddressQryRspBO.getResult().getCityId().longValue());
                reqBO.setCounty(jdAddressFromAddressQryRspBO.getResult().getCountyId() == null ? 0L : jdAddressFromAddressQryRspBO.getResult().getCountyId().longValue());
                reqBO.setTown(jdAddressFromAddressQryRspBO.getResult().getTownId() == null ? 0L : jdAddressFromAddressQryRspBO.getResult().getTownId().longValue());
            }
            DycQryEStoreSkuStockFuncReqBO uccCurrentStockQryReqBO = new DycQryEStoreSkuStockFuncReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)uccCurrentStockQryReqBO);
            ArrayList<DycEStoreSkuBO> skuNums = new ArrayList<DycEStoreSkuBO>();
            for (DycSkuBO each : reqBO.getSkuNum()) {
                DycEStoreSkuBO bo = new DycEStoreSkuBO();
                bo.setSkuId(each.getSkuId());
                bo.setNum(each.getNum());
                skuNums.add(bo);
            }
            uccCurrentStockQryReqBO.setSkuNum(skuNums);
            DycQryEStoreSkuStockFuncRspBO uccCurrentStockQryRspBO = null;
            uccCurrentStockQryRspBO = this.dycQryEStoreSkuStockFunction.qryEStoreSkuStock(uccCurrentStockQryReqBO);
            if (uccCurrentStockQryRspBO == null) {
                log.error("uccCurrentStockQryService ->{ 67 - null }");
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5e93\u5b58\u67e5\u8be2\u8fd4\u56de null");
                return rspBO;
            }
            if ("0000".equals(uccCurrentStockQryRspBO.getResultCode())) {
                if (uccCurrentStockQryRspBO.getCommdStockInfo() != null && uccCurrentStockQryRspBO.getCommdStockInfo().size() > 0) {
                    ArrayList<DycSkuStockBO> commdStockBOBusis = new ArrayList<DycSkuStockBO>();
                    for (DycEStoreSkuStockBO commdStockBO : uccCurrentStockQryRspBO.getCommdStockInfo()) {
                        String json = JSONObject.toJSONString((Object)commdStockBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue});
                        DycSkuStockBO commdStockBOBusi1 = (DycSkuStockBO)JSON.parseObject((String)json, DycSkuStockBO.class);
                        BeanUtils.copyProperties((Object)commdStockBO, (Object)commdStockBOBusi1);
                        if (commdStockBOBusi1.getRemainNum().compareTo(new BigDecimal("0")) > 0) {
                            for (DycSkuBO uccMallsSkuNumBO_atom : reqBO.getSkuNum()) {
                                if (!commdStockBOBusi1.getSkuId().equals(uccMallsSkuNumBO_atom.getSkuId()) || commdStockBOBusi1.getRemainNum().compareTo(uccMallsSkuNumBO_atom.getNum()) >= 0) continue;
                                commdStockBOBusi1.setStockStateId(0);
                            }
                        }
                        commdStockBOBusis.add(commdStockBOBusi1);
                    }
                    rspBO.setCommdStockInfo(commdStockBOBusis);
                }
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
            } else {
                rspBO.setRespCode(uccCurrentStockQryRspBO.getResultCode());
                rspBO.setRespDesc(uccCurrentStockQryRspBO.getResultMessage());
            }
            return rspBO;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ZTBusinessException("\u7535\u5546\u67e5\u8be2\u5e93\u5b58\u5931\u8d25");
        }
    }
}

