/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.base.utils.DycDocking4AUtil;
import com.tydic.dyc.atom.base.utils.SSLClient;
import com.tydic.dyc.atom.common.api.DycUmcAccountAuthorizationFunction;
import com.tydic.dyc.atom.common.bo.DycUmcAccountAuthorizationFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycUmcAccountAuthorizationFuncRspBO;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycUmcAccountAuthorizationFunctionImpl
implements DycUmcAccountAuthorizationFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUmcAccountAuthorizationFunctionImpl.class);
    @Value(value="${accountAuthorization.userName:JN_PO_JNEG}")
    private String poUserName;
    @Value(value="${accountAuthorization.passWord:Init1234}")
    private String poPassWord;
    @Value(value="${accountAuthorization.reqUrl:/OSN/api/accountAuthorization/v1}")
    private String reqUrl;
    @Value(value="${accountAuthorization.client_id:JNE}")
    private String clientId;
    @Value(value="${accountAuthorization.client_secret:d8cfc34821c7f21a9b4b0bd1b070f8cb}")
    private String clientSecret;
    @Value(value="${accountAuthorization.redirect_uri:http://39.107.112.253:403/staffWelfareHome}")
    private String redirectUri;
    @Value(value="${accountAuthorization.interface_id:JN_JNEG24A_1000242}")
    private String interfaceId;
    @Value(value="${publicKey:0487997a974768450f7e0d75db6a897b4460ecd1d3ca935dd9ce14465b55ed617218eb911beb86c8cb6a78e753b1168f4b4800803585a6f5924b7063ea8ba22c8f}")
    private String publicKey;
    private static final String ENCODING = "UTF-8";

    @Override
    public DycUmcAccountAuthorizationFuncRspBO accountAuthorization(DycUmcAccountAuthorizationFuncReqBO reqBO) {
        LocalDate currentDate = LocalDate.now();
        DateTimeFormatter YMD = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String YMDDate = currentDate.format(YMD);
        LocalTime YMDHMSDate = LocalTime.now();
        String passWord = DycDocking4AUtil.encrypt((String)this.publicKey, (String)reqBO.getPassWord());
        long time = System.currentTimeMillis();
        String charsetname = this.clientId + this.clientSecret + time;
        String jToken = DigestUtils.md5Hex((String)charsetname);
        JSONObject MessageHeader = new JSONObject();
        MessageHeader.put("Interface_ID", (Object)this.interfaceId);
        MessageHeader.put("UUID", (Object)DycDocking4AUtil.createRandomString());
        MessageHeader.put("Sender", (Object)"JNEG");
        MessageHeader.put("Receiver", (Object)"4A");
        MessageHeader.put("SendDate", (Object)YMDDate);
        MessageHeader.put("SendTime", (Object)YMDHMSDate);
        JSONObject Request = new JSONObject();
        Request.put("grant_type", (Object)"password");
        Request.put("client_id", (Object)this.clientId);
        Request.put("client_secret", (Object)this.clientSecret);
        Request.put("redirect_uri", (Object)this.redirectUri);
        Request.put("username", (Object)reqBO.getUserName());
        Request.put("credential", (Object)passWord);
        Request.put("logintype", (Object)"passaccount");
        Request.put("deviceip", (Object)reqBO.getIp());
        Request.put("jToken", (Object)jToken);
        Request.put("time", (Object)time);
        JSONObject reqJSON = new JSONObject();
        reqJSON.put("Request", (Object)Request);
        reqJSON.put("MessageHeader", (Object)MessageHeader);
        String auth = this.poUserName + ":" + this.poPassWord;
        String encodeAuth = Base64.getEncoder().encodeToString(auth.getBytes());
        String authHeader = "Basic " + encodeAuth;
        log.info("\u8d26\u53f7\u5bc6\u7801\u8ba4\u8bc1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqJSON));
        String rspStr = SSLClient.doPost((String)this.reqUrl, (String)JSON.toJSONString((Object)reqJSON), (String)"ESB-Authorization", (String)authHeader);
        log.info("\u8d26\u53f7\u5bc6\u7801\u8ba4\u8bc1\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)rspStr));
        JSONObject rspJSON = JSON.parseObject((String)rspStr);
        DycUmcAccountAuthorizationFuncRspBO rspBO = (DycUmcAccountAuthorizationFuncRspBO)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)rspJSON.get((Object)"Response")), DycUmcAccountAuthorizationFuncRspBO.class));
        rspBO.setRespCode("0000");
        rspBO.setRespCode("\u6210\u529f");
        return rspBO;
    }
}

