/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.base.utils.DycDocking4AUtil;
import com.tydic.dyc.atom.base.utils.SSLClient;
import com.tydic.dyc.atom.common.api.DycUmcPasswordChangeFunction;
import com.tydic.dyc.atom.common.bo.DycUmcPasswordChangeFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycUmcPasswordChangeFuncRspBO;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycUmcPasswordChangeFunctionImpl
implements DycUmcPasswordChangeFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUmcPasswordChangeFunctionImpl.class);
    @Value(value="${passwordChange.userName:JN_PO_JNEG}")
    private String poUserName;
    @Value(value="${passwordChange.passWord:Init1234}")
    private String poPassWord;
    @Value(value="${passwordChange.reqUrl:/OSN/api/passwordChange/v1}")
    private String reqUrl;
    @Value(value="${passwordChange.appid:JNE}")
    private String appid;
    @Value(value="${passwordChange.key:D73CABDB3B5F085523C46D3CFAC3EB3B8BB9}")
    private String key;
    @Value(value="${passwordChange.interface_id:JN_JNEG24A_1000243}")
    private String interfaceId;
    @Value(value="${publicKey:0487997a974768450f7e0d75db6a897b4460ecd1d3ca935dd9ce14465b55ed617218eb911beb86c8cb6a78e753b1168f4b4800803585a6f5924b7063ea8ba22c8f}")
    private String publicKey;
    private static final String ENCODING = "UTF-8";

    @Override
    public DycUmcPasswordChangeFuncRspBO passwordChange(DycUmcPasswordChangeFuncReqBO reqBO) {
        LocalDate currentDate = LocalDate.now();
        DateTimeFormatter YMD = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String YMDDate = currentDate.format(YMD);
        LocalTime YMDHMSDate = LocalTime.now();
        String passWord = DycDocking4AUtil.encrypt((String)this.publicKey, (String)reqBO.getNewPassWord());
        long time = System.currentTimeMillis();
        String charsetname = this.appid + this.key + time;
        String token = DigestUtils.md5Hex((String)charsetname);
        JSONObject MessageHeader = new JSONObject();
        MessageHeader.put("Interface_ID", (Object)this.interfaceId);
        MessageHeader.put("UUID", (Object)DycDocking4AUtil.createRandomString());
        MessageHeader.put("Sender", (Object)"JNEG");
        MessageHeader.put("Receiver", (Object)"4A");
        MessageHeader.put("SendDate", (Object)YMDDate);
        MessageHeader.put("SendTime", (Object)YMDHMSDate);
        JSONObject Request = new JSONObject();
        Request.put("loginname", (Object)reqBO.getUserName());
        Request.put("newpassword", (Object)passWord);
        Request.put("appid", (Object)this.appid);
        Request.put("deviceip", (Object)reqBO.getIp());
        Request.put("token", (Object)token);
        Request.put("time", (Object)time);
        JSONObject reqJSON = new JSONObject();
        reqJSON.put("Request", (Object)Request);
        reqJSON.put("MessageHeader", (Object)MessageHeader);
        String auth = this.poUserName + ":" + this.poPassWord;
        String encodeAuth = Base64.getEncoder().encodeToString(auth.getBytes());
        String authHeader = "Basic " + encodeAuth;
        log.info("\u4fee\u6539\u7528\u6237\u5bc6\u7801\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqJSON));
        String rspStr = SSLClient.doPost((String)this.reqUrl, (String)JSON.toJSONString((Object)reqJSON), (String)"ESB-Authorization", (String)authHeader);
        log.info("\u4fee\u6539\u7528\u6237\u5bc6\u7801\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)rspStr));
        JSONObject rspJSON = JSON.parseObject((String)rspStr);
        DycUmcPasswordChangeFuncRspBO rspBO = (DycUmcPasswordChangeFuncRspBO)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)rspJSON.get((Object)"Response")), DycUmcPasswordChangeFuncRspBO.class));
        rspBO.setRespCode("0000");
        rspBO.setRespCode("\u6210\u529f");
        return rspBO;
    }
}

