/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.base.utils.SSLClient;
import com.tydic.dyc.atom.common.api.DycUmcSyncUserResultBackFunction;
import com.tydic.dyc.atom.common.bo.DycUmcSyncUserResultBackFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycUmcSyncUserResultBackFuncRspBO;
import com.tydic.dyc.umc.constants.UmcStatusConstant;
import com.tydic.dyc.umc.service.user.UmcCustInfoSyncTempDeleteService;
import com.tydic.dyc.umc.service.user.UmcCustInfoSyncTempListQryService;
import com.tydic.dyc.umc.service.user.bo.UmcCustInfoSynBo;
import com.tydic.dyc.umc.service.user.bo.UmcCustInfoSyncTempDeleteServiceReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcCustInfoSyncTempListQryServiceReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcCustInfoSyncTempListQryServiceRspBo;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycUmcSyncUserResultBackFunctionImpl
implements DycUmcSyncUserResultBackFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUmcSyncUserResultBackFunctionImpl.class);
    @Autowired
    private UmcCustInfoSyncTempListQryService umcCustInfoSyncTempListQryService;
    @Autowired
    private UmcCustInfoSyncTempDeleteService umcCustInfoSyncTempDeleteService;
    @Value(value="${syncUserResultBack.userName:JN_PO_JNEG}")
    private String poUserName;
    @Value(value="${syncUserResultBack.passWord:Init1234}")
    private String poPassWord;
    @Value(value="${syncUserResultBack.backUrl:/OSN/api/syncExtUserResultBack/v1}")
    private String backUrl;

    @Override
    public DycUmcSyncUserResultBackFuncRspBO syncUserResultBack(DycUmcSyncUserResultBackFuncReqBO reqBO) {
        LocalDate currentDate = LocalDate.now();
        DateTimeFormatter YMD = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String YMDDate = currentDate.format(YMD);
        LocalTime YMDHMSDate = LocalTime.now();
        DycUmcSyncUserResultBackFuncRspBO rspBO = new DycUmcSyncUserResultBackFuncRspBO();
        UmcCustInfoSyncTempListQryServiceReqBo listServiceReqBo = new UmcCustInfoSyncTempListQryServiceReqBo();
        listServiceReqBo.setBatchId(reqBO.getBatchId());
        log.info("\u67e5\u8be2\u5df2\u5904\u7406\u5b8c\u7684\u6279\u6b21\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)listServiceReqBo));
        UmcCustInfoSyncTempListQryServiceRspBo listServiceRspBo = this.umcCustInfoSyncTempListQryService.qryCustInfoTempList(listServiceReqBo);
        log.info("\u67e5\u8be2\u5df2\u5904\u7406\u5b8c\u7684\u6279\u6b21\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)listServiceRspBo));
        if (CollectionUtils.isEmpty((Collection)listServiceRspBo.getRows())) {
            rspBO.setRespCode("0000");
            rspBO.setRespCode("\u672a\u67e5\u8be2\u5230\u56de\u4f20\u6570\u636e");
            return rspBO;
        }
        List collect = listServiceRspBo.getRows().stream().filter(i -> UmcStatusConstant.SyncDealResult.SUCCESS.equals(i.getDealResult())).collect(Collectors.toList());
        JSONObject messageHeader = JSON.parseObject((String)((UmcCustInfoSynBo)listServiceRspBo.getRows().get(0)).getMessageHeader());
        Object sender = messageHeader.get((Object)"Sender");
        Object receiver = messageHeader.get((Object)"Receiver");
        messageHeader.replace((Object)"Sender", receiver);
        messageHeader.replace((Object)"Receiver", sender);
        messageHeader.replace((Object)"SendDate", (Object)YMDDate);
        messageHeader.replace((Object)"SendTime", (Object)YMDHMSDate);
        JSONArray rows = new JSONArray();
        for (UmcCustInfoSynBo tempBO : listServiceRspBo.getRows()) {
            JSONObject row = new JSONObject();
            row.put("CODE", (Object)tempBO.getOrgCode());
            row.put("UUID", (Object)tempBO.getUuid());
            row.put("SYNSTATUS", (Object)(tempBO.getDealResult() == UmcStatusConstant.SyncDealResult.SUCCESS ? "0" : "1"));
            String SYNRESULT = "\u6210\u529f";
            if (UmcStatusConstant.SyncDealResult.ERROR_DATA.equals(tempBO.getDealResult())) {
                SYNRESULT = "\u5fc5\u8981\u6570\u636e\u672a\u4f20";
            } else if (UmcStatusConstant.SyncDealResult.FILER.equals(tempBO.getDealResult())) {
                SYNRESULT = "\u672a\u627e\u5230\u6240\u5c5e\u673a\u6784";
            }
            row.put("SYNRESULT", (Object)SYNRESULT);
            rows.add((Object)row);
        }
        JSONObject Header = new JSONObject();
        Header.put("PUUID", (Object)reqBO.getBatchId());
        Header.put("Rows", (Object)rows);
        JSONObject Tables = new JSONObject();
        Tables.put("Header", (Object)Header);
        JSONObject Returns = new JSONObject();
        Returns.put("RESULT", (Object)(collect.size() == listServiceRspBo.getRows().size() ? "S\u6210\u529f" : "E\u5931\u8d25"));
        Returns.put("Tables", (Object)Tables);
        JSONObject reqJSON = new JSONObject();
        reqJSON.put("Returns", (Object)Returns);
        reqJSON.put("MessageHeader", (Object)messageHeader);
        String auth = this.poUserName + ":" + this.poPassWord;
        String encodeAuth = Base64.getEncoder().encodeToString(auth.getBytes());
        String authHeader = "Basic " + encodeAuth;
        log.info("\u5ba2\u6237\u5904\u7406\u7ed3\u679c\u56de\u4f20\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqJSON));
        String rspStr = SSLClient.doPost((String)this.backUrl, (String)JSON.toJSONString((Object)reqJSON), (String)"ESB-Authorization", (String)authHeader);
        log.info("\u5ba2\u6237\u5904\u7406\u7ed3\u679c\u56de\u4f20\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)rspStr));
        UmcCustInfoSyncTempDeleteServiceReqBo deleteServiceReqBo = new UmcCustInfoSyncTempDeleteServiceReqBo();
        deleteServiceReqBo.setBatchId(reqBO.getBatchId());
        this.umcCustInfoSyncTempDeleteService.deleteCustInfoTemp(deleteServiceReqBo);
        rspBO.setRespCode("0000");
        rspBO.setRespCode("\u6210\u529f");
        return rspBO;
    }
}

