/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.umc.model.authapplication.bo.AuthApplicationDO;
import com.tydic.dyc.umc.model.authapplication.bo.AuthApplicationInfo;
import com.tydic.dyc.umc.model.authapplication.constants.Constants;
import com.tydic.dyc.umc.repository.AuthApplicationRepository;
import com.tydic.dyc.umc.repository.dao.AuthApplicationMapper;
import com.tydic.dyc.umc.repository.po.AuthApplicationPO;
import com.tydic.dyc.umc.utils.IdUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AuthApplicationRepositoryImpl
implements AuthApplicationRepository {
    @Autowired
    private AuthApplicationMapper authApplicationMapper;

    public AuthApplicationInfo queryAuthApplicationSingle(AuthApplicationDO reqBO) {
        AuthApplicationInfo rspBO = new AuthApplicationInfo();
        AuthApplicationPO applicationPO = (AuthApplicationPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), AuthApplicationPO.class);
        List<AuthApplicationPO> authApplicationPOS = this.authApplicationMapper.selectByCondition(applicationPO);
        if (CollectionUtils.isEmpty(authApplicationPOS)) {
            return rspBO;
        }
        rspBO = (AuthApplicationInfo)JSON.parseObject((String)JSON.toJSONString((Object)authApplicationPOS.get(0)), AuthApplicationInfo.class);
        rspBO.setStatusStr(Constants.StatusStr((int)rspBO.getStatus()));
        return rspBO;
    }

    public BasePageRspBo<AuthApplicationInfo> queryAuthApplicationListPage(AuthApplicationDO reqBO) {
        BasePageRspBo rspBO = new BasePageRspBo();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        AuthApplicationPO applicationPO = (AuthApplicationPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), AuthApplicationPO.class);
        List<AuthApplicationPO> applicationPOS = this.authApplicationMapper.selectByUserCondition(applicationPO, (Page<AuthApplicationPO>)page);
        List infos = JSON.parseArray((String)JSON.toJSONString(applicationPOS), AuthApplicationInfo.class);
        infos.forEach(item -> item.setStatusStr(Constants.StatusStr((int)item.getStatus())));
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(infos);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public AuthApplicationInfo addAuthApplication(AuthApplicationDO reqBO) {
        AuthApplicationPO applicationPO = (AuthApplicationPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), AuthApplicationPO.class);
        long id = IdUtil.nextId();
        applicationPO.setId(id);
        applicationPO.setAuthId(id);
        applicationPO.setStatus(0);
        this.authApplicationMapper.insert(applicationPO);
        AuthApplicationInfo rspBO = new AuthApplicationInfo();
        rspBO.setAuthId(Long.valueOf(id));
        return rspBO;
    }

    public int updateAuthApplication(AuthApplicationDO reqBO) {
        AuthApplicationPO applicationPO = (AuthApplicationPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), AuthApplicationPO.class);
        if (1 == reqBO.getType()) {
            applicationPO.setCreateTime(new Date());
            applicationPO.setStatus(1);
        } else {
            applicationPO.setHandleTime(new Date());
            applicationPO.setStatus(2);
        }
        return this.authApplicationMapper.update(applicationPO);
    }
}

