/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.addrprovince.UmcAddrProvinceDo;
import com.tydic.dyc.umc.model.addrprovince.UmcAddrProvinceRspDo;
import com.tydic.dyc.umc.model.addrprovince.qrybo.UmcAddrBo;
import com.tydic.dyc.umc.model.addrprovince.qrybo.UmcAddrProvinceQryBo;
import com.tydic.dyc.umc.model.addrprovince.qrybo.UmcAddrQryBo;
import com.tydic.dyc.umc.repository.UmcAddrProvinceRepository;
import com.tydic.dyc.umc.repository.dao.AddrAreaMapper;
import com.tydic.dyc.umc.repository.dao.AddrCityMapper;
import com.tydic.dyc.umc.repository.dao.AddrProvinceMapper;
import com.tydic.dyc.umc.repository.dao.AddrTownsMapper;
import com.tydic.dyc.umc.repository.po.AddrAreaPo;
import com.tydic.dyc.umc.repository.po.AddrCityPo;
import com.tydic.dyc.umc.repository.po.AddrProvincePo;
import com.tydic.dyc.umc.repository.po.AddrTownsPo;
import com.tydic.dyc.umc.service.addrprovince.bo.UmcAddrSyncBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UmcAddrProvinceRepositoryImpl
implements UmcAddrProvinceRepository {
    @Autowired
    private AddrProvinceMapper addrProvinceMapper;
    @Autowired
    private AddrCityMapper addrCityMapper;
    @Autowired
    private AddrAreaMapper addrAreaMapper;
    @Autowired
    private AddrTownsMapper addrTownsMapper;

    public UmcAddrProvinceRspDo getList(UmcAddrProvinceQryBo qryBo) {
        AddrProvincePo po = (AddrProvincePo)UmcRu.js((Object)qryBo, AddrProvincePo.class);
        List<AddrProvincePo> list = this.addrProvinceMapper.getList(po);
        UmcAddrProvinceRspDo rspDo = new UmcAddrProvinceRspDo();
        List provinceDos = UmcRu.jsl(list, UmcAddrProvinceDo.class);
        rspDo.setRows(provinceDos);
        return rspDo;
    }

    public UmcAddrBo getAddr(UmcAddrQryBo umcAddrQryBo) {
        UmcAddrBo umcAddrBo = new UmcAddrBo();
        if (null != umcAddrQryBo) {
            if ("1".equals(umcAddrQryBo.getQueryType())) {
                this.queryAddrByName(umcAddrQryBo, umcAddrBo);
            } else {
                this.queryAddrByCode(umcAddrQryBo, umcAddrBo);
            }
        }
        return umcAddrBo;
    }

    private void queryAddrByCode(UmcAddrQryBo umcAddrQryBo, UmcAddrBo umcAddrBo) {
        if (!StringUtils.isBlank((CharSequence)umcAddrQryBo.getProvinceCode())) {
            AddrProvincePo addrProvincePo = new AddrProvincePo();
            addrProvincePo.setCode(umcAddrQryBo.getProvinceCode());
            addrProvincePo = this.addrProvinceMapper.getModelBy(addrProvincePo);
            if (null != addrProvincePo) {
                umcAddrBo.setProvinceCode(addrProvincePo.getCode());
                umcAddrBo.setProvinceName(addrProvincePo.getName());
            }
        }
        if (!StringUtils.isBlank((CharSequence)umcAddrQryBo.getCityCode())) {
            AddrCityPo addrCityPo = new AddrCityPo();
            addrCityPo.setCode(umcAddrQryBo.getCityCode());
            addrCityPo = this.addrCityMapper.getModelBy(addrCityPo);
            if (null != addrCityPo) {
                umcAddrBo.setCityCode(addrCityPo.getCode());
                umcAddrBo.setCityName(addrCityPo.getName());
            }
        }
        if (!StringUtils.isBlank((CharSequence)umcAddrQryBo.getAreaCode())) {
            AddrAreaPo addrAreaPo = new AddrAreaPo();
            addrAreaPo.setCode(umcAddrQryBo.getAreaCode());
            addrAreaPo = this.addrAreaMapper.getModelBy(addrAreaPo);
            if (null != addrAreaPo) {
                umcAddrBo.setAreaCode(addrAreaPo.getCode());
                umcAddrBo.setAreaName(addrAreaPo.getName());
            }
        }
        if (!StringUtils.isBlank((CharSequence)umcAddrQryBo.getTownsCode())) {
            AddrTownsPo addrTownsPo = new AddrTownsPo();
            addrTownsPo.setCode(umcAddrQryBo.getTownsCode());
            addrTownsPo = this.addrTownsMapper.getModelBy(addrTownsPo);
            if (null != addrTownsPo) {
                umcAddrBo.setTownsCode(addrTownsPo.getCode());
                umcAddrBo.setTownName(addrTownsPo.getName());
            }
        }
    }

    private void queryAddrByName(UmcAddrQryBo umcAddrQryBo, UmcAddrBo umcAddrBo) {
        if (!StringUtils.isBlank((CharSequence)umcAddrQryBo.getProvinceName())) {
            AddrProvincePo addrProvincePo = new AddrProvincePo();
            addrProvincePo.setName(umcAddrQryBo.getProvinceName());
            addrProvincePo = this.addrProvinceMapper.getModelBy(addrProvincePo);
            if (null != addrProvincePo) {
                umcAddrBo.setProvinceCode(addrProvincePo.getCode());
                umcAddrBo.setProvinceName(addrProvincePo.getName());
            }
        }
        if (!StringUtils.isBlank((CharSequence)umcAddrQryBo.getCityName())) {
            AddrCityPo addrCityPo = new AddrCityPo();
            addrCityPo.setName(umcAddrQryBo.getCityName());
            addrCityPo.setProvinceCode(umcAddrBo.getProvinceCode());
            addrCityPo = this.addrCityMapper.getModelBy(addrCityPo);
            if (null != addrCityPo) {
                umcAddrBo.setCityCode(addrCityPo.getCode());
                umcAddrBo.setCityName(addrCityPo.getName());
            }
        }
        if (!StringUtils.isBlank((CharSequence)umcAddrQryBo.getAreaName())) {
            AddrAreaPo addrAreaPo = new AddrAreaPo();
            addrAreaPo.setName(umcAddrQryBo.getAreaName());
            addrAreaPo.setCityCode(umcAddrBo.getCityCode());
            addrAreaPo = this.addrAreaMapper.getModelBy(addrAreaPo);
            if (null != addrAreaPo) {
                umcAddrBo.setAreaCode(addrAreaPo.getCode());
                umcAddrBo.setAreaName(addrAreaPo.getName());
            }
        }
        if (!StringUtils.isBlank((CharSequence)umcAddrQryBo.getTownName())) {
            AddrTownsPo addrTownsPo = new AddrTownsPo();
            addrTownsPo.setName(umcAddrQryBo.getTownName());
            addrTownsPo.setAreaCode(umcAddrBo.getAreaCode());
            addrTownsPo = this.addrTownsMapper.getModelBy(addrTownsPo);
            if (null != addrTownsPo) {
                umcAddrBo.setTownsCode(addrTownsPo.getCode());
                umcAddrBo.setTownName(addrTownsPo.getName());
            }
        }
    }

    public boolean qryIsExistsAddrByType(UmcAddrSyncBo umcAddrSyncBo, String addrType) {
        if (!ObjectUtil.isEmpty((Object)umcAddrSyncBo.getAddrCode())) {
            if ("1".equals(addrType)) {
                AddrProvincePo addrProvincePo = new AddrProvincePo();
                addrProvincePo.setCode(umcAddrSyncBo.getAddrCode());
                return !ObjectUtil.isEmpty((Object)this.addrProvinceMapper.getModelBy(addrProvincePo));
            }
            if ("2".equals(addrType)) {
                AddrCityPo addrCityPo = new AddrCityPo();
                addrCityPo.setCode(umcAddrSyncBo.getAddrCode());
                return !ObjectUtil.isEmpty((Object)this.addrCityMapper.getModelBy(addrCityPo));
            }
            if ("3".equals(addrType)) {
                AddrAreaPo addrAreaPo = new AddrAreaPo();
                addrAreaPo.setCode(umcAddrSyncBo.getAddrCode());
                return !ObjectUtil.isEmpty((Object)this.addrAreaMapper.getModelBy(addrAreaPo));
            }
            if ("4".equals(addrType)) {
                AddrTownsPo addrTownsPo = new AddrTownsPo();
                addrTownsPo.setCode(umcAddrSyncBo.getAddrCode());
                return !ObjectUtil.isEmpty((Object)this.addrTownsMapper.getModelBy(addrTownsPo));
            }
        } else {
            throw new BaseBusinessException("200001", "\u5730\u5740\u7f16\u7801[addrCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return false;
    }

    public void insertAddr(List<UmcAddrSyncBo> insertList, String addrType) {
        if (ObjectUtil.isNotEmpty(insertList) && StringUtils.isNotEmpty((CharSequence)addrType)) {
            List<AddrProvincePo> collect;
            if (addrType.equals("1")) {
                collect = insertList.stream().map(e -> {
                    AddrProvincePo addrProvincePo = new AddrProvincePo();
                    addrProvincePo.setCode(e.getAddrCode());
                    addrProvincePo.setName(e.getAddrName());
                    return addrProvincePo;
                }).collect(Collectors.toList());
                this.addrProvinceMapper.insertBatch(collect);
            }
            if (addrType.equals("2")) {
                collect = insertList.stream().map(e -> {
                    AddrCityPo addrCityPo = new AddrCityPo();
                    addrCityPo.setCode(e.getAddrCode());
                    addrCityPo.setName(e.getAddrName());
                    addrCityPo.setProvinceCode(e.getParentAddrCode());
                    return addrCityPo;
                }).collect(Collectors.toList());
                this.addrCityMapper.insertBatch(collect);
            }
            if (addrType.equals("3")) {
                collect = insertList.stream().map(e -> {
                    AddrAreaPo addrAreaPo = new AddrAreaPo();
                    addrAreaPo.setCode(e.getAddrCode());
                    addrAreaPo.setName(e.getAddrName());
                    addrAreaPo.setCityCode(e.getParentAddrCode());
                    return addrAreaPo;
                }).collect(Collectors.toList());
                this.addrAreaMapper.insertBatch(collect);
            }
            if (addrType.equals("4")) {
                collect = insertList.stream().map(e -> {
                    AddrTownsPo addrTownsPo = new AddrTownsPo();
                    addrTownsPo.setCode(e.getAddrCode());
                    addrTownsPo.setName(e.getAddrName());
                    addrTownsPo.setAreaCode(e.getParentAddrCode());
                    return addrTownsPo;
                }).collect(Collectors.toList());
                this.addrTownsMapper.insertBatch(collect);
            }
        }
    }

    public void updateAddr(List<UmcAddrSyncBo> updateList, String addrType) {
        if (ObjectUtil.isNotEmpty(updateList) && StringUtils.isNotEmpty((CharSequence)addrType)) {
            List collect;
            if (addrType.equals("1")) {
                collect = updateList.stream().map(e -> {
                    AddrProvincePo addrProvincePo = new AddrProvincePo();
                    addrProvincePo.setCode(e.getAddrCode());
                    addrProvincePo.setName(e.getAddrName());
                    return addrProvincePo;
                }).collect(Collectors.toList());
                for (AddrProvincePo addrProvincePo : collect) {
                    this.addrProvinceMapper.updateByCode(addrProvincePo);
                }
            }
            if (addrType.equals("2")) {
                collect = updateList.stream().map(e -> {
                    AddrCityPo addrCityPo = new AddrCityPo();
                    addrCityPo.setCode(e.getAddrCode());
                    addrCityPo.setName(e.getAddrName());
                    addrCityPo.setProvinceCode(e.getParentAddrCode());
                    return addrCityPo;
                }).collect(Collectors.toList());
                for (AddrCityPo addrCityPo : collect) {
                    this.addrCityMapper.updateByCode(addrCityPo);
                }
            }
            if (addrType.equals("3")) {
                collect = updateList.stream().map(e -> {
                    AddrAreaPo addrAreaPo = new AddrAreaPo();
                    addrAreaPo.setCode(e.getAddrCode());
                    addrAreaPo.setName(e.getAddrName());
                    addrAreaPo.setCityCode(e.getParentAddrCode());
                    return addrAreaPo;
                }).collect(Collectors.toList());
                for (AddrAreaPo addrAreaPo : collect) {
                    this.addrAreaMapper.updateByCode(addrAreaPo);
                }
            }
            if (addrType.equals("4")) {
                collect = updateList.stream().map(e -> {
                    AddrTownsPo addrTownsPo = new AddrTownsPo();
                    addrTownsPo.setCode(e.getAddrCode());
                    addrTownsPo.setName(e.getAddrName());
                    addrTownsPo.setAreaCode(e.getParentAddrCode());
                    return addrTownsPo;
                }).collect(Collectors.toList());
                for (AddrTownsPo addrTownsPo : collect) {
                    this.addrTownsMapper.updateByCode(addrTownsPo);
                }
            }
        }
    }

    public void deleteAddr(List<UmcAddrSyncBo> deleteList) {
        for (UmcAddrSyncBo umcAddrSyncBo : deleteList) {
            if ("1".equals(umcAddrSyncBo.getAddrType())) {
                this.addrProvinceMapper.deleteByCode(umcAddrSyncBo.getAddrCode());
                continue;
            }
            if ("2".equals(umcAddrSyncBo.getAddrType())) {
                this.addrCityMapper.deleteByCode(umcAddrSyncBo.getAddrCode());
                continue;
            }
            if ("3".equals(umcAddrSyncBo.getAddrType())) {
                this.addrAreaMapper.deleteByCode(umcAddrSyncBo.getAddrCode());
                continue;
            }
            if (!"4".equals(umcAddrSyncBo.getAddrType())) continue;
            this.addrTownsMapper.deleteByCode(umcAddrSyncBo.getAddrCode());
        }
    }

    public List<UmcAddrSyncBo> queryExistsAddrByType(List<UmcAddrSyncBo> searchList, String addrType) {
        if (!ObjectUtil.isEmpty((Object)addrType)) {
            if ("1".equals(addrType)) {
                List<UmcAddrSyncBo> umcAddrSyncBos = this.addrProvinceMapper.queryExistsAddrByType(searchList);
                this.setAddrType(umcAddrSyncBos, addrType);
                return umcAddrSyncBos;
            }
            if ("2".equals(addrType)) {
                List<UmcAddrSyncBo> umcAddrSyncBos = this.addrCityMapper.queryExistsAddrByType(searchList);
                this.setAddrType(umcAddrSyncBos, addrType);
                return umcAddrSyncBos;
            }
            if ("3".equals(addrType)) {
                List<UmcAddrSyncBo> umcAddrSyncBos = this.addrAreaMapper.queryExistsAddrByType(searchList);
                this.setAddrType(umcAddrSyncBos, addrType);
                return umcAddrSyncBos;
            }
            if ("4".equals(addrType)) {
                List<UmcAddrSyncBo> umcAddrSyncBos = this.addrTownsMapper.queryExistsAddrByType(searchList);
                this.setAddrType(umcAddrSyncBos, addrType);
                return umcAddrSyncBos;
            }
            return null;
        }
        throw new BaseBusinessException("200001", "\u5730\u5740\u7f16\u7801[addrCode]\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void setAddrType(List<UmcAddrSyncBo> dealList, String addrType) {
        for (UmcAddrSyncBo umcAddrSyncBo : dealList) {
            umcAddrSyncBo.setAddrType(addrType);
        }
    }
}

