/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.logistics.impl.api;

import com.tydic.logistics.api.UlcOrderListQueryAbilityService;
import com.tydic.logistics.api.bo.UlcOrderListQueryAbilityReqBo;
import com.tydic.logistics.api.bo.UlcOrderListQueryAbilityRspDataBo;
import com.tydic.logistics.common.base.UlcPageRspBo;
import com.tydic.logistics.dao.UlcInfoBusiSysMapper;
import com.tydic.logistics.dao.UlcInfoOrgMapper;
import com.tydic.logistics.dao.po.UlcInfoBusiSysPo;
import com.tydic.logistics.dao.po.UlcInfoOrgPo;
import com.tydic.logistics.interfaces.comb.UlcOrderListQueryCombService;
import com.tydic.logistics.interfaces.comb.bo.UlcOrderListQueryCombReqBo;
import com.tydic.logistics.interfaces.comb.bo.UlcOrderListQueryCombRspDataBo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="ulcOrderListQueryAbilityService")
public class UlcOrderListQueryAbilityServiceImpl
implements UlcOrderListQueryAbilityService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UlcOrderListQueryCombService ulcOrderListQueryCombService;
    @Autowired
    private UlcInfoBusiSysMapper ulcInfoBusiSysMapper;
    @Autowired
    private UlcInfoOrgMapper ulcInfoOrgMapper;

    public UlcPageRspBo<UlcOrderListQueryAbilityRspDataBo> dealUlcOrderListQuery(UlcOrderListQueryAbilityReqBo reqBo) {
        this.LOGGER.info("\u8fdb\u5165\u7269\u6d41\u5355\u5217\u8868\u67e5\u8be2\u670d\u52a1\uff0c\u5165\u53c2\uff1a" + reqBo);
        UlcPageRspBo rspBo = new UlcPageRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            rspBo.setRespCode("4003");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBo;
        }
        UlcOrderListQueryCombReqBo qryCombBo = new UlcOrderListQueryCombReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryCombBo);
        String sortStr = this.sortPropertis(reqBo, qryCombBo);
        if (!StringUtils.isEmpty((Object)sortStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + sortStr);
            rspBo.setRespCode("4003");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + sortStr);
            return rspBo;
        }
        UlcPageRspBo qryCombRspBo = this.ulcOrderListQueryCombService.orderList(qryCombBo);
        this.afterCopy((UlcPageRspBo<UlcOrderListQueryCombRspDataBo>)qryCombRspBo, (UlcPageRspBo<UlcOrderListQueryAbilityRspDataBo>)rspBo);
        return rspBo;
    }

    private void afterCopy(UlcPageRspBo<UlcOrderListQueryCombRspDataBo> qryCombRspBo, UlcPageRspBo<UlcOrderListQueryAbilityRspDataBo> rspBo) {
        BeanUtils.copyProperties(qryCombRspBo, rspBo);
        List rows = qryCombRspBo.getRows();
        ArrayList<UlcOrderListQueryAbilityRspDataBo> rspRows = new ArrayList<UlcOrderListQueryAbilityRspDataBo>();
        rspBo.setRows(rspRows);
        for (UlcOrderListQueryCombRspDataBo dataBo : rows) {
            UlcOrderListQueryAbilityRspDataBo abilityBo = new UlcOrderListQueryAbilityRspDataBo();
            BeanUtils.copyProperties((Object)dataBo, (Object)abilityBo);
            rspRows.add(abilityBo);
        }
    }

    private String sortPropertis(UlcOrderListQueryAbilityReqBo reqBo, UlcOrderListQueryCombReqBo qryCombBo) {
        String orgCode;
        String busiCode = reqBo.getBusiCode();
        if (!StringUtils.isEmpty((Object)busiCode)) {
            UlcInfoBusiSysPo ulcInfoBusiSysPo = this.ulcInfoBusiSysMapper.selectByBusiCode(busiCode);
            if (ulcInfoBusiSysPo == null) {
                return "\u8be5\u7cfb\u7edf(" + busiCode + ")\u4e0d\u5b58\u5728";
            }
            qryCombBo.setBusiId(ulcInfoBusiSysPo.getBusiId());
        }
        if (!StringUtils.isEmpty((Object)(orgCode = reqBo.getOrgCode()))) {
            UlcInfoOrgPo qryOrgPo = new UlcInfoOrgPo();
            UlcInfoOrgPo ulcInfoOrgPo = this.ulcInfoOrgMapper.selectBySelective(qryOrgPo);
            if (ulcInfoOrgPo == null) {
                return "\u8be5\u673a\u6784(" + busiCode + ")\u4e0d\u5b58\u5728";
            }
            qryCombBo.setOrgId(ulcInfoOrgPo.getOrgId());
            qryCombBo.setMerchantId(ulcInfoOrgPo.getMerchantId());
        }
        return null;
    }

    private String validateArg(UlcOrderListQueryAbilityReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

