/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.logistics.impl.api;

import com.alibaba.fastjson.JSON;
import com.tydic.logistics.api.UlcOrderTrackQueryAbilityService;
import com.tydic.logistics.api.bo.UlcOrderTrackQueryAbilityReqBo;
import com.tydic.logistics.api.bo.UlcOrderTrackQueryAbilityRspBo;
import com.tydic.logistics.api.bo.UlcOrderTrackQueryAbilityTrackRspDataBo;
import com.tydic.logistics.interfaces.atom.UlcQueryLogisticsOrderIdAtomService;
import com.tydic.logistics.interfaces.atom.bo.UlcQueryLogisticsOrderIdAtomServiceReqBo;
import com.tydic.logistics.interfaces.atom.bo.UlcQueryLogisticsOrderIdAtomServiceRspBo;
import com.tydic.logistics.interfaces.comb.UlcQueryLogisticsTrackInfoCombService;
import com.tydic.logistics.interfaces.comb.bo.UlcQueryLogisticsStatusTrackCombServiceBo;
import com.tydic.logistics.interfaces.comb.bo.UlcQueryLogisticsTrackInfoCombServiceReqBo;
import com.tydic.logistics.interfaces.comb.bo.UlcQueryLogisticsTrackInfoCombServiceRspBo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="ulcOrderTrackQueryAbilityService")
public class UlcOrderTrackQueryAbilityServiceImpl
implements UlcOrderTrackQueryAbilityService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UlcQueryLogisticsTrackInfoCombService ulcQueryLogisticsTrackInfoCombService;
    @Autowired
    private UlcQueryLogisticsOrderIdAtomService ulcQueryLogisticsOrderIdAtomService;

    public UlcOrderTrackQueryAbilityRspBo dealUlcOrderTrackQuery(UlcOrderTrackQueryAbilityReqBo reqBo) {
        UlcOrderTrackQueryAbilityRspBo retBo = new UlcOrderTrackQueryAbilityRspBo();
        String validateDataStr = this.validateDataArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateDataStr)) {
            this.LOGGER.error("\u53c2\u6570\u6821\u9a8c\u9519\u8bef\uff1a" + validateDataStr);
            retBo.setRespCode("4002");
            retBo.setRespDesc("\u53c2\u6570\u6821\u9a8c\u9519\u8bef\uff1a" + validateDataStr);
            return retBo;
        }
        String busiCode = reqBo.getBusiCode();
        String outLogisticsOrderId = reqBo.getOutLogisticsOrderId();
        retBo.setBusiCode(busiCode);
        retBo.setOutLogisticsOrderId(outLogisticsOrderId);
        UlcQueryLogisticsOrderIdAtomServiceReqBo orderIdAtomServiceReqBo = new UlcQueryLogisticsOrderIdAtomServiceReqBo();
        orderIdAtomServiceReqBo.setBusiCode(busiCode);
        orderIdAtomServiceReqBo.setOutLogisticsOrderId(outLogisticsOrderId);
        UlcQueryLogisticsOrderIdAtomServiceRspBo orderIdAtomServiceRspBo = this.ulcQueryLogisticsOrderIdAtomService.dealQueryLogisticsOrder(orderIdAtomServiceReqBo);
        if (!"0000".equals(orderIdAtomServiceRspBo.getRespCode())) {
            BeanUtils.copyProperties((Object)orderIdAtomServiceRspBo, (Object)retBo);
            return retBo;
        }
        UlcQueryLogisticsTrackInfoCombServiceReqBo trackInfoCombServiceReqBo = new UlcQueryLogisticsTrackInfoCombServiceReqBo();
        trackInfoCombServiceReqBo.setLogisticsOrderId(orderIdAtomServiceRspBo.getLogisticsOrderId());
        UlcQueryLogisticsTrackInfoCombServiceRspBo trackInfoCombServiceRspBo = this.ulcQueryLogisticsTrackInfoCombService.dealUlcQueryLogisticsTraceInfo(trackInfoCombServiceReqBo);
        List tracks = trackInfoCombServiceRspBo.getCombListTracks();
        ArrayList<UlcOrderTrackQueryAbilityTrackRspDataBo> listTracks = new ArrayList<UlcOrderTrackQueryAbilityTrackRspDataBo>();
        if (tracks == null) {
            BeanUtils.copyProperties((Object)trackInfoCombServiceRspBo, (Object)retBo);
            retBo.setListTracks(listTracks);
            return retBo;
        }
        BeanUtils.copyProperties((Object)trackInfoCombServiceRspBo, (Object)retBo);
        for (UlcQueryLogisticsStatusTrackCombServiceBo source : tracks) {
            UlcOrderTrackQueryAbilityTrackRspDataBo target = new UlcOrderTrackQueryAbilityTrackRspDataBo();
            BeanUtils.copyProperties((Object)source, (Object)target);
            listTracks.add(target);
        }
        retBo.setListTracks(listTracks);
        this.LOGGER.debug("UlcOrderTrackQueryAbilityRspBo:" + JSON.toJSONString((Object)retBo));
        return retBo;
    }

    private String validateDataArgs(UlcOrderTrackQueryAbilityReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOutLogisticsOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027outLogisticsOrderId\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiCode())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027busiCode\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        return null;
    }
}

