/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.logistics.impl.web;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.logistics.common.base.UlcFrontBaseRspBo;
import com.tydic.logistics.common.utils.rsa.RsaEncodeUtil;
import com.tydic.logistics.config.UlcSequenceConfig;
import com.tydic.logistics.constants.UlcSequenceKeys;
import com.tydic.logistics.dao.UlcInfoBusiSysMapper;
import com.tydic.logistics.dao.UlcLogisticsOrderMapper;
import com.tydic.logistics.dao.po.UlcInfoBusiSysPo;
import com.tydic.logistics.web.UlcBusiSysCreateWebService;
import com.tydic.logistics.web.bo.UlcBusiSysCreateWebServiceReqBo;
import com.tydic.logistics.web.bo.UlcBusiSysCreateWebServiceRspBo;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="ulcBusiSystemCreateWebService")
@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="ULC_GROUP_LOCAL", serviceInterface=UlcBusiSysCreateWebService.class)
public class UlcBusiSysCreateWebServiceImpl
implements UlcBusiSysCreateWebService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UlcInfoBusiSysMapper ulcInfoBusiSysMapper;
    @Autowired
    private UlcSequenceConfig ulcSequenceConfig;
    @Autowired
    private UlcLogisticsOrderMapper ulcLogisticsOrderMapper;

    public UlcFrontBaseRspBo<UlcBusiSysCreateWebServiceRspBo> createBusiSystem(UlcBusiSysCreateWebServiceReqBo reqBo) {
        int result;
        this.LOGGER.info("\u7269\u6d41\u4e2d\u5fc3\u4e1a\u52a1\u7cfb\u7edf\u521b\u5efa\uff1a" + JSONObject.toJSONString((Object)reqBo));
        UlcFrontBaseRspBo retBo = new UlcFrontBaseRspBo();
        UlcBusiSysCreateWebServiceRspBo rspBo = new UlcBusiSysCreateWebServiceRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("5014");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        UlcInfoBusiSysPo qryPo = this.ulcInfoBusiSysMapper.selectByBusiCode(reqBo.getBusiCode());
        if (qryPo != null) {
            this.LOGGER.error("\u4e1a\u52a1\u7f16\u7801\uff08" + qryPo.getBusiCode() + ")\u5df2\u5b58\u5728");
            retBo.setRespCode("5014");
            retBo.setRespDesc("\u4e1a\u52a1\u7f16\u7801\uff08" + qryPo.getBusiCode() + ")\u5df2\u5b58\u5728");
            return retBo;
        }
        UlcInfoBusiSysPo reqPo = new UlcInfoBusiSysPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)reqPo);
        Long busiId = 0L;
        try {
            busiId = this.ulcSequenceConfig.nextId(UlcSequenceKeys.SEQUENCE_BUSI_SYSTEM.getSequenceName());
        }
        catch (Exception e) {
            this.LOGGER.error("\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf\uff0c\u83b7\u53d6\u4e1a\u52a1\u7cfb\u7edfid\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("7001", "\u83b7\u53d6\u4e1a\u52a1\u7cfb\u7edfid\u5f02\u5e38" + e);
        }
        reqPo.setBusiId(busiId);
        Date now = this.ulcLogisticsOrderMapper.getDbDate().getDate();
        reqPo.setCreateTime(now);
        if ("1".equals(reqBo.getIsAutoSecretKey())) {
            Map secretKeyMap = new HashMap(16);
            try {
                secretKeyMap = RsaEncodeUtil.generateRSAKeys();
                reqPo.setRsaPrivateKey((String)secretKeyMap.get("private"));
                reqPo.setRsaPublicKey((String)secretKeyMap.get("public"));
                reqPo.setSignKey(RsaEncodeUtil.getRandomStringByLength((int)32));
            }
            catch (Exception e) {
                this.LOGGER.error("\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf\uff0c\u751f\u6210\u5bc6\u94a5\u5f02\u5e38");
                throw new BusinessException("7001", "\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf\uff0c\u751f\u6210\u5bc6\u94a5\u5f02\u5e38" + e);
            }
        }
        if ((result = this.ulcInfoBusiSysMapper.insert(reqPo)) < 1) {
            this.LOGGER.error("\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf\uff0c\u5199\u8868\u5931\u8d25");
            throw new BusinessException("7001", "\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf\uff0c\u5199\u8868\u5931\u8d25");
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)rspBo);
        rspBo.setBusiId(busiId + "");
        retBo.setData((Object)rspBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArgs(UlcBusiSysCreateWebServiceReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiCode())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027busiCode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiName())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027busiName\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getIsAutoSecretKey())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027isAutoSecretKey\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

