/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.logistics.impl.web;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.logistics.common.base.UlcFrontBaseRspBo;
import com.tydic.logistics.common.base.UlcFrontPageRspBo;
import com.tydic.logistics.dao.UlcInfoBusiSysMapper;
import com.tydic.logistics.dao.po.UlcInfoBusiSysPo;
import com.tydic.logistics.interfaces.atom.UlcDicMapQueryAtomService;
import com.tydic.logistics.interfaces.atom.bo.UlcDicMapQueryAtomReqBo;
import com.tydic.logistics.interfaces.atom.bo.UlcDicMapQueryAtomRspBo;
import com.tydic.logistics.web.UlcBusiSysQueryPageWebService;
import com.tydic.logistics.web.bo.UlcBusiSysQueryPageWebServiceReqBo;
import com.tydic.logistics.web.bo.UlcBusiSysQueryWebServiceDataBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="ulcBusiSysQueryPageWebService")
@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="ULC_GROUP_LOCAL", serviceInterface=UlcBusiSysQueryPageWebService.class)
public class UlcBusiSysQueryPageWebServiceImpl
implements UlcBusiSysQueryPageWebService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UlcInfoBusiSysMapper ulcInfoBusiSysMapper;
    @Autowired
    private UlcDicMapQueryAtomService ulcDicMapQueryAtomService;

    public UlcFrontBaseRspBo<UlcFrontPageRspBo<UlcBusiSysQueryWebServiceDataBo>> queryBusiSys(UlcBusiSysQueryPageWebServiceReqBo reqBo) {
        Page page;
        this.LOGGER.info("\u7269\u6d41\u4e2d\u5fc3\u4e1a\u52a1\u7cfb\u7edf\u67e5\u8be2\uff1a" + JSONObject.toJSONString((Object)reqBo));
        UlcFrontBaseRspBo retBo = new UlcFrontBaseRspBo();
        UlcFrontPageRspBo rspBo = new UlcFrontPageRspBo();
        if (reqBo.getPageNo() != 1) {
            page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)page);
            if (page.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (page.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        UlcInfoBusiSysPo reqPo = new UlcInfoBusiSysPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)reqPo);
        List poList = this.ulcInfoBusiSysMapper.selectBySelectivePage(reqPo, page);
        if (CollectionUtils.isEmpty((Collection)poList)) {
            this.LOGGER.error("\u4e1a\u52a1\u7cfb\u7edf\u67e5\u8be2\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u6570\u636e");
            retBo.setRespCode("5015");
            retBo.setRespDesc("\u4e1a\u52a1\u7cfb\u7edf\u67e5\u8be2\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u6570\u636e");
            return retBo;
        }
        ArrayList<UlcBusiSysQueryWebServiceDataBo> busiSysBoList = new ArrayList<UlcBusiSysQueryWebServiceDataBo>();
        ArrayList<String> dicTypeList = new ArrayList<String>();
        dicTypeList.add("BUSINESS_SYS_CALL_BACK_TYPE");
        dicTypeList.add("BUSINESS_SYS_ATTR_STATUS");
        Map<String, Map<String, String>> dicValueMap = this.translate(dicTypeList);
        for (UlcInfoBusiSysPo po : poList) {
            UlcBusiSysQueryWebServiceDataBo busiSysBo = new UlcBusiSysQueryWebServiceDataBo();
            BeanUtils.copyProperties((Object)po, (Object)busiSysBo);
            busiSysBo.setCallType(dicValueMap.get("BUSINESS_SYS_CALL_BACK_TYPE").get(po.getCallType()));
            busiSysBo.setState(dicValueMap.get("BUSINESS_SYS_ATTR_STATUS").get(po.getState()));
            busiSysBoList.add(busiSysBo);
        }
        rspBo.setRows(busiSysBoList);
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        retBo.setData((Object)rspBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private Map<String, Map<String, String>> translate(List<String> dicTypeList) {
        HashMap<String, Map<String, String>> dicValueMap = new HashMap<String, Map<String, String>>(16);
        for (String dicType : dicTypeList) {
            UlcDicMapQueryAtomReqBo qryDicBo = new UlcDicMapQueryAtomReqBo();
            qryDicBo.setpType(dicType);
            UlcDicMapQueryAtomRspBo dicValue = this.ulcDicMapQueryAtomService.queryDic(qryDicBo);
            dicValueMap.put(dicType, dicValue.getDataMap());
        }
        return dicValueMap;
    }
}

