/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.logistics.impl.web;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.logistics.common.base.UlcFrontBaseRspBo;
import com.tydic.logistics.common.utils.rsa.RsaEncodeUtil;
import com.tydic.logistics.dao.UlcInfoBusiSysMapper;
import com.tydic.logistics.dao.UlcLogisticsOrderMapper;
import com.tydic.logistics.dao.po.UlcInfoBusiSysPo;
import com.tydic.logistics.web.UlcBusiSysUpdateWebService;
import com.tydic.logistics.web.bo.UlcBusiSysUpdateWebServiceReqBo;
import com.tydic.logistics.web.bo.UlcBusiSysUpdateWebServiceRspBo;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="ulcBusiSysUpdateWebService")
@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="ULC_GROUP_LOCAL", serviceInterface=UlcBusiSysUpdateWebService.class)
public class UlcBusiSysUpdateWebServiceImpl
implements UlcBusiSysUpdateWebService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String IS_UPDATE_SECRET_KEY = "1";
    @Autowired
    private UlcInfoBusiSysMapper ulcInfoBusiSysMapper;
    @Autowired
    private UlcLogisticsOrderMapper ulcLogisticsOrderMapper;

    public UlcFrontBaseRspBo<UlcBusiSysUpdateWebServiceRspBo> updateBusiSys(UlcBusiSysUpdateWebServiceReqBo reqBo) {
        this.LOGGER.info("\u4e1a\u52a1\u7cfb\u7edf\u66f4\u65b0\u670d\u52a1\uff1a" + JSONObject.toJSONString((Object)reqBo));
        UlcFrontBaseRspBo retBo = new UlcFrontBaseRspBo();
        UlcBusiSysUpdateWebServiceRspBo rspBo = new UlcBusiSysUpdateWebServiceRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("5016");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        UlcInfoBusiSysPo po = new UlcInfoBusiSysPo();
        po.setBusiCode(reqBo.getBusiCode());
        List poList = this.ulcInfoBusiSysMapper.selectBySelective(po);
        for (UlcInfoBusiSysPo tempPo : poList) {
            if (tempPo.getBusiId().equals(reqBo.getBusiId())) continue;
            this.LOGGER.error("\u4e1a\u52a1\u7f16\u7801\uff08" + tempPo.getBusiCode() + ")\u5df2\u5b58\u5728");
            retBo.setRespCode("5016");
            retBo.setRespDesc("\u4e1a\u52a1\u7f16\u7801\uff08" + tempPo.getBusiCode() + ")\u5df2\u5b58\u5728");
            return retBo;
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)po);
        if (IS_UPDATE_SECRET_KEY.equals(reqBo.getIsUpdateSecretKey())) {
            try {
                Map secretKeyMap = RsaEncodeUtil.generateRSAKeys();
                po.setRsaPrivateKey((String)secretKeyMap.get("private"));
                po.setRsaPublicKey((String)secretKeyMap.get("public"));
                po.setSignKey(RsaEncodeUtil.getRandomStringByLength((int)32));
            }
            catch (Exception e) {
                this.LOGGER.error("\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf\uff0c\u751f\u6210\u5bc6\u94a5\u5f02\u5e38");
                throw new BusinessException("7001", "\u65b0\u589e\u4e1a\u52a1\u7cfb\u7edf\uff0c\u751f\u6210\u5bc6\u94a5\u5f02\u5e38" + e);
            }
        }
        Date now = this.ulcLogisticsOrderMapper.getDbDate().getDate();
        po.setLastTime(now);
        int result = this.ulcInfoBusiSysMapper.updateByPrimaryKeySelective(po);
        if (result < 1) {
            this.LOGGER.error("\u4e1a\u52a1\u7cfb\u7edf\u66f4\u65b0\u6570\u636e\u4fe1\u606f\u5931\u8d25");
            retBo.setRespCode("5016");
            retBo.setRespDesc("\u4e1a\u52a1\u7cfb\u7edf\u66f4\u65b0\u6570\u636e\u4fe1\u606f\u5931\u8d25");
            return retBo;
        }
        rspBo.setBusiCode(reqBo.getBusiCode());
        rspBo.setBusiName(reqBo.getBusiName());
        retBo.setData((Object)rspBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArgs(UlcBusiSysUpdateWebServiceReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiCode())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027busiCode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027busiId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiName())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027busiName\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getCallType())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027callType\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getState())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027state\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getIsUpdateSecretKey())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027isUpdateSecretKey\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

