/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.logistics.impl.web;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.logistics.common.base.UlcFrontBaseRspBo;
import com.tydic.logistics.dao.UlcInfoCompanyMapper;
import com.tydic.logistics.dao.UlcInfoCompanyParaMapper;
import com.tydic.logistics.dao.po.UlcInfoCompanyParaPo;
import com.tydic.logistics.dao.po.UlcInfoCompanyPo;
import com.tydic.logistics.interfaces.busi.UlcCompanyParamCreateBusiService;
import com.tydic.logistics.interfaces.busi.bo.UlcCompanyParamCreateBusiServiceReqBo;
import com.tydic.logistics.interfaces.busi.bo.UlcCompanyParamCreateBusiServiceRspBo;
import com.tydic.logistics.web.UlcCompanyParamCreateWebService;
import com.tydic.logistics.web.bo.UlcCompanyParamCreateWebServiceReqBo;
import com.tydic.logistics.web.bo.UlcCompanyParamCreateWebServiceRspBo;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="ulcCompanyParamCreateWebService")
@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="ULC_GROUP_LOCAL", serviceInterface=UlcCompanyParamCreateWebService.class)
public class UlcCompanyParamCreateWebServiceImpl
implements UlcCompanyParamCreateWebService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UlcCompanyParamCreateBusiService ulcCompanyParamCreateBusiService;
    @Autowired
    private UlcInfoCompanyMapper ulcInfoCompanyMapper;
    @Autowired
    private UlcInfoCompanyParaMapper ulcInfoCompanyParaMapper;

    public UlcFrontBaseRspBo<UlcCompanyParamCreateWebServiceRspBo> createCompanyParam(UlcCompanyParamCreateWebServiceReqBo reqBo) {
        this.LOGGER.info("\u65b0\u589e\u7269\u6d41\u516c\u53f8\u53c2\u6570\u5165\u53c2\u5bf9\u8c61\uff1a" + JSON.toJSONString((Object)reqBo));
        UlcFrontBaseRspBo retBo = new UlcFrontBaseRspBo();
        UlcCompanyParamCreateWebServiceRspBo rspBo = new UlcCompanyParamCreateWebServiceRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((String)validateStr)) {
            this.LOGGER.error("\u53c2\u6570\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespDesc("5007");
            retBo.setRespDesc(validateStr);
            return retBo;
        }
        UlcInfoCompanyPo result = this.ulcInfoCompanyMapper.selectByPrimaryKey(reqBo.getCompanyId());
        if (result == null) {
            retBo.setRespCode("5005");
            retBo.setRespDesc("\u7269\u6d41\u516c\u53f8(" + reqBo.getCompanyId() + ")\u4e0d\u5b58\u5728\uff01");
            return retBo;
        }
        UlcInfoCompanyParaPo qryPara = new UlcInfoCompanyParaPo();
        qryPara.setCompanyId(reqBo.getCompanyId());
        qryPara.setParaCode(reqBo.getParaCode());
        List ulcInfoCompanyParaPos = this.ulcInfoCompanyParaMapper.selectByCondition(qryPara);
        if (!CollectionUtils.isEmpty((Collection)ulcInfoCompanyParaPos)) {
            retBo.setRespCode("5005");
            retBo.setRespDesc("\u8be5\u7269\u6d41\u516c\u53f8(" + reqBo.getCompanyId() + "),\u53c2\u6570(" + reqBo.getParaCode() + ")\u5df2\u5b58\u5728\uff01");
            return retBo;
        }
        UlcCompanyParamCreateBusiServiceReqBo busiServiceReqBo = new UlcCompanyParamCreateBusiServiceReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)busiServiceReqBo);
        UlcCompanyParamCreateBusiServiceRspBo busiServiceRsqBo = this.ulcCompanyParamCreateBusiService.createCompanyParam(busiServiceReqBo);
        if (!"\u6210\u529f".equals(busiServiceRsqBo.getRespDesc())) {
            retBo.setRespDesc("5007");
            retBo.setRespDesc("\u65b0\u589e\u7269\u6d41\u516c\u53f8\u53c2\u6570\u4fe1\u606f\u5931\u8d25\uff01");
            return retBo;
        }
        rspBo.setParaId(busiServiceRsqBo.getParaId());
        rspBo.setCompanyId(reqBo.getCompanyId());
        rspBo.setParaCode(reqBo.getParaCode());
        rspBo.setParaName(reqBo.getParaName());
        retBo.setData((Object)rspBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArgs(UlcCompanyParamCreateWebServiceReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        if (StringUtils.isEmpty((String)reqBo.getCompanyId())) {
            return "\u7269\u6d41\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        if (StringUtils.isEmpty((String)reqBo.getParaCode())) {
            return "\u53c2\u6570\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        if (StringUtils.isEmpty((String)reqBo.getParaName())) {
            return "\u53c2\u6570\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        return null;
    }
}

