/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.logistics.impl.web;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.logistics.common.base.UlcFrontBaseRspBo;
import com.tydic.logistics.common.base.UlcFrontPageRspBo;
import com.tydic.logistics.dao.UlcInfoCompanyMapper;
import com.tydic.logistics.dao.UlcInfoCompanyParaMapper;
import com.tydic.logistics.dao.po.UlcInfoCompanyParaPo;
import com.tydic.logistics.dao.po.UlcInfoCompanyPo;
import com.tydic.logistics.interfaces.atom.UlcDicMapQueryAtomService;
import com.tydic.logistics.interfaces.atom.bo.UlcDicMapQueryAtomReqBo;
import com.tydic.logistics.interfaces.atom.bo.UlcDicMapQueryAtomRspBo;
import com.tydic.logistics.web.UlcCompanyParamQueryWebService;
import com.tydic.logistics.web.bo.UlcCompanyParamManagerDataBo;
import com.tydic.logistics.web.bo.UlcCompanyParamQueryWebServiceReqBo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ulcLogisticsParamManageQueryWebService")
@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="ULC_GROUP_LOCAL", serviceInterface=UlcCompanyParamQueryWebService.class)
public class UlcCompanyParamQueryWebServiceImpl
implements UlcCompanyParamQueryWebService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UlcInfoCompanyParaMapper ulcInfoCompanyParaMapper;
    @Autowired
    private UlcDicMapQueryAtomService ulcDicMapQueryAtomService;
    @Autowired
    private UlcInfoCompanyMapper ulcInfoCompanyMapper;

    public UlcFrontBaseRspBo<UlcFrontPageRspBo<UlcCompanyParamManagerDataBo>> queryCompanyPara(UlcCompanyParamQueryWebServiceReqBo reqBo) {
        Page page;
        this.LOGGER.info("\u7269\u6d41\u516c\u53f8\u53c2\u6570\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        UlcFrontPageRspBo rspBo = new UlcFrontPageRspBo();
        UlcFrontBaseRspBo retBo = new UlcFrontBaseRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((String)validateStr)) {
            this.LOGGER.error("\u53c2\u6570\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("5002");
            retBo.setRespDesc("\u53c2\u6570\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        UlcInfoCompanyPo result = this.ulcInfoCompanyMapper.selectByPrimaryKey(reqBo.getCompanyId());
        if (result == null) {
            retBo.setRespCode("5005");
            retBo.setRespDesc("\u7269\u6d41\u516c\u53f8(" + reqBo.getCompanyId() + ")\u4e0d\u5b58\u5728\uff01");
            return retBo;
        }
        if (reqBo.getPageNo() > 1) {
            page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)page);
            if (page.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (page.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        UlcInfoCompanyParaPo qryPo = new UlcInfoCompanyParaPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryPo);
        List paraPos = this.ulcInfoCompanyParaMapper.selectPageByCondition(qryPo, page);
        ArrayList<UlcCompanyParamManagerDataBo> paraList = new ArrayList<UlcCompanyParamManagerDataBo>();
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add("COMPANY_STORE_TYPE_STATUS");
        typeList.add("COMPANY_REQUIRED_STATUS");
        typeList.add("COMPANY_PARAM_STATUS");
        Map<String, Map<String, String>> dicMap = this.queryDicData(typeList);
        for (UlcInfoCompanyParaPo paraPo : paraPos) {
            if (paraPo == null) continue;
            UlcCompanyParamManagerDataBo paraDataBo = new UlcCompanyParamManagerDataBo();
            BeanUtils.copyProperties((Object)paraPo, (Object)paraDataBo);
            if (!StringUtils.isEmpty((String)paraPo.getStoreType())) {
                paraDataBo.setStoreType(dicMap.get("COMPANY_STORE_TYPE_STATUS").get(paraPo.getStoreType()));
            }
            if (!StringUtils.isEmpty((String)paraPo.getRequired())) {
                paraDataBo.setRequired(dicMap.get("COMPANY_REQUIRED_STATUS").get(paraPo.getRequired()));
            }
            if (!StringUtils.isEmpty((String)paraPo.getStatus())) {
                paraDataBo.setStatus(dicMap.get("COMPANY_PARAM_STATUS").get(paraPo.getStatus()));
            }
            paraDataBo.setCompanyName(result.getCompanyName());
            paraList.add(paraDataBo);
        }
        rspBo.setRows(paraList);
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        retBo.setData((Object)rspBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private Map<String, Map<String, String>> queryDicData(List<String> typeList) {
        HashMap<String, Map<String, String>> retMap = new HashMap<String, Map<String, String>>(16);
        for (String pType : typeList) {
            UlcDicMapQueryAtomReqBo qryDicBo = new UlcDicMapQueryAtomReqBo();
            qryDicBo.setpType(pType);
            UlcDicMapQueryAtomRspBo dicRspBo = this.ulcDicMapQueryAtomService.queryDic(qryDicBo);
            retMap.put(pType, dicRspBo.getDataMap());
        }
        return retMap;
    }

    private String validateArgs(UlcCompanyParamQueryWebServiceReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        if (StringUtils.isEmpty((String)reqBo.getCompanyId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027companyId\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        return null;
    }
}

