/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.logistics.impl.web;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.logistics.common.base.UlcFrontBaseRspBo;
import com.tydic.logistics.dao.UlcInfoCompanyParaMapper;
import com.tydic.logistics.dao.po.UlcInfoCompanyParaPo;
import com.tydic.logistics.interfaces.busi.UlcCompanyParamUpdateBusiService;
import com.tydic.logistics.interfaces.busi.bo.UlcCompanyParamUpdateBusiServiceReqBo;
import com.tydic.logistics.interfaces.busi.bo.UlcCompanyParamUpdateBusiServiceRspBo;
import com.tydic.logistics.web.UlcCompanyParamUpdateWebService;
import com.tydic.logistics.web.bo.UlcCompanyParamUpdateWebServiceReqBo;
import com.tydic.logistics.web.bo.UlcCompanyParamUpdateWebServiceRspBo;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ulcCompanyParamUpdateWebService")
@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="ULC_GROUP_LOCAL", serviceInterface=UlcCompanyParamUpdateWebService.class)
public class UlcCompanyParamUpdateWebServiceImpl
implements UlcCompanyParamUpdateWebService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UlcCompanyParamUpdateBusiService ulcCompanyParamUpdateBusiService;
    @Autowired
    private UlcInfoCompanyParaMapper ulcInfoCompanyParaMapper;

    public UlcFrontBaseRspBo<UlcCompanyParamUpdateWebServiceRspBo> updateCompanyParam(UlcCompanyParamUpdateWebServiceReqBo reqBo) {
        this.LOGGER.info("\u4fee\u6539\u7269\u6d41\u516c\u53f8\u53c2\u6570\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        UlcCompanyParamUpdateWebServiceRspBo rspBo = new UlcCompanyParamUpdateWebServiceRspBo();
        UlcFrontBaseRspBo retBo = new UlcFrontBaseRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((String)validateStr)) {
            this.LOGGER.error("\u53c2\u6570\u6821\u9a8c\u5931\u8d25:" + validateStr);
            retBo.setRespCode("5008");
            retBo.setRespDesc(validateStr);
            return retBo;
        }
        UlcInfoCompanyParaPo ulcInfoCompanyParaPo = this.ulcInfoCompanyParaMapper.selectByPrimaryKey(reqBo.getParaId());
        if (ulcInfoCompanyParaPo == null) {
            retBo.setRespCode("5008");
            retBo.setRespDesc("\u8be5\u53c2\u6570id(" + reqBo.getParaId() + ")\u4fe1\u606f\u4e0d\u5b58\u5728");
            return retBo;
        }
        UlcInfoCompanyParaPo qryPara = new UlcInfoCompanyParaPo();
        qryPara.setCompanyId(reqBo.getCompanyId());
        qryPara.setParaCode(reqBo.getParaCode());
        List ulcInfoCompanyParaPos = this.ulcInfoCompanyParaMapper.selectByCondition(qryPara);
        for (UlcInfoCompanyParaPo po : ulcInfoCompanyParaPos) {
            if (po.getParaId().equals(reqBo.getParaId())) continue;
            retBo.setRespCode("5005");
            retBo.setRespDesc("\u8be5\u7269\u6d41\u516c\u53f8(" + reqBo.getCompanyId() + "),\u53c2\u6570(" + reqBo.getParaCode() + ")\u5df2\u5b58\u5728\uff01");
            return retBo;
        }
        UlcCompanyParamUpdateBusiServiceReqBo busiServiceReqBo = new UlcCompanyParamUpdateBusiServiceReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)busiServiceReqBo);
        UlcCompanyParamUpdateBusiServiceRspBo busiServiceRspBo = this.ulcCompanyParamUpdateBusiService.updateCompanyParam(busiServiceReqBo);
        if (!"\u6210\u529f".equals(busiServiceRspBo.getRespDesc())) {
            retBo.setRespCode("5008");
            retBo.setRespDesc("\u4fee\u6539\u7269\u6d41\u516c\u53f8\u53c2\u6570\u4fe1\u606f\u5931\u8d25\uff01");
            return retBo;
        }
        rspBo.setParaId(busiServiceRspBo.getParaId());
        rspBo.setCompanyId(reqBo.getCompanyId());
        rspBo.setParaCode(reqBo.getParaCode());
        rspBo.setParaName(reqBo.getParaName());
        retBo.setData((Object)rspBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArgs(UlcCompanyParamUpdateWebServiceReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        if (reqBo.getParaId() == null) {
            return "\u53c2\u6570id\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        if (StringUtils.isEmpty((String)reqBo.getCompanyId())) {
            return "\u7269\u6d41\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        if (StringUtils.isEmpty((String)reqBo.getParaCode())) {
            return "\u53c2\u6570\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        if (StringUtils.isEmpty((String)reqBo.getParaName())) {
            return "\u53c2\u6570\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        return null;
    }
}

