/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.logistics.impl.web;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.logistics.common.base.UlcFrontBaseRspBo;
import com.tydic.logistics.dao.UlcInfoCompanyMapper;
import com.tydic.logistics.dao.UlcInfoProductMapper;
import com.tydic.logistics.dao.po.UlcInfoCompanyPo;
import com.tydic.logistics.dao.po.UlcInfoProductPo;
import com.tydic.logistics.interfaces.busi.UlcCompanyProductCreateBusiService;
import com.tydic.logistics.interfaces.busi.bo.UlcCompanyProductCreateBusiServiceReqBo;
import com.tydic.logistics.interfaces.busi.bo.UlcCompanyProductCreateBusiServiceRspBo;
import com.tydic.logistics.web.UlcCompanyProductCreateWebService;
import com.tydic.logistics.web.bo.UlcCompanyProductCreateWebServiceReqBo;
import com.tydic.logistics.web.bo.UlcCompanyProductCreateWebServiceRspBo;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="ulcCompanyProductCreateWebService")
@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="ULC_GROUP_LOCAL", serviceInterface=UlcCompanyProductCreateWebService.class)
public class UlcCompanyProductCreateWebServiceImpl
implements UlcCompanyProductCreateWebService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UlcCompanyProductCreateBusiService ulcCompanyProductCreateBusiService;
    @Autowired
    private UlcInfoCompanyMapper ulcInfoCompanyMapper;
    @Autowired
    private UlcInfoProductMapper ulcInfoProductMapper;

    public UlcFrontBaseRspBo<UlcCompanyProductCreateWebServiceRspBo> createCompanyProduct(UlcCompanyProductCreateWebServiceReqBo reqBo) {
        this.LOGGER.info("\u65b0\u589e\u7269\u6d41\u516c\u53f8\u4ea7\u54c1\u5165\u53c2\u5bf9\u8c61\uff1a" + JSON.toJSONString((Object)reqBo));
        UlcCompanyProductCreateWebServiceRspBo rspBo = new UlcCompanyProductCreateWebServiceRspBo();
        UlcFrontBaseRspBo retBo = new UlcFrontBaseRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((String)validateStr)) {
            this.LOGGER.error("\u53c2\u6570\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("5009");
            retBo.setRespDesc(validateStr);
            return retBo;
        }
        UlcInfoCompanyPo result = this.ulcInfoCompanyMapper.selectByPrimaryKey(reqBo.getCompanyId());
        if (result == null) {
            retBo.setRespCode("5009");
            retBo.setRespDesc("\u7269\u6d41\u516c\u53f8(" + reqBo.getCompanyId() + ")\u4e0d\u5b58\u5728\uff01");
            return retBo;
        }
        UlcInfoProductPo qryProductPo = new UlcInfoProductPo();
        qryProductPo.setProductCode(reqBo.getProductCode());
        qryProductPo.setCompanyId(reqBo.getCompanyId());
        List ulcInfoProductPos = this.ulcInfoProductMapper.selectByCondition(qryProductPo);
        if (!CollectionUtils.isEmpty((Collection)ulcInfoProductPos)) {
            retBo.setRespCode("5009");
            retBo.setRespDesc("\u8be5\u7269\u6d41\u516c\u53f8(" + reqBo.getCompanyId() + ")\uff0c\u4ea7\u54c1(" + reqBo.getProductCode() + ")\u5df2\u5b58\u5728\uff01");
            return retBo;
        }
        UlcCompanyProductCreateBusiServiceReqBo busiServiceReqBo = new UlcCompanyProductCreateBusiServiceReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)busiServiceReqBo);
        UlcCompanyProductCreateBusiServiceRspBo busiServiceRspBo = this.ulcCompanyProductCreateBusiService.createCompanyProduct(busiServiceReqBo);
        if (!"\u6210\u529f".equals(busiServiceRspBo.getRespDesc())) {
            retBo.setRespCode("5009");
            retBo.setRespDesc("\u65b0\u589e\u7269\u6d41\u516c\u53f8\u4ea7\u54c1\u5931\u8d25\uff01");
            return retBo;
        }
        rspBo.setProductId(busiServiceRspBo.getProductId());
        rspBo.setCompanyId(reqBo.getCompanyId());
        rspBo.setProductCode(reqBo.getProductCode());
        rspBo.setProductName(reqBo.getProductName());
        retBo.setData((Object)rspBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArgs(UlcCompanyProductCreateWebServiceReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        if (StringUtils.isEmpty((String)reqBo.getCompanyId())) {
            return "\u7269\u6d41\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        if (StringUtils.isEmpty((String)reqBo.getProductCode())) {
            return "\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        if (StringUtils.isEmpty((String)reqBo.getProductName())) {
            return "\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        return null;
    }
}

