/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.logistics.impl.web;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.logistics.dao.UlcInfoProductMapper;
import com.tydic.logistics.dao.po.UlcInfoProductPo;
import com.tydic.logistics.web.UlcCompanyProductDeleteWebService;
import com.tydic.logistics.web.bo.UlcCompanyProductDeleteWebServiceReqBo;
import com.tydic.logistics.web.bo.UlcCompanyProductDeleteWebServiceRspBo;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ulcCompanyProductDeleteWebService")
@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="ULC_GROUP_LOCAL", serviceInterface=UlcCompanyProductDeleteWebService.class)
public class UlcCompanyProductDeleteWebServiceImpl
implements UlcCompanyProductDeleteWebService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UlcInfoProductMapper ulcInfoProductMapper;

    public UlcCompanyProductDeleteWebServiceRspBo deleteCompanyProductInfo(UlcCompanyProductDeleteWebServiceReqBo reqBo) {
        this.LOGGER.info("\u5220\u9664\u7269\u6d41\u516c\u53f8\u4ea7\u54c1\u4fe1\u606f\u5165\u53c2\u5bf9\u8c61\uff1a" + JSON.toJSONString((Object)reqBo));
        UlcCompanyProductDeleteWebServiceRspBo rspBo = new UlcCompanyProductDeleteWebServiceRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((String)validateStr)) {
            this.LOGGER.error("\u53c2\u6570\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            rspBo.setRespCode("2004");
            rspBo.setRespDesc(validateStr);
            return rspBo;
        }
        UlcInfoProductPo productPo = this.ulcInfoProductMapper.selectByPrimaryKey(reqBo.getProductId());
        UlcInfoProductPo qryRspBo = this.ulcInfoProductMapper.selectByPrimaryKey(reqBo.getProductId());
        if (qryRspBo == null) {
            rspBo.setRespCode("2004");
            rspBo.setRespDesc("\u8be5\u4ea7\u54c1" + reqBo.getProductId() + "\u4e0d\u5b58\u5728");
            return rspBo;
        }
        int relCounts = this.ulcInfoProductMapper.deleteByPrimaryKey(reqBo.getProductId());
        if (relCounts < 1) {
            throw new BusinessException("6011", "\u5220\u9664\u7269\u6d41\u516c\u53f8\u4ea7\u54c1\u4fe1\u606f\u5f02\u5e38,\u5220\u9664\u7ed3\u679c\u503c\u5c0f\u4e8e1");
        }
        rspBo.setProductId(reqBo.getProductId());
        rspBo.setCompanyId(productPo.getCompanyId());
        rspBo.setProductCode(productPo.getProductCode());
        rspBo.setProductName(productPo.getProductName());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private String validateArgs(UlcCompanyProductDeleteWebServiceReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        if (StringUtils.isEmpty((String)reqBo.getProductId())) {
            return "\u7269\u6d41\u516c\u53f8\u4ea7\u54c1id\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        return null;
    }
}

