/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.logistics.impl.web;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.logistics.common.base.UlcFrontBaseRspBo;
import com.tydic.logistics.common.base.UlcFrontPageRspBo;
import com.tydic.logistics.dao.UlcInfoProductMapper;
import com.tydic.logistics.dao.po.UlcInfoProductPo;
import com.tydic.logistics.web.UlcCompanyProductQueryWebService;
import com.tydic.logistics.web.bo.UlcCompanyProductManagerDataBo;
import com.tydic.logistics.web.bo.UlcCompanyProductQueryWebServiceReqBo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ulcLogisticsProductManageQueryWebService")
@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="ULC_GROUP_LOCAL", serviceInterface=UlcCompanyProductQueryWebService.class)
public class UlcCompanyProductQueryWebServiceImpl
implements UlcCompanyProductQueryWebService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UlcInfoProductMapper ulcInfoProductMapper;

    public UlcFrontBaseRspBo<UlcFrontPageRspBo<UlcCompanyProductManagerDataBo>> queryCompanyProduct(UlcCompanyProductQueryWebServiceReqBo reqBo) {
        Page page;
        this.LOGGER.info("\u7269\u6d41\u4ea7\u54c1\u67e5\u8be2\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        UlcFrontBaseRspBo retBo = new UlcFrontBaseRspBo();
        UlcFrontPageRspBo rspBo = new UlcFrontPageRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((String)validateStr)) {
            this.LOGGER.error("\u53c2\u6570\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("5003");
            retBo.setRespDesc("\u53c2\u6570\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        if (reqBo.getPageNo() > 1) {
            page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)page);
            if (page.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (page.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        UlcInfoProductPo qryPo = new UlcInfoProductPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryPo);
        List productPos = this.ulcInfoProductMapper.selectPageByCondition(qryPo, page);
        ArrayList<UlcCompanyProductManagerDataBo> productList = new ArrayList<UlcCompanyProductManagerDataBo>();
        for (UlcInfoProductPo productPo : productPos) {
            UlcCompanyProductManagerDataBo productManagerDataBo = new UlcCompanyProductManagerDataBo();
            BeanUtils.copyProperties((Object)productPo, (Object)productManagerDataBo);
            productList.add(productManagerDataBo);
        }
        rspBo.setRows(productList);
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        retBo.setData((Object)rspBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArgs(UlcCompanyProductQueryWebServiceReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        if (StringUtils.isEmpty((String)reqBo.getCompanyId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027companyId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

