/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.logistics.impl.web;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.logistics.common.base.UlcFrontBaseRspBo;
import com.tydic.logistics.common.base.UlcFrontPageRspBo;
import com.tydic.logistics.dao.UlcInfoCompanyMapper;
import com.tydic.logistics.dao.po.UlcInfoCompanyPo;
import com.tydic.logistics.interfaces.atom.UlcDicMapQueryAtomService;
import com.tydic.logistics.interfaces.atom.UlcDicQueryAtomService;
import com.tydic.logistics.interfaces.atom.bo.UlcDicMapQueryAtomReqBo;
import com.tydic.logistics.interfaces.atom.bo.UlcDicMapQueryAtomRspBo;
import com.tydic.logistics.web.UlcCompanyQueryWebService;
import com.tydic.logistics.web.bo.UlcCompanyInfoWebServiceDataBo;
import com.tydic.logistics.web.bo.UlcCompanyQueryWebServiceReqBo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ulcCompanyListQueryWebService")
@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="ULC_GROUP_LOCAL", serviceInterface=UlcCompanyQueryWebService.class)
public class UlcCompanyQueryWebServiceImpl
implements UlcCompanyQueryWebService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UlcInfoCompanyMapper ulcInfoCompanyMapper;
    @Autowired
    private UlcDicQueryAtomService ulcDicQueryAtomService;
    @Autowired
    private UlcDicMapQueryAtomService ulcDicMapQueryAtomService;

    public UlcFrontBaseRspBo<UlcFrontPageRspBo<UlcCompanyInfoWebServiceDataBo>> queryCompanyList(UlcCompanyQueryWebServiceReqBo reqBo) {
        this.LOGGER.info("\u8fdb\u5165\u7269\u6d41\u4e2d\u5fc3\u7269\u6d41\u516c\u53f8\u7ffb\u9875\u67e5\u8be2\u670d\u52a1\uff1a" + JSON.toJSONString((Object)reqBo));
        UlcFrontBaseRspBo retBo = new UlcFrontBaseRspBo();
        UlcFrontPageRspBo rspBo = new UlcFrontPageRspBo();
        String validateStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((String)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("5001");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        ArrayList<UlcCompanyInfoWebServiceDataBo> companyDataBo = new ArrayList<UlcCompanyInfoWebServiceDataBo>();
        rspBo.setRows(companyDataBo);
        Page page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        UlcInfoCompanyPo qryPagePo = new UlcInfoCompanyPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryPagePo);
        List ulcInfoCompanyPos = this.ulcInfoCompanyMapper.selectPageByCondition(qryPagePo, page);
        if (ulcInfoCompanyPos == null || ulcInfoCompanyPos.isEmpty()) {
            this.LOGGER.info("\u67e5\u8be2\u6570\u636e\uff0c\u76f4\u63a5\u8fd4\u56de");
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u6210\u529f");
            return retBo;
        }
        UlcDicMapQueryAtomReqBo qryDicBo = new UlcDicMapQueryAtomReqBo();
        qryDicBo.setpType("COMPANY_INFO_STATUS");
        UlcDicMapQueryAtomRspBo dicRspBo = this.ulcDicMapQueryAtomService.queryDic(qryDicBo);
        if (!"0000".equals(dicRspBo.getRespCode())) {
            retBo.setRespCode("5001");
            retBo.setRespDesc("\u67e5\u8be2\u7269\u6d41\u516c\u53f8\u72b6\u6001 \u5b57\u5178\u4fe1\u606f\u5931\u8d25\uff1a" + dicRspBo.getRespDesc());
            return retBo;
        }
        Map dicRspMap = dicRspBo.getDataMap();
        for (UlcInfoCompanyPo companyPo : ulcInfoCompanyPos) {
            UlcCompanyInfoWebServiceDataBo dataBo = new UlcCompanyInfoWebServiceDataBo();
            BeanUtils.copyProperties((Object)companyPo, (Object)dataBo);
            dataBo.setStatus((String)dicRspMap.get(companyPo.getStatus()));
            companyDataBo.add(dataBo);
        }
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        retBo.setData((Object)rspBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArg(UlcCompanyQueryWebServiceReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        return null;
    }
}

