/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.logistics.impl.web;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.logistics.common.base.UlcFrontBaseRspBo;
import com.tydic.logistics.dao.UlcInfoCompanyMapper;
import com.tydic.logistics.dao.po.UlcInfoCompanyPo;
import com.tydic.logistics.interfaces.busi.UlcCompanyUpdateBusiService;
import com.tydic.logistics.interfaces.busi.bo.UlcCompanyUpdateBusiServiceReqBo;
import com.tydic.logistics.interfaces.busi.bo.UlcCompanyUpdateBusiServiceRspBo;
import com.tydic.logistics.web.UlcCompanyUpdateWebService;
import com.tydic.logistics.web.bo.UlcCompanyUpdateWebServiceReqBo;
import com.tydic.logistics.web.bo.UlcCompanyUpdateWebServiceRspBo;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ulcCompanyUpdateWebService")
@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="ULC_GROUP_LOCAL", serviceInterface=UlcCompanyUpdateWebService.class)
public class UlcCompanyUpdateWebServiceImpl
implements UlcCompanyUpdateWebService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UlcCompanyUpdateBusiService ulcCompanyUpdateBusiService;
    @Autowired
    private UlcInfoCompanyMapper ulcInfoCompanyMapper;

    public UlcFrontBaseRspBo<UlcCompanyUpdateWebServiceRspBo> updateCompanyInfo(UlcCompanyUpdateWebServiceReqBo reqBo) {
        this.LOGGER.info("\u4fee\u6539\u7269\u6d41\u516c\u53f8\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        UlcCompanyUpdateWebServiceRspBo rspBo = new UlcCompanyUpdateWebServiceRspBo();
        UlcFrontBaseRspBo retBo = new UlcFrontBaseRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((String)validateStr)) {
            this.LOGGER.error("\u53c2\u6570\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("5005");
            retBo.setRespDesc(validateStr);
            return retBo;
        }
        UlcInfoCompanyPo result = this.ulcInfoCompanyMapper.selectByPrimaryKey(reqBo.getCompanyId());
        if (result == null) {
            retBo.setRespCode("5005");
            retBo.setRespDesc("\u7269\u6d41\u516c\u53f8(" + reqBo.getCompanyId() + ")\u4e0d\u5b58\u5728\uff01");
            return retBo;
        }
        UlcCompanyUpdateBusiServiceReqBo busiServiceReqBo = new UlcCompanyUpdateBusiServiceReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)busiServiceReqBo);
        UlcCompanyUpdateBusiServiceRspBo busiServiceRspBo = this.ulcCompanyUpdateBusiService.updateCompanyInfo(busiServiceReqBo);
        if (!"\u6210\u529f".equals(busiServiceRspBo.getRespDesc())) {
            retBo.setRespCode("5005");
            retBo.setRespDesc(busiServiceRspBo.getRespDesc());
            return retBo;
        }
        rspBo.setCompanyId(reqBo.getCompanyId());
        rspBo.setCompanyName(reqBo.getCompanyName());
        retBo.setData((Object)rspBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArgs(UlcCompanyUpdateWebServiceReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        if (StringUtils.isEmpty((String)reqBo.getCompanyId())) {
            return "\u7269\u6d41\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        if (StringUtils.isEmpty((String)reqBo.getCompanyName())) {
            return "\u7269\u6d41\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01";
        }
        return null;
    }
}

