/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.logistics.impl.web;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.logistics.config.UlcSequenceConfig;
import com.tydic.logistics.constants.UlcSequenceKeys;
import com.tydic.logistics.dao.UlcInfoMerchantMapper;
import com.tydic.logistics.dao.UlcLogisticsOrderMapper;
import com.tydic.logistics.dao.po.UlcInfoMerchantPo;
import com.tydic.logistics.web.UlcMerchantCreateWebService;
import com.tydic.logistics.web.bo.UlcMerchantCreateWebServiceReqBo;
import com.tydic.logistics.web.bo.UlcMerchantCreateWebServiceRspBo;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="ulcMerchantCreateWebService")
@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="ULC_GROUP_LOCAL", serviceInterface=UlcMerchantCreateWebService.class)
public class UlcMerchantCreateWebServiceImpl
implements UlcMerchantCreateWebService {
    private Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UlcInfoMerchantMapper ulcInfoMerchantMapper;
    @Autowired
    private UlcLogisticsOrderMapper ulcLogisticsOrderMapper;
    @Autowired
    private UlcSequenceConfig ulcSequenceConfig;

    public UlcMerchantCreateWebServiceRspBo createMerchant(UlcMerchantCreateWebServiceReqBo reqBo) {
        this.LOGGER.info("\u7269\u6d41\u4e2d\u5fc3\u5546\u6237\u521b\u5efa\uff1a" + JSONObject.toJSONString((Object)reqBo));
        UlcMerchantCreateWebServiceRspBo retBo = new UlcMerchantCreateWebServiceRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("5019");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        UlcInfoMerchantPo qryPo = new UlcInfoMerchantPo();
        qryPo.setMerchantName(reqBo.getMerchantName());
        List poList = this.ulcInfoMerchantMapper.selectBySelective(qryPo);
        if (!CollectionUtils.isEmpty((Collection)poList)) {
            this.LOGGER.error("\u6b64\u5546\u6237\u540d\u79f0\uff08" + reqBo.getMerchantName() + "\uff09\u5df2\u5b58\u5728");
            retBo.setRespCode("5019");
            retBo.setRespDesc("\u6b64\u5546\u6237\u540d\u79f0\uff08" + reqBo.getMerchantName() + "\uff09\u5df2\u5b58\u5728");
            return retBo;
        }
        Long merchantId = 0L;
        try {
            merchantId = this.ulcSequenceConfig.nextId(UlcSequenceKeys.SEQUENCE_MERCHANT.getSequenceName());
        }
        catch (Exception e) {
            this.LOGGER.error("\u521b\u5efa\u7269\u6d41\u4e2d\u5fc3\u5546\u6237\uff0c \u83b7\u53d6\u5546\u6237ID\u5f02\u5e38\uff1a" + e);
            throw new BusinessException("7002", "\u521b\u5efa\u7269\u6d41\u4e2d\u5fc3\u5546\u6237\uff0c \u83b7\u53d6\u5546\u6237ID\u5f02\u5e38:" + e);
        }
        UlcInfoMerchantPo po = new UlcInfoMerchantPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)po);
        po.setMerchantId(merchantId);
        Date now = this.ulcLogisticsOrderMapper.getDbDate().getDate();
        po.setCreateTime(now);
        int result = this.ulcInfoMerchantMapper.insert(po);
        if (result < 1) {
            this.LOGGER.error("\u521b\u5efa\u7269\u6d41\u4e2d\u5fc3\u5546\u6237\u5931\u8d25\uff0c\u5199\u5165\u6570\u636e\u5931\u8d25");
            retBo.setRespCode("5019");
            retBo.setRespDesc("\u521b\u5efa\u7269\u6d41\u4e2d\u5fc3\u5546\u6237\u5931\u8d25\uff0c\u5199\u5165\u6570\u636e\u5931\u8d25");
            return retBo;
        }
        BeanUtils.copyProperties((Object)po, (Object)retBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArgs(UlcMerchantCreateWebServiceReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantName())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'merchantName'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getStatus())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'status'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

