/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.logistics.impl.web;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.tydic.logistics.common.base.UlcFrontBaseRspBo;
import com.tydic.logistics.dao.UlcInfoCompanyMapper;
import com.tydic.logistics.dao.UlcInfoLogisticsParaAttrMapper;
import com.tydic.logistics.dao.UlcInfoMerchantMapper;
import com.tydic.logistics.dao.UlcInfoProductMapper;
import com.tydic.logistics.dao.UlcRelMerchantLogisticsMapper;
import com.tydic.logistics.dao.po.UlcInfoCompanyPo;
import com.tydic.logistics.dao.po.UlcInfoLogisticsParaAttrPo;
import com.tydic.logistics.dao.po.UlcInfoMerchantPo;
import com.tydic.logistics.dao.po.UlcInfoProductPo;
import com.tydic.logistics.dao.po.UlcRelMerchantLogisticsPo;
import com.tydic.logistics.web.UlcMerchantDetailWebService;
import com.tydic.logistics.web.bo.UlcLogisticsParaAttrDateBo;
import com.tydic.logistics.web.bo.UlcMerchantDetailCompanyDataBo;
import com.tydic.logistics.web.bo.UlcMerchantDetailWebServiceReqBo;
import com.tydic.logistics.web.bo.UlcMerchantQryWebServiceDataBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="ulcMerchantDetailWebService")
@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="ULC_GROUP_LOCAL", serviceInterface=UlcMerchantDetailWebService.class)
public class UlcMerchantDetailWebServiceImpl
implements UlcMerchantDetailWebService {
    private Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UlcInfoMerchantMapper ulcInfoMerchantMapper;
    @Autowired
    private UlcRelMerchantLogisticsMapper ulcRelMerchantLogisticsMapper;
    @Autowired
    private UlcInfoCompanyMapper ulcInfoCompanyMapper;
    @Autowired
    private UlcInfoProductMapper ulcInfoProductMapper;
    @Autowired
    private UlcInfoLogisticsParaAttrMapper ulcInfoLogisticsParaAttrMapper;

    public UlcFrontBaseRspBo<UlcMerchantQryWebServiceDataBo> qryDetailMerchant(UlcMerchantDetailWebServiceReqBo reqBo) {
        this.LOGGER.info("\u7269\u6d41\u4e2d\u5fc3\u5546\u6237\u8be6\u60c5\u67e5\u8be2\uff1a" + JSONObject.toJSONString((Object)reqBo));
        UlcFrontBaseRspBo retBo = new UlcFrontBaseRspBo();
        UlcMerchantQryWebServiceDataBo rspBo = new UlcMerchantQryWebServiceDataBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("5021");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        UlcInfoMerchantPo po = this.ulcInfoMerchantMapper.selectByPrimaryKey(Long.valueOf(reqBo.getMerchantId()));
        if (po == null) {
            this.LOGGER.error("\u672a\u67e5\u8be2\u5230\u4e0e\uff08" + reqBo.getMerchantId() + "\uff09\u76f8\u5339\u914d\u7684\u4fe1\u606f ");
            retBo.setRespCode("5021");
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u4e0e\uff08" + reqBo.getMerchantId() + "\uff09\u76f8\u5339\u914d\u7684\u4fe1\u606f ");
            return retBo;
        }
        List<UlcMerchantDetailCompanyDataBo> companyDataBos = this.getCompanyInfo(reqBo);
        if (CollectionUtils.isEmpty(companyDataBos)) {
            this.LOGGER.error("\u672a\u67e5\u8be2\u5230\uff08" + reqBo.getMerchantId() + "\uff09\u914d\u7f6e\u7684\u7269\u6d41\u516c\u53f8\u76f8\u5173\u4fe1\u606f ");
        }
        BeanUtils.copyProperties((Object)po, (Object)rspBo);
        rspBo.setCompanyList(companyDataBos);
        retBo.setData((Object)rspBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private List<UlcMerchantDetailCompanyDataBo> getCompanyInfo(UlcMerchantDetailWebServiceReqBo reqBo) {
        ArrayList<UlcMerchantDetailCompanyDataBo> companyDataBos = new ArrayList<UlcMerchantDetailCompanyDataBo>();
        UlcRelMerchantLogisticsPo relPo = new UlcRelMerchantLogisticsPo();
        relPo.setMerchantId(Long.valueOf(reqBo.getMerchantId()));
        List relPoList = this.ulcRelMerchantLogisticsMapper.selectByRecord(relPo);
        if (CollectionUtils.isEmpty((Collection)relPoList)) {
            return null;
        }
        HashSet<String> companySet = new HashSet<String>();
        HashMap<String, String> productMap = new HashMap<String, String>(16);
        HashMap<Long, String> paraMap = new HashMap<Long, String>(16);
        for (UlcRelMerchantLogisticsPo relMerchantLogisticsPo : relPoList) {
            companySet.add(relMerchantLogisticsPo.getCompanyId());
            productMap.put(relMerchantLogisticsPo.getProductId(), relMerchantLogisticsPo.getCompanyId());
            paraMap.put(relMerchantLogisticsPo.getLogisticsParaId(), relMerchantLogisticsPo.getCompanyId());
        }
        for (String companyId : companySet) {
            UlcMerchantDetailCompanyDataBo companyData = new UlcMerchantDetailCompanyDataBo();
            UlcInfoCompanyPo companyPo = this.ulcInfoCompanyMapper.selectByPrimaryKey(companyId);
            if (companyPo == null) {
                this.LOGGER.error("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u7684\u7269\u6d41\u516c\u53f8\u4fe1\u606f\uff08" + companyId + "\uff09");
                break;
            }
            String company = companyPo.getCompanyName() + "(" + companyId + "):";
            this.LOGGER.info("\u516c\u53f8\uff1a" + company);
            companyData.setCompanyName(company);
            String product = "";
            StringBuilder sbProduct = new StringBuilder(product);
            Iterator it = productMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!companyId.equals(entry.getValue())) continue;
                UlcInfoProductPo productPo = this.ulcInfoProductMapper.selectByPrimaryKey((String)entry.getKey());
                it.remove();
                if (productPo == null) {
                    this.LOGGER.error("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u7684\u7269\u6d41\u4ea7\u54c1\u4fe1\u606f\uff08" + (String)entry.getKey() + "\uff09");
                    continue;
                }
                sbProduct.append(productPo.getProductName()).append(",");
            }
            if (sbProduct.length() > 1) {
                sbProduct.deleteCharAt(sbProduct.length() - 1);
            }
            product = sbProduct.toString();
            this.LOGGER.info("\u4ea7\u54c1\uff1a" + product);
            companyData.setProduct(product);
            ArrayList<UlcLogisticsParaAttrDateBo> paramList = new ArrayList<UlcLogisticsParaAttrDateBo>();
            Iterator paramIt = paraMap.entrySet().iterator();
            while (paramIt.hasNext()) {
                Map.Entry entry = paramIt.next();
                if (!companyId.equals(entry.getValue())) continue;
                List paraAttrPos = this.ulcInfoLogisticsParaAttrMapper.selectByLogisticsParaId((Long)entry.getKey());
                paramIt.remove();
                if (CollectionUtils.isEmpty((Collection)paraAttrPos)) {
                    this.LOGGER.error("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u7684\u7269\u6d41\u53c2\u6570\u4fe1\u606f\uff08" + entry.getKey() + "\uff09");
                    continue;
                }
                for (UlcInfoLogisticsParaAttrPo paraAttrPo : paraAttrPos) {
                    UlcLogisticsParaAttrDateBo attrDaaBo = new UlcLogisticsParaAttrDateBo();
                    BeanUtils.copyProperties((Object)paraAttrPo, (Object)attrDaaBo);
                    paramList.add(attrDaaBo);
                }
            }
            companyData.setParamList(paramList);
            companyDataBos.add(companyData);
        }
        return companyDataBos;
    }

    private String validateArgs(UlcMerchantDetailWebServiceReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'merchantId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

