/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.logistics.impl.web;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.logistics.common.base.UlcFrontBaseRspBo;
import com.tydic.logistics.common.base.UlcFrontPageRspBo;
import com.tydic.logistics.dao.UlcInfoMerchantMapper;
import com.tydic.logistics.dao.po.UlcInfoMerchantPo;
import com.tydic.logistics.interfaces.atom.UlcDicMapQueryAtomService;
import com.tydic.logistics.interfaces.atom.bo.UlcDicMapQueryAtomReqBo;
import com.tydic.logistics.interfaces.atom.bo.UlcDicMapQueryAtomRspBo;
import com.tydic.logistics.web.UlcMerchantPageQryWebService;
import com.tydic.logistics.web.bo.UlcMerchantPageQryWebServiceReqBo;
import com.tydic.logistics.web.bo.UlcMerchantQryWebServiceDataBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="ulcMerchantPageQryWebService")
@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="ULC_GROUP_LOCAL", serviceInterface=UlcMerchantPageQryWebService.class)
public class UlcMerchantPageQryWebServiceImpl
implements UlcMerchantPageQryWebService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UlcInfoMerchantMapper ulcInfoMerchantMapper;
    @Autowired
    private UlcDicMapQueryAtomService ulcDicMapQueryAtomService;

    public UlcFrontBaseRspBo<UlcFrontPageRspBo<UlcMerchantQryWebServiceDataBo>> qryMerchant(UlcMerchantPageQryWebServiceReqBo reqBo) {
        Page page;
        this.LOGGER.info("\u7269\u6d41\u4e2d\u5fc3\u5546\u6237\u67e5\u8be2\uff1a" + JSONObject.toJSONString((Object)reqBo));
        UlcFrontBaseRspBo retBo = new UlcFrontBaseRspBo();
        UlcFrontPageRspBo rspBo = new UlcFrontPageRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("5018");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        UlcInfoMerchantPo qryPo = new UlcInfoMerchantPo();
        if (reqBo.getPageNo() != 1) {
            page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)page);
            if (page.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (page.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)qryPo);
        List poList = this.ulcInfoMerchantMapper.selectBySelectivePage(qryPo, page);
        if (CollectionUtils.isEmpty((Collection)poList)) {
            this.LOGGER.error("\u67e5\u8be2\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u4efb\u4f55\u6570\u636e");
            retBo.setRespCode("5018");
            retBo.setRespDesc("\u67e5\u8be2\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u4efb\u4f55\u6570\u636e");
            return retBo;
        }
        ArrayList<UlcMerchantQryWebServiceDataBo> dataList = new ArrayList<UlcMerchantQryWebServiceDataBo>();
        UlcDicMapQueryAtomReqBo qryDicBo = new UlcDicMapQueryAtomReqBo();
        qryDicBo.setpType("MERCHANT_DETAIL_STATUS");
        UlcDicMapQueryAtomRspBo dicValue = this.ulcDicMapQueryAtomService.queryDic(qryDicBo);
        Map valueMap = dicValue.getDataMap();
        for (UlcInfoMerchantPo po : poList) {
            UlcMerchantQryWebServiceDataBo dataBo = new UlcMerchantQryWebServiceDataBo();
            BeanUtils.copyProperties((Object)po, (Object)dataBo);
            dataBo.setStatus((String)valueMap.get(po.getStatus()));
            dataList.add(dataBo);
        }
        rspBo.setRows(dataList);
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        retBo.setData((Object)rspBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArgs(UlcMerchantPageQryWebServiceReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

