/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.logistics.impl.web;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.tydic.logistics.dao.UlcInfoMerchantMapper;
import com.tydic.logistics.dao.UlcLogisticsOrderMapper;
import com.tydic.logistics.dao.po.UlcInfoMerchantPo;
import com.tydic.logistics.web.UlcMerchantUpdateWebService;
import com.tydic.logistics.web.bo.UlcMerchantUpdateWebServiceReqBo;
import com.tydic.logistics.web.bo.UlcMerchantUpdateWebServiceRspBo;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="ulcMerchantUpdateWebService")
@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="ULC_GROUP_LOCAL", serviceInterface=UlcMerchantUpdateWebService.class)
public class UlcMerchantUpdateWebServiceImpl
implements UlcMerchantUpdateWebService {
    private Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UlcInfoMerchantMapper ulcInfoMerchantMapper;
    @Autowired
    private UlcLogisticsOrderMapper ulcLogisticsOrderMapper;

    public UlcMerchantUpdateWebServiceRspBo updateMerchant(UlcMerchantUpdateWebServiceReqBo reqBo) {
        this.LOGGER.info("\u7269\u6d41\u4e2d\u5fc3\u5546\u6237\u66f4\u65b0:" + JSONObject.toJSONString((Object)reqBo));
        UlcMerchantUpdateWebServiceRspBo retBo = new UlcMerchantUpdateWebServiceRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("5020");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        UlcInfoMerchantPo reqPo = new UlcInfoMerchantPo();
        reqPo.setMerchantName(reqBo.getMerchantName());
        List poList = this.ulcInfoMerchantMapper.selectBySelective(reqPo);
        for (UlcInfoMerchantPo po : poList) {
            if (po.getMerchantId().equals(reqBo.getMerchantId())) continue;
            this.LOGGER.error("\u6b64\u5546\u6237\u540d\uff08" + reqBo.getMerchantName() + "\uff09\u5df2\u5b58\u5728");
            retBo.setRespCode("5020");
            retBo.setRespDesc("\u6b64\u5546\u6237\u540d\uff08" + reqBo.getMerchantName() + "\uff09\u5df2\u5b58\u5728");
            return retBo;
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)reqPo);
        reqPo.setMerchantId(Long.valueOf(reqBo.getMerchantId()));
        Date now = this.ulcLogisticsOrderMapper.getDbDate().getDate();
        reqPo.setUpdateTime(now);
        int result = this.ulcInfoMerchantMapper.updateByPrimaryKeySelective(reqPo);
        if (result < 1) {
            this.LOGGER.error("\u7269\u6d41\u4e2d\u5fc3\u5546\u6237\u66f4\u65b0\uff0c\u66f4\u65b0\u6570\u636e\u5931\u8d25");
            retBo.setRespCode("5020");
            retBo.setRespDesc("\u7269\u6d41\u4e2d\u5fc3\u5546\u6237\u66f4\u65b0\uff0c\u66f4\u65b0\u6570\u636e\u5931\u8d25");
            return retBo;
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArgs(UlcMerchantUpdateWebServiceReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantName())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'merchantName'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'merchantId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getStatus())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'status'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

