/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.logistics.impl.web;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.db.Page;
import com.tydic.logistics.common.base.UlcFrontBaseRspBo;
import com.tydic.logistics.common.base.UlcFrontPageRspBo;
import com.tydic.logistics.dao.UlcInfoBusiSysMapper;
import com.tydic.logistics.dao.UlcInfoMerchantMapper;
import com.tydic.logistics.dao.UlcInfoOrgMapper;
import com.tydic.logistics.dao.po.UlcInfoBusiSysPo;
import com.tydic.logistics.dao.po.UlcInfoMerchantPo;
import com.tydic.logistics.dao.po.UlcInfoOrgPo;
import com.tydic.logistics.interfaces.atom.UlcDicMapQueryAtomService;
import com.tydic.logistics.interfaces.atom.bo.UlcDicMapQueryAtomReqBo;
import com.tydic.logistics.interfaces.atom.bo.UlcDicMapQueryAtomRspBo;
import com.tydic.logistics.web.UlcOrgQueryPageWebService;
import com.tydic.logistics.web.bo.UlcOrgQueryPageWebServiceReqBo;
import com.tydic.logistics.web.bo.UlcOrgQueryPageWebServiceRspBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="ulcOrgQueryPageWebService")
@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="ULC_GROUP_LOCAL", serviceInterface=UlcOrgQueryPageWebService.class)
public class UlcOrgQueryPageWebServiceImpl
implements UlcOrgQueryPageWebService {
    private Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UlcInfoOrgMapper ulcInfoOrgMapper;
    @Autowired
    private UlcInfoBusiSysMapper ulcInfoBusiSysMapper;
    @Autowired
    private UlcInfoMerchantMapper ulcInfoMerchantMapper;
    @Autowired
    private UlcDicMapQueryAtomService ulcDicMapQueryAtomService;

    public UlcFrontBaseRspBo<UlcFrontPageRspBo<UlcOrgQueryPageWebServiceRspBo>> queryOrg(UlcOrgQueryPageWebServiceReqBo reqBo) {
        Page page;
        this.LOGGER.info("\u63a5\u5165\u673a\u6784\uff08\u5206\u9875\uff09\u67e5\u8be2 web\u670d\u52a1\uff1a" + reqBo);
        UlcFrontBaseRspBo retBo = new UlcFrontBaseRspBo();
        UlcFrontPageRspBo rspBo = new UlcFrontPageRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("5029");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        if (reqBo.getPageNo() != 1) {
            page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)page);
            if (page.getPageSize() < 1) {
                page.setPageSize(10);
            }
            if (page.getPageNo() < 1) {
                page.setPageNo(1);
            }
        }
        UlcInfoOrgPo qryOrgPo = new UlcInfoOrgPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryOrgPo);
        List orgList = this.ulcInfoOrgMapper.selectBySelectivePage(qryOrgPo, page);
        if (CollectionUtils.isEmpty((Collection)orgList)) {
            this.LOGGER.error("\u67e5\u8be2\u63a5\u5165\u673a\u6784\u5931\u8d25,\u672a\u67e5\u8be2\u5230\u76f8\u5173\u7684\u63a5\u5165\u673a\u6784");
            retBo.setRespCode("5029");
            retBo.setRespDesc("\u67e5\u8be2\u63a5\u5165\u673a\u6784\u5931\u8d25,\u672a\u67e5\u8be2\u5230\u76f8\u5173\u7684\u63a5\u5165\u673a\u6784");
            return retBo;
        }
        UlcDicMapQueryAtomReqBo qryDicBo = new UlcDicMapQueryAtomReqBo();
        qryDicBo.setpType("ACCESS_ORG_STATE");
        UlcDicMapQueryAtomRspBo dicValue = this.ulcDicMapQueryAtomService.queryDic(qryDicBo);
        Map valueMap = dicValue.getDataMap();
        ArrayList<UlcOrgQueryPageWebServiceRspBo> orgRspList = new ArrayList<UlcOrgQueryPageWebServiceRspBo>();
        for (UlcInfoOrgPo orgPo : orgList) {
            Long busiId;
            UlcInfoBusiSysPo busiSysPo;
            UlcOrgQueryPageWebServiceRspBo orgRsp = new UlcOrgQueryPageWebServiceRspBo();
            BeanUtils.copyProperties((Object)orgPo, (Object)orgRsp);
            orgRsp.setStatus((String)valueMap.get(orgRsp.getStatus()));
            Long merchantId = orgPo.getMerchantId();
            UlcInfoMerchantPo mchPo = this.ulcInfoMerchantMapper.selectByPrimaryKey(merchantId);
            if (mchPo != null) {
                orgRsp.setMerchantName(mchPo.getMerchantName());
            }
            if ((busiSysPo = this.ulcInfoBusiSysMapper.selectByPrimaryKey(busiId = orgPo.getBusiId())) != null) {
                orgRsp.setBusiName(busiSysPo.getBusiName());
            }
            orgRspList.add(orgRsp);
        }
        rspBo.setRows(orgRspList);
        rspBo.setPageNo(page.getPageNo());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setTotal(page.getTotalPages());
        retBo.setData((Object)rspBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArgs(UlcOrgQueryPageWebServiceReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

