/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.logistics.impl.web;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.logistics.dao.UlcRelMerchantLogisticsMapper;
import com.tydic.logistics.interfaces.busi.UlcRelCompanyAddBusiService;
import com.tydic.logistics.interfaces.busi.UlcRelCompanyDeleteBusiService;
import com.tydic.logistics.interfaces.busi.bo.UlcRelCompanyAddBusiServiceReqBo;
import com.tydic.logistics.interfaces.busi.bo.UlcRelCompanyAddBusiServiceRspBo;
import com.tydic.logistics.interfaces.busi.bo.UlcRelCompanyBusiServiceParamDataBo;
import com.tydic.logistics.web.UlcRelCompanyAddWebService;
import com.tydic.logistics.web.bo.UlcRelCompanyAddWebServiceReqBo;
import com.tydic.logistics.web.bo.UlcRelCompanyAddWebServiceRspBo;
import com.tydic.logistics.web.bo.UlcRelCompanyWebServiceParamDataBo;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="ulcMerchantAddCompanyWebService")
@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="ULC_GROUP_LOCAL", serviceInterface=UlcRelCompanyAddWebService.class)
public class UlcRelCompanyAddWebServiceImpl
implements UlcRelCompanyAddWebService {
    private Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UlcRelCompanyAddBusiService ulcRelCompanyAddBusiService;
    @Autowired
    private UlcRelCompanyDeleteBusiService ulcRelCompanyDeleteBusiService;
    @Autowired
    private UlcRelMerchantLogisticsMapper ulcRelMerchantLogisticsMapper;

    public UlcRelCompanyAddWebServiceRspBo addRelCompany(UlcRelCompanyAddWebServiceReqBo reqBo) {
        this.LOGGER.info("\u7269\u6d41\u5546\u6237\u6dfb\u52a0\u7269\u6d41\u516c\u53f8\uff1a" + reqBo);
        UlcRelCompanyAddWebServiceRspBo retBo = new UlcRelCompanyAddWebServiceRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("5026");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        UlcRelCompanyAddBusiServiceReqBo busiReqBo = new UlcRelCompanyAddBusiServiceReqBo();
        ArrayList<UlcRelCompanyBusiServiceParamDataBo> busiDataBoList = new ArrayList<UlcRelCompanyBusiServiceParamDataBo>();
        for (UlcRelCompanyWebServiceParamDataBo dataBo : reqBo.getParamDataList()) {
            UlcRelCompanyBusiServiceParamDataBo busiDataBo = new UlcRelCompanyBusiServiceParamDataBo();
            BeanUtils.copyProperties((Object)dataBo, (Object)busiDataBo);
            busiDataBoList.add(busiDataBo);
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)busiReqBo);
        busiReqBo.setProductList(reqBo.getProductList());
        busiReqBo.setParamDataList(busiDataBoList);
        UlcRelCompanyAddBusiServiceRspBo busiRspBo = this.ulcRelCompanyAddBusiService.addRelCompany(busiReqBo);
        retBo.setMerchantId(reqBo.getMerchantId() + "");
        if (!"0000".equals(busiRspBo.getRespCode())) {
            retBo.setRespCode("5026");
            retBo.setRespDesc("\u6dfb\u52a0\u5931\u8d25\uff1a" + busiRspBo.getRespDesc());
            return retBo;
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArgs(UlcRelCompanyAddWebServiceReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'merchantId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getCompanyId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'companyId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getLogisticsParamStatus())) {
            reqBo.setLogisticsParamStatus("1");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getParamDataList())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'paramDataList'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getProductList())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'productList'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaName())) {
            reqBo.setParaName("\u5546\u6237(" + reqBo.getMerchantId() + ")" + reqBo.getCompanyId() + "\u7684\u53c2\u6570");
        }
        return null;
    }
}

