/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.logistics.impl.web;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.logistics.dao.UlcInfoCompanyMapper;
import com.tydic.logistics.dao.UlcRelMerchantLogisticsMapper;
import com.tydic.logistics.dao.po.UlcInfoCompanyPo;
import com.tydic.logistics.dao.po.UlcRelMerchantLogisticsPo;
import com.tydic.logistics.web.UlcRelCompanyListQueryWebService;
import com.tydic.logistics.web.bo.UlcCompanyInfoWebServiceDataBo;
import com.tydic.logistics.web.bo.UlcRelCompanyListQueryWebServiceReqBo;
import com.tydic.logistics.web.bo.UlcRelCompanyListQueryWebServiceRspBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="ulcCompanyNormalQueryWebService")
@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="ULC_GROUP_LOCAL", serviceInterface=UlcRelCompanyListQueryWebService.class)
public class UlcRelCompanyListQueryWebServiceImpl
implements UlcRelCompanyListQueryWebService {
    private Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UlcInfoCompanyMapper ulcInfoCompanyMapper;
    @Autowired
    private UlcRelMerchantLogisticsMapper ulcRelMerchantLogisticsMapper;

    public UlcRelCompanyListQueryWebServiceRspBo queryCompany(UlcRelCompanyListQueryWebServiceReqBo reqBo) {
        this.LOGGER.info("\u7269\u6d41\u516c\u53f8\u67e5\u8be2\uff1a" + reqBo);
        UlcRelCompanyListQueryWebServiceRspBo retBo = new UlcRelCompanyListQueryWebServiceRspBo();
        ArrayList<UlcCompanyInfoWebServiceDataBo> companyList = new ArrayList<UlcCompanyInfoWebServiceDataBo>();
        retBo.setCompanyList(companyList);
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("5023");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        UlcInfoCompanyPo po = new UlcInfoCompanyPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)po);
        List allCompanyPo = this.ulcInfoCompanyMapper.selectByCondition(po);
        if (CollectionUtils.isEmpty((Collection)allCompanyPo)) {
            this.LOGGER.error("\u83b7\u53d6\u7269\u6d41\u516c\u53f8\u5217\u8868\u5931\u8d25");
            retBo.setRespCode("5023");
            retBo.setRespDesc("\u83b7\u53d6\u7269\u6d41\u516c\u53f8\u5217\u8868\u5931\u8d25");
            return retBo;
        }
        UlcRelMerchantLogisticsPo relPo = new UlcRelMerchantLogisticsPo();
        relPo.setMerchantId(Long.valueOf(reqBo.getMerchantId()));
        List relPoList = this.ulcRelMerchantLogisticsMapper.selectByRecord(relPo);
        HashSet<String> companySet = new HashSet<String>();
        for (UlcRelMerchantLogisticsPo rspPo : relPoList) {
            companySet.add(rspPo.getCompanyId());
        }
        if (!CollectionUtils.isEmpty((Collection)relPoList)) {
            Iterator iterator = allCompanyPo.iterator();
            while (iterator.hasNext()) {
                UlcInfoCompanyPo companyPo = (UlcInfoCompanyPo)iterator.next();
                for (String companyId : companySet) {
                    if (!companyId.equals(companyPo.getCompanyId())) continue;
                    iterator.remove();
                }
            }
        }
        for (UlcInfoCompanyPo companyPo : allCompanyPo) {
            UlcCompanyInfoWebServiceDataBo dataBo = new UlcCompanyInfoWebServiceDataBo();
            BeanUtils.copyProperties((Object)companyPo, (Object)dataBo);
            companyList.add(dataBo);
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArgs(UlcRelCompanyListQueryWebServiceReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'merchantId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

