/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.logistics.impl.web;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.logistics.dao.UlcInfoCompanyMapper;
import com.tydic.logistics.dao.UlcInfoLogisticsParaAttrMapper;
import com.tydic.logistics.dao.UlcRelMerchantLogisticsMapper;
import com.tydic.logistics.dao.po.UlcInfoCompanyPo;
import com.tydic.logistics.dao.po.UlcInfoLogisticsParaAttrPo;
import com.tydic.logistics.dao.po.UlcRelMerchantLogisticsPo;
import com.tydic.logistics.web.UlcRelCompanyQueryInfoWebService;
import com.tydic.logistics.web.bo.UlcRelCompanyQueryInfoWebServiceParamAttrBo;
import com.tydic.logistics.web.bo.UlcRelCompanyQueryInfoWebServiceReqBo;
import com.tydic.logistics.web.bo.UlcRelCompanyQueryInfoWebServiceRspBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="ulcRelCompanyQueryInfoWebService")
@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="ULC_GROUP_LOCAL", serviceInterface=UlcRelCompanyQueryInfoWebService.class)
public class UlcRelCompanyQueryInfoWebServiceImpl
implements UlcRelCompanyQueryInfoWebService {
    private Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UlcRelMerchantLogisticsMapper ulcRelMerchantLogisticsMapper;
    @Autowired
    private UlcInfoLogisticsParaAttrMapper ulcInfoLogisticsParaAttrMapper;
    @Autowired
    private UlcInfoCompanyMapper ulcInfoCompanyMapper;

    public UlcRelCompanyQueryInfoWebServiceRspBo qryRelCompanyInfo(UlcRelCompanyQueryInfoWebServiceReqBo reqBo) {
        this.LOGGER.info("\u67e5\u8be2\u5546\u6237\u914d\u7f6e\u7684\u7269\u6d41\u516c\u53f8\u4fe1\u606f\uff1a" + reqBo);
        UlcRelCompanyQueryInfoWebServiceRspBo retBo = new UlcRelCompanyQueryInfoWebServiceRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("5027");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        UlcInfoCompanyPo companyPo = this.ulcInfoCompanyMapper.selectByPrimaryKey(reqBo.getCompanyId());
        if (companyPo == null) {
            this.LOGGER.error("\u67e5\u8be2\u7269\u6d41\u516c\u53f8\u4fe1\u606f\u5931\u8d25");
            retBo.setRespCode("5027");
            retBo.setRespDesc("\u67e5\u8be2\u7269\u6d41\u516c\u53f8\u4fe1\u606f\u5931\u8d25");
            return retBo;
        }
        retBo.setCompanyName(companyPo.getCompanyName());
        UlcRelMerchantLogisticsPo qryPo = new UlcRelMerchantLogisticsPo();
        qryPo.setMerchantId(Long.valueOf(reqBo.getMerchantId()));
        qryPo.setCompanyId(reqBo.getCompanyId());
        List relPos = this.ulcRelMerchantLogisticsMapper.selectByRecord(qryPo);
        if (CollectionUtils.isEmpty((Collection)relPos)) {
            this.LOGGER.error("\u67e5\u8be2\u7269\u6d41\u5173\u7cfb\u8868\u5931\u8d25");
            retBo.setRespCode("5027");
            retBo.setRespDesc("\u67e5\u8be2\u7269\u6d41\u5173\u7cfb\u8868\u5931\u8d25");
            return retBo;
        }
        ArrayList<String> productIds = new ArrayList<String>();
        for (UlcRelMerchantLogisticsPo relPo : relPos) {
            String productId = relPo.getProductId();
            productIds.add(productId);
        }
        retBo.setRelProductList(productIds);
        long logisticsParamId = ((UlcRelMerchantLogisticsPo)relPos.get(0)).getLogisticsParaId();
        List paramList = this.ulcInfoLogisticsParaAttrMapper.selectByLogisticsParaId(Long.valueOf(logisticsParamId));
        if (CollectionUtils.isEmpty((Collection)paramList)) {
            this.LOGGER.error("\u67e5\u8be2\u5546\u6237\u914d\u7f6e\u7684\u7269\u6d41\u516c\u53f8\u53c2\u6570\u5931\u8d25");
            retBo.setRespCode("5027");
            retBo.setRespDesc("\u67e5\u8be2\u5546\u6237\u914d\u7f6e\u7684\u7269\u6d41\u516c\u53f8\u53c2\u6570\u5931\u8d25");
            return retBo;
        }
        ArrayList<UlcRelCompanyQueryInfoWebServiceParamAttrBo> attrList = new ArrayList<UlcRelCompanyQueryInfoWebServiceParamAttrBo>();
        for (UlcInfoLogisticsParaAttrPo paraAttrPo : paramList) {
            UlcRelCompanyQueryInfoWebServiceParamAttrBo attrBo = new UlcRelCompanyQueryInfoWebServiceParamAttrBo();
            attrBo.setAttrCode(paraAttrPo.getAttrCode());
            attrBo.setAttrValue(paraAttrPo.getAttrValue());
            attrList.add(attrBo);
        }
        retBo.setParamList(attrList);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArgs(UlcRelCompanyQueryInfoWebServiceReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getCompanyId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'companyId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'merchantId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

