/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.logistics.impl.web;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.tydic.logistics.common.base.UlcFrontBaseRspBo;
import com.tydic.logistics.common.base.UlcFrontPageRspBo;
import com.tydic.logistics.dao.UlcInfoCompanyMapper;
import com.tydic.logistics.dao.UlcInfoProductMapper;
import com.tydic.logistics.dao.UlcRelMerchantLogisticsMapper;
import com.tydic.logistics.dao.po.UlcInfoCompanyPo;
import com.tydic.logistics.dao.po.UlcInfoProductPo;
import com.tydic.logistics.dao.po.UlcRelMerchantLogisticsPo;
import com.tydic.logistics.web.UlcRelCompanyQueryWebService;
import com.tydic.logistics.web.bo.UlcRelCompanyQueryWebServiceReqBo;
import com.tydic.logistics.web.bo.UlcRelCompanyQueryWebServiceRspBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="ulcRelCompanyQueryWevService")
@HSFProvider(serviceVersion="1.0-SNAPSHOT", serviceGroup="ULC_GROUP_LOCAL", serviceInterface=UlcRelCompanyQueryWebService.class)
public class UlcRelCompanyQueryWebServiceImpl
implements UlcRelCompanyQueryWebService {
    private Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UlcRelMerchantLogisticsMapper ulcRelMerchantLogisticsMapper;
    @Autowired
    private UlcInfoCompanyMapper ulcInfoCompanyMapper;
    @Autowired
    private UlcInfoProductMapper ulcInfoProductMapper;

    public UlcFrontBaseRspBo<UlcFrontPageRspBo<UlcRelCompanyQueryWebServiceRspBo>> queryRelCompany(UlcRelCompanyQueryWebServiceReqBo reqBo) {
        this.LOGGER.info("\u7269\u6d41\u4e2d\u5fc3\u5546\u6237\u5173\u8054\u7269\u6d41\u516c\u53f8\u67e5\u8be2\uff1a" + JSONObject.toJSONString((Object)reqBo));
        UlcFrontBaseRspBo retBo = new UlcFrontBaseRspBo();
        UlcFrontPageRspBo rspBo = new UlcFrontPageRspBo();
        String validateStr = this.validateAegs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("5022");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        UlcRelMerchantLogisticsPo relReqPo = new UlcRelMerchantLogisticsPo();
        relReqPo.setMerchantId(Long.valueOf(reqBo.getMerchantId()));
        List relPoList = this.ulcRelMerchantLogisticsMapper.selectByRecord(relReqPo);
        if (CollectionUtils.isEmpty((Collection)relPoList)) {
            this.LOGGER.error("\u672a\u67e5\u8be2\u5230\u6b64\u7269\u6d41\u5546\u6237\u914d\u7f6e\u7684\u7269\u6d41\u516c\u53f8");
            retBo.setRespCode("5022");
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u6b64\u7269\u6d41\u5546\u6237\u914d\u7f6e\u7684\u7269\u6d41\u516c\u53f8");
            return retBo;
        }
        HashSet<String> companyIdSet = new HashSet<String>();
        HashMap<String, String> productMap = new HashMap<String, String>(16);
        for (UlcRelMerchantLogisticsPo relPo : relPoList) {
            companyIdSet.add(relPo.getCompanyId());
            productMap.put(relPo.getProductId(), relPo.getCompanyId());
        }
        ArrayList<UlcRelCompanyQueryWebServiceRspBo> relRspBoList = new ArrayList<UlcRelCompanyQueryWebServiceRspBo>();
        for (String companyId : companyIdSet) {
            UlcRelCompanyQueryWebServiceRspBo relRspBo = new UlcRelCompanyQueryWebServiceRspBo();
            UlcInfoCompanyPo companyPo = this.ulcInfoCompanyMapper.selectByPrimaryKey(companyId);
            if (companyPo == null) {
                this.LOGGER.error("\u672a\u67e5\u8be2\u5230\u8be5\u516c\u53f8ID\uff08" + companyId + "\uff09\u7684\u4fe1\u606f");
                continue;
            }
            relRspBo.setCompanyId(companyId);
            relRspBo.setCompanyName(companyPo.getCompanyName());
            StringBuilder stringBuilder = new StringBuilder();
            Iterator it = productMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!companyId.equals(entry.getValue())) continue;
                UlcInfoProductPo productPo = this.ulcInfoProductMapper.selectByPrimaryKey((String)entry.getKey());
                it.remove();
                if (productPo == null) {
                    this.LOGGER.error("\u672a\u67e5\u8be2\u5230\u8be5\u4ea7\u54c1ID(" + (String)entry.getKey() + ")\u7684\u4fe1\u606f");
                    continue;
                }
                stringBuilder.append(productPo.getProductName()).append("\uff0c");
            }
            if (stringBuilder.length() > 1) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            relRspBo.setProduct(stringBuilder.toString());
            relRspBoList.add(relRspBo);
        }
        rspBo.setRows(relRspBoList);
        retBo.setData((Object)rspBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateAegs(UlcRelCompanyQueryWebServiceReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027merchantId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

