/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.cloud.common.base.exception;

import java.util.Arrays;

public class McmpBusinessException
extends RuntimeException {
    private static final long serialVersionUID = -1814155355569144196L;
    private String msgCode;
    private String errorMsg;
    private String[] args;

    public McmpBusinessException(String msgId, String message) {
        super(message);
        this.msgCode = msgId;
    }

    public McmpBusinessException(String msgId, String message, Throwable cause) {
        super(message, cause);
        this.args = new String[1];
        this.args[0] = message;
        this.msgCode = msgId;
        this.errorMsg = message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McmpBusinessException)) {
            return false;
        }
        McmpBusinessException other = (McmpBusinessException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$msgCode = this.getMsgCode();
        String other$msgCode = other.getMsgCode();
        if (this$msgCode == null ? other$msgCode != null : !this$msgCode.equals(other$msgCode)) {
            return false;
        }
        String this$errorMsg = this.getErrorMsg();
        String other$errorMsg = other.getErrorMsg();
        if (this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg)) {
            return false;
        }
        return Arrays.deepEquals(this.getArgs(), other.getArgs());
    }

    protected boolean canEqual(Object other) {
        return other instanceof McmpBusinessException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $msgCode = this.getMsgCode();
        result = result * 59 + ($msgCode == null ? 43 : $msgCode.hashCode());
        String $errorMsg = this.getErrorMsg();
        result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getArgs());
        return result;
    }

    public String getMsgCode() {
        return this.msgCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public String[] getArgs() {
        return this.args;
    }

    public void setMsgCode(String msgCode) {
        this.msgCode = msgCode;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    @Override
    public String toString() {
        return "McmpBusinessException(msgCode=" + this.getMsgCode() + ", errorMsg=" + this.getErrorMsg() + ", args=" + Arrays.deepToString(this.getArgs()) + ")";
    }
}

