/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.active.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
public class ObjectConvertor {
    public <K, V> V toAnotherObj(K oneObj, Class<V> anotherClassObj) {
        return this.toAnotherObj(oneObj, anotherClassObj, null);
    }

    public <K, V> V toAnotherObj(K oneObj, Class<V> anotherClassObj, ReflectionUtils.FieldFilter filter) {
        V anotherObj = null;
        try {
            Field[] fields;
            anotherObj = anotherClassObj.newInstance();
            Class<?> oneClassObj = oneObj.getClass();
            for (Field field : fields = this.getMatchedFields(oneClassObj, filter)) {
                String fieldName = field.getName();
                String append = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
                String getMethodName = "get" + append;
                String setMethodName = "set" + append;
                Method getMethod = oneClassObj.getDeclaredMethod(getMethodName, new Class[0]);
                getMethod.setAccessible(true);
                Object attrForOneObj = getMethod.invoke(oneObj, new Object[0]);
                Method setMethod = anotherClassObj.getDeclaredMethod(setMethodName, field.getType());
                setMethod.setAccessible(true);
                setMethod.invoke(anotherObj, attrForOneObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return anotherObj;
    }

    private Field[] getMatchedFields(Class<?> classObj, ReflectionUtils.FieldFilter filter) {
        Field[] fields;
        ArrayList<Field> matchedFields = new ArrayList<Field>();
        for (Field field : fields = classObj.getDeclaredFields()) {
            if (null != filter) continue;
            matchedFields.add(field);
        }
        return matchedFields.toArray(new Field[0]);
    }
}

