/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.dao.active.ActiveExclusionRuleDao;
import com.tydic.newretail.dao.active.ActiveGiftDao;
import com.tydic.newretail.dao.active.ActiveRuleDao;
import com.tydic.newretail.dao.active.ActiveSkuDao;
import com.tydic.newretail.dao.active.ActivityDao;
import com.tydic.newretail.dao.active.po.ActiveExclusionRulePo;
import com.tydic.newretail.dao.active.po.ActiveGiftPo;
import com.tydic.newretail.dao.active.po.ActiveRulePo;
import com.tydic.newretail.dao.active.po.ActiveSkuPo;
import com.tydic.newretail.dao.active.po.ActivityPo;
import com.tydic.newretail.service.ability.active.ActiveCountAbilityService;
import com.tydic.newretail.service.ability.active.bo.ActiveBo;
import com.tydic.newretail.service.ability.active.bo.ActiveGiftBo;
import com.tydic.newretail.service.ability.active.bo.ActiveReqBo;
import com.tydic.newretail.service.ability.active.bo.ActiveRspBo;
import com.tydic.newretail.service.ability.active.bo.ActiveSkuBo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="activeCountAbilityService")
public class ActiveCountAbilityServiceImpl
implements ActiveCountAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ActiveCountAbilityServiceImpl.class);
    @Resource(name="activityDao")
    private ActivityDao activityDao;
    @Resource(name="activeRuleDao")
    private ActiveRuleDao activeRuleDao;
    @Resource(name="activeSkuDao")
    private ActiveSkuDao activeSkuDao;
    @Resource(name="activeExclusionRuleDao")
    private ActiveExclusionRuleDao activeExclusionRuleDao;
    @Resource(name="activeGiftDao")
    private ActiveGiftDao activeGiftDao;

    public ActiveRspBo activeContent(ActiveReqBo activereq) {
        Date obtainTime = Calendar.getInstance().getTime();
        log.info("\u63a5\u6536\u5230\u6d3b\u52a8\u5904\u7406\u8bf7\u6c42\uff1a" + activereq.toString() + "\u6536\u5230\u8bf7\u6c42\u7cfb\u7edf\u65f6\u95f4\u4e3a\uff1a" + obtainTime + "\u8bf7\u6c42\u6d41\u6c34\uff1a" + activereq.getSeriesNo());
        String respCode = "0000";
        String respDesc = "SUCCESS";
        ActiveRspBo aciveRsp = new ActiveRspBo();
        aciveRsp.setRespCode(respCode);
        aciveRsp.setRespDesc(respDesc);
        BigDecimal disTotalAmo = new BigDecimal(0);
        List skuActiveRsp = null;
        List giftActivesRsp = null;
        try {
            Timestamp reqtime = activereq.getQueryTime();
            List skuActives = activereq.getSkuActiveArray();
            List giftActives = activereq.getGiftActiveArray();
            this.dealSkuArray(skuActives, reqtime, disTotalAmo);
            this.dealOrderArray(giftActives, reqtime);
            skuActiveRsp = skuActives;
            giftActivesRsp = giftActives;
        }
        catch (BusinessException e) {
            log.error(e.getMessage(), (Throwable)e);
            respCode = e.getMsgCode();
            respDesc = e.getMsgInfo();
            return aciveRsp;
        }
        aciveRsp.setRespTime(new Timestamp(System.currentTimeMillis()));
        aciveRsp.setSkuActiveArray(skuActiveRsp);
        aciveRsp.setGiftActiveArray(giftActivesRsp);
        aciveRsp.setTotalAmount(activereq.getTotalAmount());
        aciveRsp.setDisTotalAmo(disTotalAmo);
        log.info("\u6d3b\u52a8\u4ef7\u683c\u8ba1\u7b97\u5b8c\u6210\uff1a" + aciveRsp.toString() + "\u53cd\u9988\u8bf7\u6c42\u7cfb\u7edf\u65f6\u95f4\u4e3a\uff1a" + Calendar.getInstance().getTime() + "\u8bf7\u6c42\u6d41\u6c34\uff1a" + activereq.getSeriesNo());
        return aciveRsp;
    }

    private void dealOrderArray(List<ActiveBo> giftActives, Timestamp reqtime) {
        try {
            if (giftActives == null || giftActives.isEmpty()) {
                return;
            }
            for (ActiveBo giftActive : giftActives) {
                ActivityPo activityPo = this.activityDao.getActivityById(giftActive.getActiveId());
                if (activityPo == null) {
                    throw new BusinessException("8300", "\u6d3b\u52a8\u5df2\u5931\u6548");
                }
                if (!"gift".equals(activityPo.getActiveType())) continue;
                Set activeGifts = giftActive.getGiftArray();
                if (activeGifts == null || activeGifts.isEmpty()) {
                    throw new BusinessException("8300", "\u8d60\u54c1\u6d3b\u52a8\u65e0\u8d60\u54c1");
                }
                for (ActiveGiftBo activeGift : activeGifts) {
                    List<ActiveGiftPo> activeGiftps = this.activeGiftDao.getGiftActiveByAssId(activeGift.getSkuId(), activityPo.getActiveId());
                    if (activeGiftps == null || activeGiftps.isEmpty()) {
                        throw new BusinessException("8300", "\u8be5\u8d60\u54c1\u65e0\u8d60\u54c1\u6d3b\u52a8");
                    }
                    Integer giftSkuNum = activeGift.getActiveGiftSkuNum();
                    HashMap<Integer, ActiveGiftPo> excMap = new HashMap<Integer, ActiveGiftPo>();
                    for (ActiveGiftPo activeGiftp : activeGiftps) {
                        if (activeGiftp.getAlCount().compareTo(giftSkuNum) < 0) {
                            throw new BusinessException("8300", "\u8d60\u54c1\u6570\u8d85\u8fc7\u6700\u5927\u5141\u8bb8\u8d60\u9001\u6570");
                        }
                        if (activeGiftp.getGiftCount() - activeGiftp.getSendCount() - giftSkuNum < 0) {
                            throw new BusinessException("8300", "\u8d60\u54c1\u5e93\u5b58\u4e0d\u8db3\uff0c\u8fd8\u6709\u8d60\u54c1" + (activeGiftp.getGiftCount() - activeGiftp.getSendCount()) + "\u4ef6");
                        }
                        if (activeGiftp.getExcluseMark() != -1) {
                            if (excMap.containsKey(activeGiftp.getExcluseMark())) {
                                ActiveGiftPo activeGiftPo = (ActiveGiftPo)excMap.get(activeGiftp.getExcluseMark());
                                throw new BusinessException("8300", "\u8d60\u54c1" + activeGiftPo.getSkuId() + "\u548c\u8d60\u54c1" + activeGiftp.getSkuId() + "\u4e0d\u80fd\u540c\u65f6\u8d60\u9001");
                            }
                            excMap.put(activeGiftp.getExcluseMark(), activeGiftp);
                        }
                        activeGiftp.setTheNumber(giftSkuNum);
                    }
                }
            }
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BusinessException("9999", "\u7cfb\u7edf\u5185\u90e8\u51fa\u9519");
        }
    }

    private int dealSkuArray(List<ActiveSkuBo> skuActives, Timestamp reqtime, BigDecimal disTotalAmo) throws BusinessException {
        try {
            if (skuActives == null || skuActives.isEmpty()) {
                return -1;
            }
            HashMap<Long, List<ActiveSkuBo>> active3Map = new HashMap<Long, List<ActiveSkuBo>>();
            for (ActiveSkuBo skuActive : skuActives) {
                skuActive.setSkuSubtotal(skuActive.getSkuPrice().multiply(skuActive.getSkuNum()));
                List activeBos = skuActive.getSkuActiveArray();
                if (activeBos == null || activeBos.isEmpty()) continue;
                if (this.mutexCheck(activeBos)) {
                    // empty if block
                }
                block24: for (ActiveBo activeBo : activeBos) {
                    ActivityPo activity = this.activityDao.getActivityById(activeBo.getActiveId());
                    if (activity == null) {
                        throw new BusinessException("8300", "\u6d3b\u52a8\u5df2\u5931\u6548");
                    }
                    ArrayList<ActiveRulePo> activeRules = new ArrayList<ActiveRulePo>();
                    if (!this.cheackActiveRule(activity, activeRules, reqtime)) {
                        throw new BusinessException("8300", "\u6d3b\u52a8\uff1a\u6d3b\u52a8id[" + activity.getActiveId() + "]\u672a\u914d\u7f6e\u6d3b\u52a8\u89c4\u5219");
                    }
                    if (activeRules.isEmpty()) {
                        throw new BusinessException("8300", "\u6d3b\u52a8\uff1a\u6d3b\u52a8id[" + activity.getActiveId() + "]\u672a\u914d\u7f6e\u6d3b\u52a8\u89c4\u5219");
                    }
                    switch (activity.getActiveType()) {
                        case "0": {
                            continue block24;
                        }
                        case "1": {
                            this.dealSkuActive(skuActive, activity, activeRules, reqtime, disTotalAmo);
                            continue block24;
                        }
                        case "2": {
                            continue block24;
                        }
                        case "3": {
                            if (active3Map.containsKey(activeBo.getActiveId())) {
                                ((List)active3Map.get(activeBo.getActiveId())).add(skuActive);
                                continue block24;
                            }
                            active3Map.put(activeBo.getActiveId(), new ArrayList());
                            ((List)active3Map.get(activeBo.getActiveId())).add(skuActive);
                            continue block24;
                        }
                        case "4": {
                            continue block24;
                        }
                        case "5": {
                            continue block24;
                        }
                        case "6": {
                            continue block24;
                        }
                        case "7": {
                            continue block24;
                        }
                    }
                    throw new BusinessException("8300", "\u672a\u5b9a\u4e49\u7684\u6d3b\u52a8\u7c7b\u578b");
                }
            }
            this.dealActive3(active3Map, reqtime, disTotalAmo);
            return 0;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BusinessException("9999", "\u7cfb\u7edf\u5185\u90e8\u51fa\u9519");
        }
    }

    private void dealActive3(Map<Long, List<ActiveSkuBo>> active3Map, Timestamp reqtime, BigDecimal disTotalAmo) {
        if (active3Map == null || active3Map.isEmpty()) {
            return;
        }
        for (Long activeId : active3Map.keySet()) {
            List<ActiveSkuBo> activeSkus = active3Map.get(activeId);
            BigDecimal subtotal = new BigDecimal(0);
            for (ActiveSkuBo activeSku : activeSkus) {
                subtotal = subtotal.add(activeSku.getSkuSubtotal());
            }
            BigDecimal subtotalTmp = subtotal;
            ArrayList<ActiveRulePo> activeRules = new ArrayList<ActiveRulePo>();
            this.cheackActiveRule(activeId, activeRules, reqtime);
            for (ActiveRulePo activeRule : activeRules) {
                Timestamp endTime;
                Timestamp startTime = activeRule.getStartTime();
                if (!this.timeCompare(startTime, endTime = activeRule.getEndTime(), reqtime) || activeRule.getStatus().equals(0)) continue;
                switch (activeRule.getRuleType()) {
                    case "0": {
                        this.moneyOff(activeRule, subtotal);
                        break;
                    }
                }
            }
            disTotalAmo = disTotalAmo.add(subtotalTmp.subtract(subtotal));
        }
    }

    private boolean mutexCheck(List<ActiveBo> activeBos) {
        HashSet<ActiveExclusionRulePo> mutexSet = new HashSet<ActiveExclusionRulePo>();
        for (ActiveBo activeBo : activeBos) {
            List<ActiveExclusionRulePo> mutexRules = this.activeExclusionRuleDao.getMutexRuleById(activeBo.getActiveId());
            mutexSet.addAll(mutexRules);
        }
        return true;
    }

    private void dealSkuActive(ActiveSkuBo skuActive, ActivityPo activity, List<ActiveRulePo> activeRules, Timestamp reqTime, BigDecimal disTotalAmo) {
        Long skuId = skuActive.getSkuId();
        List<ActiveSkuPo> actibeSkusTmp = this.activeSkuDao.getSkuActiveByAssId(skuId, activity.getActiveId());
        if (actibeSkusTmp == null || actibeSkusTmp.isEmpty()) {
            throw new BusinessException("8300", "\u5355\u54c1" + skuId + "\u6d3b\u52a8" + activity.getActiveName() + "\u5df2\u5931\u6548");
        }
        ArrayList<ActiveSkuPo> actibeSkus = new ArrayList<ActiveSkuPo>();
        for (ActiveSkuPo actibeSku : actibeSkusTmp) {
            Timestamp endTime;
            Timestamp startTime = actibeSku.getStartTime();
            if (!this.timeCompare(startTime, endTime = actibeSku.getEndTime(), reqTime)) continue;
            actibeSkus.add(actibeSku);
        }
        if (actibeSkus.isEmpty()) {
            throw new BusinessException("8300", "\u5355\u54c1" + skuId + "\u6d3b\u52a8" + activity.getActiveName() + "\u5df2\u5931\u6548");
        }
        actibeSkusTmp.clear();
        for (ActiveRulePo activeRule : activeRules) {
            switch (activeRule.getRuleType()) {
                case "0": {
                    this.moneyOffSku(activeRule, skuActive, disTotalAmo);
                    break;
                }
            }
        }
    }

    private void moneyOffSku(ActiveRulePo activeRule, ActiveSkuBo skuActive, BigDecimal disTotalAmo) {
        BigDecimal subtotal = skuActive.getSkuSubtotal();
        this.moneyOff(activeRule, subtotal);
        disTotalAmo = disTotalAmo.add(skuActive.getSkuPrice().multiply(skuActive.getSkuNum()).subtract(subtotal));
        skuActive.setSkuSubtotal(subtotal);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void moneyOff(ActiveRulePo activeRule, BigDecimal subtotal) {
        try {
            String ruleType = activeRule.getRuleType();
            String start = ruleType.substring(0, 1);
            ruleType = ruleType.substring(1, ruleType.length());
            if ("-".equals(start)) {
                String[] moneyOffUnits = ruleType.split(";");
                for (int i = moneyOffUnits.length; i >= 0; --i) {
                    BigDecimal der;
                    BigDecimal min;
                    String moneyOffUnit = moneyOffUnits[i];
                    String[] monOffs = moneyOffUnit.split(",");
                    if (i == moneyOffUnits.length) {
                        min = new BigDecimal(monOffs[0]);
                        der = new BigDecimal(monOffs[1]);
                        if (min.compareTo(subtotal) > 0) continue;
                        subtotal = subtotal.subtract(der);
                        return;
                    } else {
                        min = new BigDecimal(monOffs[0]);
                        der = new BigDecimal(monOffs[2]);
                        if (min.compareTo(subtotal) > 0) continue;
                        subtotal = subtotal.subtract(der);
                    }
                    return;
                }
                return;
            }
            if ("/".equals(start)) {
                String[] moneyOffUnit = ruleType.split(",");
                BigDecimal divi = new BigDecimal(moneyOffUnit[0]);
                BigDecimal der = new BigDecimal(moneyOffUnit[1]);
                BigDecimal res = subtotal.divide(divi, 0, RoundingMode.DOWN);
                subtotal = subtotal.subtract(der.multiply(res));
                return;
            }
            if (!"T".equals(start)) return;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BusinessException("9999", "\u7cfb\u7edf\u5185\u90e8\u5f02\u5e38");
        }
    }

    private boolean cheackActiveRule(Long activityId, List<ActiveRulePo> activeRules, Timestamp reqtime) {
        List<ActiveRulePo> activeRuleTmps = this.activeRuleDao.getActiveRuleByActiveId(activityId);
        if (activeRuleTmps == null || activeRuleTmps.isEmpty()) {
            log.error("\u672a\u83b7\u5f97\u53bb\u5230\u6d3b\u52a8\u89c4\u5219\uff0c\u6d3b\u52a8id\uff1a" + activityId);
            return false;
        }
        for (ActiveRulePo activeRuleTmp : activeRuleTmps) {
            Timestamp endTime;
            Timestamp startTime = activeRuleTmp.getStartTime();
            if (!this.timeCompare(startTime, endTime = activeRuleTmp.getEndTime(), reqtime) || activeRuleTmp.getStatus().equals(0)) continue;
            activeRules.add(activeRuleTmp);
        }
        return true;
    }

    private boolean cheackActiveRule(ActivityPo activity, List<ActiveRulePo> activeRules, Timestamp reqtime) {
        if ("1".equals(activity.getIsDelete())) {
            log.error("\u6d3b\u52a8\u5df2\u53d6\u6d88\uff0c\u6d3b\u52a8id\uff1a" + activity.getActiveId());
            return false;
        }
        return this.cheackActiveRule(activity.getActiveId(), activeRules, reqtime);
    }

    private boolean timeCompare(Timestamp startTime, Timestamp endTime, Timestamp reqtime) {
        return startTime.compareTo(reqtime) <= 0 && endTime.compareTo(reqtime) > 0;
    }

    public ActiveSkuDao getActiveSkuDao() {
        return this.activeSkuDao;
    }

    public void setActiveSkuDao(ActiveSkuDao activeSkuDao) {
        this.activeSkuDao = activeSkuDao;
    }

    public ActiveGiftDao getActiveGiftDao() {
        return this.activeGiftDao;
    }

    public void setActiveGiftDao(ActiveGiftDao activeGiftDao) {
        this.activeGiftDao = activeGiftDao;
    }
}

